/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.painter;

import java.awt.Dimension;
import java.awt.Graphics;
import oracle.bali.ewt.painter.AbstractWrappingPainter;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.Painter;

public class FixedSizePainter
extends AbstractWrappingPainter {
    public static final int WIDTH_UNFIXED = -1;
    public static final int HEIGHT_UNFIXED = -1;
    private int _width;
    private int _height;
    private boolean _isFloating;

    public FixedSizePainter(int width, int height) {
        this(null, width, height);
    }

    public FixedSizePainter(Painter wrappedPainter, int width, int height) {
        super(wrappedPainter);
        this._width = width;
        this._height = height;
        this._isFloating = wrappedPainter != null && width == -1 || height == -1;
    }

    @Override
    public Dimension getSize(PaintContext context, int availableWidth, int availableHeight) {
        Dimension size = this._isFloating ? super.getSize(context, availableWidth, availableHeight) : new Dimension(availableWidth, availableHeight);
        this._adjustSize(size);
        return size;
    }

    @Override
    public Dimension getPreferredSize(PaintContext context) {
        Dimension preferredSize = this._isFloating ? super.getPreferredSize(context) : new Dimension(1, 1);
        this._adjustSize(preferredSize);
        return preferredSize;
    }

    @Override
    public Dimension getMinimumSize(PaintContext context) {
        Dimension minimumSize = this._isFloating ? super.getMinimumSize(context) : new Dimension(1, 1);
        this._adjustSize(minimumSize);
        return minimumSize;
    }

    @Override
    public Dimension getMaximumSize(PaintContext context) {
        Dimension maximumSize = this._isFloating ? super.getMaximumSize(context) : new Dimension(Short.MAX_VALUE, Short.MAX_VALUE);
        this._adjustSize(maximumSize);
        return maximumSize;
    }

    @Override
    public void paint(PaintContext context, Graphics g, int x, int y, int width, int height) {
        Dimension inSize = new Dimension(width, height);
        this._adjustSize(inSize);
        if (inSize.width > 0 && inSize.height > 0) {
            super.paint(context, g, x, y, inSize.width, inSize.height);
        }
    }

    @Override
    public Painter getPainterAt(PaintContext context, int availableWidth, int availableHeight, int x, int y, Painter proxyPainter) {
        Dimension inSize = new Dimension(availableWidth, availableHeight);
        this._adjustSize(inSize);
        return super.getPainterAt(context, inSize.width, inSize.height, x, y, proxyPainter);
    }

    @Override
    public int getRepaintFlags(PaintContext context) {
        int flags = super.getRepaintFlags(context);
        if (!this._isFloating) {
            flags &= 0xFFFFFF7F;
        }
        return flags;
    }

    @Override
    public int getInvalidateFlags(PaintContext context) {
        int flags = super.getInvalidateFlags(context);
        if (!this._isFloating) {
            flags &= 0xFFFFFF7F;
        }
        return flags;
    }

    private void _adjustSize(Dimension size) {
        if (this._width != -1) {
            size.width = this._width;
        }
        if (this._height != -1) {
            size.height = this._height;
        }
    }
}

