/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.painter;

import java.awt.Dimension;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.Painter;

public abstract class AbstractPainter
implements Painter {
    @Override
    public Dimension getSize(PaintContext context, int availableWidth, int availableHeight) {
        return new Dimension(availableWidth, availableHeight);
    }

    @Override
    public Dimension getPreferredSize(PaintContext context) {
        return this.getMinimumSize(context);
    }

    @Override
    public Dimension getMaximumSize(PaintContext context) {
        return new Dimension(Short.MAX_VALUE, Short.MAX_VALUE);
    }

    @Override
    public final boolean contains(PaintContext context, int availableWidth, int availableHeight, int x, int y) {
        return this.getPainterAt(context, availableWidth, availableHeight, x, y, null) != null;
    }

    @Override
    public Painter getPainterAt(PaintContext context, int availableWidth, int availableHeight, int x, int y, Painter proxyPainter) {
        boolean isInside = false;
        if (x >= 0 && y >= 0 && x < availableWidth && y < availableHeight) {
            Dimension size = this.getSize(context, availableWidth, availableHeight);
            boolean bl = isInside = x < size.width && y < size.height;
        }
        if (isInside) {
            return this;
        }
        return null;
    }

    @Override
    public boolean isTransparent(PaintContext context) {
        return false;
    }

    @Override
    public int getRepaintFlags(PaintContext context) {
        return 0;
    }

    @Override
    public int getInvalidateFlags(PaintContext context) {
        return 0;
    }

    protected Object getData(PaintContext context) {
        return context.getPaintData(this.getDataKey());
    }

    protected Object getDataKey() {
        return null;
    }
}

