/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.painter;

import java.awt.Dimension;
import java.awt.Graphics;
import oracle.bali.ewt.painter.AbstractWrappingPainter;
import oracle.bali.ewt.painter.BorderPainter;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.util.ImmInsets;

public abstract class AbstractBorderPainter
extends AbstractWrappingPainter
implements BorderPainter {
    private BorderPainter _wrappedBorderPainter;
    private boolean _alwaysAddInsets;

    public AbstractBorderPainter() {
        this._init(null, true);
    }

    public AbstractBorderPainter(Painter wrappedPainter) {
        this(wrappedPainter, true);
    }

    public AbstractBorderPainter(Painter wrappedPainter, boolean alwaysAddInsets) {
        super(wrappedPainter);
        this._init(wrappedPainter, alwaysAddInsets);
    }

    @Override
    public final Dimension getSize(PaintContext context, int width, int height) {
        ImmInsets borderInsets = this.getOwnInsets(context);
        return this._addInsets(context, super.getSize(context, width -= borderInsets.left + borderInsets.right, height -= borderInsets.top + borderInsets.bottom));
    }

    @Override
    public Dimension getPreferredSize(PaintContext context) {
        return this._addInsets(context, super.getPreferredSize(context));
    }

    @Override
    public Dimension getMinimumSize(PaintContext context) {
        return this._addInsets(context, super.getMinimumSize(context));
    }

    @Override
    public Dimension getMaximumSize(PaintContext context) {
        return this._addInsets(context, super.getMaximumSize(context));
    }

    @Override
    public final void paint(PaintContext context, Graphics g, int x, int y, int width, int height) {
        this.paintBorder(context, g, x, y, width, height);
        ImmInsets borderSizes = this.getOwnInsets(context);
        super.paint(context, g, x + borderSizes.left, y + borderSizes.top, width - borderSizes.left - borderSizes.right, height - borderSizes.top - borderSizes.bottom);
    }

    @Override
    public final Painter getPainterAt(PaintContext context, int availableWidth, int availableHeight, int x, int y, Painter proxyPainter) {
        ImmInsets borderSizes = this.getOwnInsets(context);
        if (x < 0 || y < 0 || x > availableWidth || y > availableHeight) {
            return null;
        }
        if (x >= borderSizes.left && x < availableWidth - borderSizes.right && y >= borderSizes.top && y < availableHeight - borderSizes.bottom) {
            return this.getContentPainterAt(context, availableWidth - borderSizes.left - borderSizes.right, availableHeight - borderSizes.top - borderSizes.bottom, x - borderSizes.left, y - borderSizes.top, proxyPainter);
        }
        return this.getBorderPainterAt(context, availableWidth, availableHeight, x, y, proxyPainter);
    }

    @Override
    public final ImmInsets getInsets(PaintContext context) {
        ImmInsets ownInsets = this.getOwnInsets(context);
        if (this._wrappedBorderPainter != null) {
            ImmInsets wrappedInsets = this._wrappedBorderPainter.getInsets(context);
            ownInsets = new ImmInsets(ownInsets.top + wrappedInsets.top, ownInsets.left + wrappedInsets.left, ownInsets.bottom + wrappedInsets.bottom, ownInsets.right + wrappedInsets.right);
        }
        return ownInsets;
    }

    @Override
    public final ImmInsets getFillInsets(PaintContext context) {
        if (this._wrappedBorderPainter != null) {
            ImmInsets wrappedInsets = this._wrappedBorderPainter.getFillInsets(context);
            if (wrappedInsets.equals(ImmInsets.getEmptyInsets())) {
                return this.getOwnFillInsets(context);
            }
            ImmInsets ownInsets = this.getOwnInsets(context);
            return new ImmInsets(ownInsets.top + wrappedInsets.top, ownInsets.left + wrappedInsets.left, ownInsets.bottom + wrappedInsets.bottom, ownInsets.right + wrappedInsets.right);
        }
        return this.getOwnFillInsets(context);
    }

    protected ImmInsets getOwnInsets(PaintContext context) {
        return ImmInsets.getEmptyInsets();
    }

    protected ImmInsets getOwnFillInsets(PaintContext context) {
        return this.getOwnInsets(context);
    }

    protected void paintBorder(PaintContext context, Graphics g, int x, int y, int width, int height) {
    }

    @Override
    public final boolean isTransparent(PaintContext context) {
        return this.isBorderTransparent(context) || super.isTransparent(context);
    }

    protected Painter getContentPainterAt(PaintContext context, int availableWidth, int availableHeight, int x, int y, Painter proxyPainter) {
        return super.getPainterAt(context, availableWidth, availableHeight, x, y, proxyPainter);
    }

    protected Painter getBorderPainterAt(PaintContext context, int availableWidth, int availableHeight, int x, int y, Painter proxyPainter) {
        return this;
    }

    public final boolean contentContains(PaintContext context, int availableWidth, int availableHeight, int x, int y) {
        return super.contains(context, availableWidth, availableHeight, x, y);
    }

    public final boolean borderContains(PaintContext context, int availableWidth, int availableHeight, int x, int y) {
        return this.getBorderPainterAt(context, availableWidth, availableHeight, x, y, null) != null;
    }

    protected abstract boolean isBorderTransparent(PaintContext var1);

    private Dimension _addInsets(PaintContext context, Dimension innerSize) {
        if (this._alwaysAddInsets || innerSize.width > 0 && innerSize.height > 0) {
            ImmInsets borderSizes = this.getOwnInsets(context);
            innerSize.width += borderSizes.left + borderSizes.right;
            innerSize.height += borderSizes.top + borderSizes.bottom;
        }
        return innerSize;
    }

    private void _init(Painter wrappedPainter, boolean alwaysAddInsets) {
        if (wrappedPainter instanceof BorderPainter) {
            this._wrappedBorderPainter = (BorderPainter)wrappedPainter;
        }
        this._alwaysAddInsets = alwaysAddInsets;
    }
}

