/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.olaf;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.UIDefaults;
import oracle.bali.ewt.LookAndFeel;
import oracle.bali.ewt.painter.AbstractPainter;
import oracle.bali.ewt.painter.PaintContext;

class OracleThumbPainter
extends AbstractPainter {
    private static final int _GRIPPY_SIZE = 3;
    private static final int _ORIENTATION_GRIPPY_GAP = 1;
    private static final int _PERPENDICULAR_GRIPPY_GAP = 2;
    private static final int _GRIPPY_STRIDE = 4;
    private static final int _MINIMUM_ORIENTATION_GRIPPY_SIZE = 7;
    private static final int _MINIMUM_PERPENDICULAR_GRIPPY_SIZE = 8;
    private static final int _MINIMUM_THUMB_PERPENDICULAR_SIZE = 14;
    private static final int _MINIMUM_THUMB_ORIENTATION_SIZE = 11;
    private boolean _isHorizontal;

    public OracleThumbPainter(boolean isHorizontal) {
        this._isHorizontal = isHorizontal;
    }

    @Override
    public Dimension getMinimumSize(PaintContext context) {
        if (this._isHorizontal) {
            return new Dimension(11, 14);
        }
        return new Dimension(14, 11);
    }

    @Override
    public void paint(PaintContext context, Graphics g, int x, int y, int width, int height) {
        Color savedColor = g.getColor();
        UIDefaults defaults = context.getPaintUIDefaults();
        int state = context.getPaintState();
        g.setColor(defaults.getColor(LookAndFeel.CONTROL));
        if (this._isHorizontal) {
            ++y;
            height -= 2;
        } else {
            ++x;
            width -= 2;
        }
        int right = x + width - 1;
        int bottom = y + height - 1;
        g.fillRect(x, y, width, height);
        if ((state & 4) == 0) {
            boolean isDisabled = (state & 1) != 0;
            Color highlight = defaults.getColor(LookAndFeel.CONTROL_LT_HIGHLIGHT);
            if (!isDisabled) {
                g.setColor(defaults.getColor(LookAndFeel.CONTROL_DK_SHADOW));
                g.drawLine(right, bottom, right, bottom);
                if (this._isHorizontal) {
                    g.drawLine(right, y + 1, right, bottom - 1);
                } else {
                    g.drawLine(x + 1, bottom, right - 1, bottom);
                }
                Color shadow = defaults.getColor(LookAndFeel.CONTROL_SHADOW);
                boolean isArmed = (state & 2) != 0;
                int grippyGap = this._isHorizontal ? 1 : 2;
                int numGrippies = (this._isHorizontal ? width : height) / (3 * (3 + grippyGap));
                if ((numGrippies |= 1) < 2) {
                    numGrippies = 2;
                }
                int grippySize = numGrippies * 3 + (numGrippies - 1) * grippyGap;
                if (this._isHorizontal) {
                    int grippyX = x + (width - grippySize) / 2;
                    int baseGrippyY = y + (height - 8) / 2;
                    int otherGrippyY = baseGrippyY + 3 + 2;
                    while (numGrippies > 0) {
                        OracleThumbPainter.__drawGrippy(g, grippyX, otherGrippyY, highlight, shadow, isArmed);
                        grippyX += 4;
                        if (--numGrippies <= 0) continue;
                        OracleThumbPainter.__drawGrippy(g, grippyX, baseGrippyY, highlight, shadow, isArmed);
                        --numGrippies;
                        grippyX += 4;
                    }
                } else {
                    int grippyY = y + (height - grippySize) / 2;
                    int baseGrippyX = x + (width - 8) / 2;
                    int otherGrippyX = baseGrippyX + 3 + 2;
                    while (numGrippies > 0) {
                        OracleThumbPainter.__drawGrippy(g, otherGrippyX, grippyY, highlight, shadow, isArmed);
                        grippyY += 4;
                        if (--numGrippies <= 0) continue;
                        OracleThumbPainter.__drawGrippy(g, baseGrippyX, grippyY, highlight, shadow, isArmed);
                        --numGrippies;
                        grippyY += 4;
                    }
                }
            }
            g.setColor(highlight);
            g.drawLine(x, y, right - 1, y);
            g.drawLine(x, y, x, bottom - 1);
        }
        g.setColor(savedColor);
    }

    @Override
    public int getRepaintFlags(PaintContext context) {
        return 7;
    }

    static void __drawGrippy(Graphics g, int x, int y, Color highlight, Color shadow, boolean isArmed) {
        g.setColor(highlight);
        g.drawLine(x + 1, y + 2, x + 2, y + 1);
        if (isArmed) {
            g.drawLine(x + 2, y + 2, x + 2, y + 2);
            x -= 2;
            y -= 2;
        } else {
            g.drawLine(x + 1, y + 1, x + 1, y + 1);
        }
        g.setColor(shadow);
        g.drawLine(x + 2, y + 3, x + 3, y + 2);
    }

    static void __drawGrippy(Graphics g, int x, int y, Color highlight, Color shadow, boolean isArmed, int readingDirection) {
        if (readingDirection == 1) {
            OracleThumbPainter.__drawGrippy(g, x, y, highlight, shadow, isArmed);
        } else if (readingDirection == 2) {
            g.setColor(highlight);
            g.drawLine(x - 1, y + 2, x - 2, y + 1);
            if (isArmed) {
                g.drawLine(x - 2, y + 2, x - 2, y + 2);
                x += 2;
                y += 2;
            } else {
                g.drawLine(x - 1, y + 1, x - 1, y + 1);
            }
            g.setColor(shadow);
            g.drawLine(x - 2, y + 3, x - 3, y + 2);
        }
    }
}

