/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.model;

import java.util.Enumeration;
import java.util.EventListener;
import oracle.bali.ewt.model.TwoDModel;
import oracle.bali.ewt.model.TwoDModelEvent;
import oracle.bali.ewt.model.TwoDModelListener;
import oracle.bali.share.event.ListenerManager;

public abstract class AbstractTwoDModel
implements TwoDModel {
    private ListenerManager _manager;

    @Override
    public abstract int getColumnCount();

    @Override
    public abstract int getRowCount();

    @Override
    public abstract Object getData(int var1, int var2);

    @Override
    public abstract void setData(int var1, int var2, Object var3);

    @Override
    public void addModelListener(TwoDModelListener listener) {
        if (this._manager == null) {
            this._manager = new ListenerManager();
        }
        this._manager.addListener((EventListener)listener);
    }

    @Override
    public void removeModelListener(TwoDModelListener listener) {
        if (this._manager != null) {
            this._manager.removeListener((EventListener)listener);
        }
    }

    protected void fireModelEvent(int eventID, int startIndex, int count) {
        switch (eventID) {
            case 2001: 
            case 2002: 
            case 2003: 
            case 2004: 
            case 2005: 
            case 2006: {
                if (startIndex >= 0 && count > 0) break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        this._deliverEvent(new TwoDModelEvent(this, eventID, startIndex, count));
    }

    protected void fireModelEvent(int eventID, int startColumn, int columnCount, int startRow, int rowCount) {
        switch (eventID) {
            case 2007: {
                if (startColumn >= 0 && columnCount > 0 && startRow >= 0 && rowCount > 0) break;
                throw new IllegalArgumentException();
            }
            case 2001: 
            case 2002: 
            case 2003: {
                if (startColumn >= 0 && columnCount > 0) break;
                throw new IllegalArgumentException();
            }
            case 2004: 
            case 2005: 
            case 2006: {
                if (startRow >= 0 && rowCount > 0) break;
                throw new IllegalArgumentException();
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        this._deliverEvent(new TwoDModelEvent(this, eventID, startColumn, columnCount, startRow, rowCount));
    }

    private void _deliverEvent(TwoDModelEvent event) {
        if (this._manager == null) {
            return;
        }
        Enumeration listeners = this._manager.getListeners();
        if (listeners == null) {
            return;
        }
        switch (event.getID()) {
            case 2001: {
                while (listeners.hasMoreElements()) {
                    TwoDModelListener listener = (TwoDModelListener)listeners.nextElement();
                    listener.columnsAdded(event);
                }
                break;
            }
            case 2002: {
                while (listeners.hasMoreElements()) {
                    TwoDModelListener listener = (TwoDModelListener)listeners.nextElement();
                    listener.columnsRemoved(event);
                }
                break;
            }
            case 2003: {
                while (listeners.hasMoreElements()) {
                    TwoDModelListener listener = (TwoDModelListener)listeners.nextElement();
                    listener.invalidateColumns(event);
                }
                break;
            }
            case 2004: {
                while (listeners.hasMoreElements()) {
                    TwoDModelListener listener = (TwoDModelListener)listeners.nextElement();
                    listener.rowsAdded(event);
                }
                break;
            }
            case 2005: {
                while (listeners.hasMoreElements()) {
                    TwoDModelListener listener = (TwoDModelListener)listeners.nextElement();
                    listener.rowsRemoved(event);
                }
                break;
            }
            case 2006: {
                while (listeners.hasMoreElements()) {
                    TwoDModelListener listener = (TwoDModelListener)listeners.nextElement();
                    listener.invalidateRows(event);
                }
                break;
            }
            case 2007: {
                while (listeners.hasMoreElements()) {
                    TwoDModelListener listener = (TwoDModelListener)listeners.nextElement();
                    listener.invalidateCells(event);
                }
                break;
            }
        }
    }
}

