/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.grid.bigCell;

import oracle.bali.ewt.grid.GeneralGridSelectionManager;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.grid.bigCell.AbstractBigCell;
import oracle.bali.ewt.selection.Cell;
import oracle.bali.ewt.selection.CellRange;
import oracle.bali.ewt.selection.OneDSelection;
import oracle.bali.ewt.selection.TwoDSelection;
import oracle.bali.share.collection.Range;

public class BigCellSelectionManager
extends GeneralGridSelectionManager {
    private Grid _grid;

    public BigCellSelectionManager(Grid grid) {
        this._grid = grid;
    }

    public Grid getGrid() {
        return this._grid;
    }

    @Override
    protected TwoDSelection constrain(TwoDSelection sel) {
        if (sel.isEmpty()) {
            return sel;
        }
        OneDSelection rowSel = sel.getRowSelection();
        if (!rowSel.isEmpty()) {
            return new TwoDSelection(null, this._constrainSelection(rowSel));
        }
        OneDSelection colSel = sel.getColumnSelection();
        if (!colSel.isEmpty()) {
            return new TwoDSelection(this._constrainSelection(colSel), null);
        }
        AbstractBigCell newBigCell = null;
        Cell newCell = sel.getSingleCell();
        if (newCell == null) {
            return new TwoDSelection();
        }
        Grid grid = this.getGrid();
        newBigCell = AbstractBigCell.getBigCell(grid, newCell.column, newCell.row);
        if (newBigCell != null) {
            int col = newBigCell.getColumn();
            int row = newBigCell.getRow();
            sel = new TwoDSelection(null, null, col, row, col + newBigCell.getColumnCount() - 1, row + newBigCell.getRowCount() - 1);
        } else {
            sel = new TwoDSelection(null, null, newCell.column, newCell.row);
        }
        return sel;
    }

    private boolean _meetsConstraints(OneDSelection sel) {
        Range[] ranges = sel.getRanges();
        return ranges == null || ranges.length == 0 || ranges.length > 0 && ranges[0].getLowerLimit() == ranges[0].getUpperLimit();
    }

    private boolean _meetsConstraints(CellRange[] ranges) {
        if (ranges == null) {
            return true;
        }
        Cell cell = null;
        AbstractBigCell bigCell = null;
        Grid grid = this.getGrid();
        for (int i = 0; i < ranges.length; ++i) {
            Cell lower = ranges[i].getLowerLimit();
            Cell upper = ranges[i].getUpperLimit();
            for (int row = lower.row; row <= upper.row; ++row) {
                for (int col = lower.column; col <= upper.column; ++col) {
                    AbstractBigCell newBigCell = AbstractBigCell.getBigCell(grid, col, row);
                    if (newBigCell != null) {
                        if (cell != null) {
                            return false;
                        }
                        if (bigCell == null) {
                            bigCell = newBigCell;
                            continue;
                        }
                        if (newBigCell == bigCell) continue;
                        return false;
                    }
                    if (cell != null || bigCell != null) {
                        return false;
                    }
                    cell = new Cell(col, row);
                }
            }
        }
        return true;
    }

    @Override
    protected boolean meetsConstraints(TwoDSelection sel) {
        return this._meetsConstraints(sel.getColumnSelection()) && this._meetsConstraints(sel.getRowSelection()) && this._meetsConstraints(sel.getCellRanges());
    }

    @Override
    public TwoDSelection getRepaintSelection(TwoDSelection oldSelection, TwoDSelection newSelection) {
        TwoDSelection result = super.getRepaintSelection(oldSelection, newSelection);
        if (!result.getRowSelection().isEmpty() || !result.getColumnSelection().isEmpty()) {
            Grid grid = this.getGrid();
            int col1 = grid.getNextVisibleColumn(-1);
            int col2 = grid.getPreviousVisibleColumn(grid.getColumnCount());
            int row1 = grid.getNextVisibleRow(-1);
            int row2 = grid.getPreviousVisibleRow(grid.getRowCount());
            result = new TwoDSelection(null, null, col1, row1, col2, row2);
        }
        return result;
    }

    private OneDSelection _constrainSelection(OneDSelection sel) {
        Range[] ranges = sel.getRanges();
        if (ranges == null || ranges.length == 0 || ranges.length > 0 && ranges[0].getLowerLimit() == ranges[0].getUpperLimit()) {
            return sel;
        }
        return new OneDSelection(ranges[0].getLowerLimit());
    }
}

