/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.grid.bigCell;

import java.awt.event.KeyEvent;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.grid.GridKeyHandler;
import oracle.bali.ewt.grid.StandardGridKeyHandler;
import oracle.bali.ewt.grid.bigCell.AbstractBigCell;
import oracle.bali.ewt.selection.Cell;

public class BigCellGridKeyHandler
extends StandardGridKeyHandler {
    private static StandardGridKeyHandler _sManager;

    public static GridKeyHandler getGridKeyHandler() {
        if (_sManager == null) {
            _sManager = new BigCellGridKeyHandler();
        }
        return _sManager;
    }

    @Override
    protected Cell left(Grid grid, Cell focusCell, KeyEvent e) {
        focusCell = this._checkForNull(grid, focusCell);
        AbstractBigCell bigCell = AbstractBigCell.getBigCell(grid, focusCell.column, focusCell.row);
        Cell left = super.left(grid, focusCell, e);
        if (left != null && (bigCell = AbstractBigCell.getBigCell(grid, left.column, left.row)) != null) {
            left.column = bigCell.getColumn();
            left.row = bigCell.getRow();
        }
        return left;
    }

    @Override
    protected Cell right(Grid grid, Cell focusCell, KeyEvent e) {
        Cell right;
        focusCell = this._checkForNull(grid, focusCell);
        AbstractBigCell bigCell = AbstractBigCell.getBigCell(grid, focusCell.column, focusCell.row);
        if (bigCell != null) {
            focusCell.column = bigCell.getColumn() + bigCell.getColumnCount() - 1;
        }
        if ((right = super.right(grid, focusCell, e)) != null && (bigCell = AbstractBigCell.getBigCell(grid, right.column, right.row)) != null) {
            right.column = bigCell.getColumn();
            right.row = bigCell.getRow();
        }
        return right;
    }

    @Override
    protected Cell up(Grid grid, Cell focusCell, KeyEvent e) {
        Cell up;
        focusCell = this._checkForNull(grid, focusCell);
        AbstractBigCell bigCell = AbstractBigCell.getBigCell(grid, focusCell.column, focusCell.row);
        if (bigCell != null) {
            focusCell.row = bigCell.getRow();
        }
        if ((up = super.up(grid, focusCell, e)) != null && (bigCell = AbstractBigCell.getBigCell(grid, up.column, up.row)) != null) {
            up.column = bigCell.getColumn();
            up.row = bigCell.getRow();
        }
        return up;
    }

    @Override
    protected Cell down(Grid grid, Cell focusCell, KeyEvent e) {
        Cell down;
        focusCell = this._checkForNull(grid, focusCell);
        AbstractBigCell bigCell = AbstractBigCell.getBigCell(grid, focusCell.column, focusCell.row);
        if (bigCell != null) {
            focusCell.row = bigCell.getRow() + bigCell.getRowCount() - 1;
        }
        if ((down = super.down(grid, focusCell, e)) != null && (bigCell = AbstractBigCell.getBigCell(grid, down.column, down.row)) != null) {
            down.column = bigCell.getColumn();
            down.row = bigCell.getRow();
        }
        return down;
    }

    @Override
    protected Cell pageUp(Grid grid, Cell focusCell, KeyEvent e) {
        focusCell = this._checkForNull(grid, focusCell);
        AbstractBigCell bigCell = AbstractBigCell.getBigCell(grid, focusCell.column, focusCell.row);
        if (bigCell != null) {
            focusCell.row = bigCell.getRow();
        }
        return super.pageUp(grid, focusCell, e);
    }

    @Override
    protected Cell pageDown(Grid grid, Cell focusCell, KeyEvent e) {
        focusCell = this._checkForNull(grid, focusCell);
        AbstractBigCell bigCell = AbstractBigCell.getBigCell(grid, focusCell.column, focusCell.row);
        if (bigCell != null) {
            focusCell.row = bigCell.getRow() + bigCell.getRowCount() - 1;
        }
        return super.pageDown(grid, focusCell, e);
    }

    @Override
    protected Cell home(Grid grid, Cell focusCell, KeyEvent e) {
        Cell c = super.home(grid, focusCell, e);
        AbstractBigCell cell = AbstractBigCell.getBigCell(grid, c.column, c.row);
        if (cell != null) {
            c.column = cell.getColumn();
            c.row = cell.getRow();
        }
        return c;
    }

    @Override
    protected Cell end(Grid grid, Cell focusCell, KeyEvent e) {
        Cell c = super.end(grid, focusCell, e);
        AbstractBigCell cell = AbstractBigCell.getBigCell(grid, c.column, c.row);
        if (cell != null) {
            c.column = cell.getColumn();
            c.row = cell.getRow();
        }
        return c;
    }

    private Cell _checkForNull(Grid grid, Cell focusCell) {
        if (focusCell == null) {
            focusCell = new Cell(grid.getNextVisibleColumn(-1), grid.getNextVisibleRow(-1));
        }
        return focusCell;
    }
}

