/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.grid;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.ImageObserver;
import oracle.bali.ewt.graphics.ImageSet;
import oracle.bali.ewt.graphics.ImageUtils;
import oracle.bali.ewt.graphics.SynthesizingImageSet;
import oracle.bali.ewt.painter.AbstractPainter;
import oracle.bali.ewt.painter.PaintContext;

public class TwoImagePainter
extends AbstractPainter {
    private Image _trueImage;
    private Image _falseImage;
    private ImageSet _trueImageSet;
    private ImageSet _falseImageSet;

    public TwoImagePainter(Image trueImage, Image falseImage) {
        this.setTrueImage(trueImage);
        this.setFalseImage(falseImage);
    }

    public Image getTrueImage() {
        return this._trueImage;
    }

    public void setTrueImage(Image trueImage) {
        this._trueImage = trueImage;
        this._trueImageSet = this._trueImage == null ? null : new SynthesizingImageSet(this._trueImage, 1);
    }

    public Image getFalseImage() {
        return this._falseImage;
    }

    public void setFalseImage(Image falseImage) {
        this._falseImage = falseImage;
        this._falseImageSet = this._falseImage == null ? null : new SynthesizingImageSet(this._falseImage, 1);
    }

    @Override
    public Dimension getSize(PaintContext context, int availableWidth, int availableHeight) {
        Dimension size = this.getMinimumSize(context);
        if (size.width > availableWidth) {
            size.width = availableWidth;
        }
        if (size.height > availableHeight) {
            size.height = availableHeight;
        }
        return size;
    }

    @Override
    public Dimension getMinimumSize(PaintContext context) {
        Dimension falseSize = this._getSize(context, this.getFalseImage());
        Dimension trueSize = this._getSize(context, this.getTrueImage());
        if (falseSize.width > trueSize.width) {
            trueSize.width = falseSize.width;
        }
        if (falseSize.height > trueSize.height) {
            trueSize.height = falseSize.height;
        }
        return trueSize;
    }

    @Override
    public void paint(PaintContext context, Graphics g, int x, int y, int width, int height) {
        ImageSet set = this._getImageSet(context);
        if (set != null) {
            set.paintImage(context.getPaintState() & 0x3F, g, x, y, context.getImageObserver());
        }
    }

    @Override
    public int getRepaintFlags(PaintContext context) {
        return 0;
    }

    private ImageSet _getImageSet(PaintContext context) {
        Object data = context.getPaintData(this.getDataKey());
        Boolean bData = (Boolean)data;
        if (Boolean.TRUE.equals(bData)) {
            return this._trueImageSet;
        }
        return this._falseImageSet;
    }

    private Dimension _getSize(PaintContext context, Image image) {
        int width = 0;
        int height = 0;
        if (image != null && ImageUtils.loadImage(image)) {
            ImageObserver observer = context.getImageObserver();
            width = image.getWidth(observer);
            height = image.getHeight(observer);
        }
        return new Dimension(width, height);
    }
}

