/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.grid;

import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.grid.CellInputHandler;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.model.TwoDModel;

public abstract class DirectInputHandler
extends CellInputHandler {
    private int _column;
    private int _row;
    private boolean _inCell;

    @Override
    public void mousePressed(MouseEvent evt, Grid grid, int column, int row) {
        super.mousePressed(evt, grid, column, row);
        this._column = column;
        this._row = row;
        this._inCell = true;
        grid.paintCell(column, row);
    }

    @Override
    public void mouseReleased(MouseEvent evt, Grid grid, int column, int row) {
        super.mouseReleased(evt, grid, column, row);
        if (SwingUtilities.isLeftMouseButton(evt) && this._column == column && this._row == row && this._inCell) {
            this.updateValue(grid, column, row);
        }
        this._column = -1;
        this._row = -1;
        this._inCell = false;
    }

    @Override
    public void mouseDragged(MouseEvent e, Grid grid, int column, int row) {
        super.mouseDragged(e, grid, column, row);
        boolean old = this._inCell;
        boolean bl = this._inCell = e.getX() >= 0 && e.getX() <= grid.getColumnWidth(column) && e.getY() >= 0 && e.getY() <= grid.getRowHeight(row);
        if (old != this._inCell) {
            grid.paintCell(column, row);
        }
    }

    @Override
    public void keyReleased(KeyEvent evt, Grid grid, int column, int row) {
        super.keyReleased(evt, grid, column, row);
        if (evt.getKeyCode() == 32) {
            this.updateValue(grid, column, row);
            evt.consume();
        }
    }

    protected final void updateValue(Grid grid, int column, int row) {
        if (grid.fireCancelableCellEvent(column, row, 2001)) {
            grid.repaintCell(column, row);
            return;
        }
        TwoDModel ds = grid.getModel();
        ds.setData(column, row, this.getNewValue(grid, column, row, ds.getData(column, row)));
        grid.fireCellEvent(column, row, 2002);
    }

    protected abstract Object getNewValue(Grid var1, int var2, int var3, Object var4);

    protected DirectInputHandler() {
    }
}

