/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.grid;

import javax.swing.UIManager;
import javax.swing.plaf.UIResource;
import oracle.bali.ewt.graphics.Appearance;
import oracle.bali.ewt.grid.AppearanceManager;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.model.ArrayOneDModel;
import oracle.bali.ewt.model.ArrayTwoDModel;
import oracle.bali.ewt.model.TwoDModelEvent;
import oracle.bali.ewt.model.TwoDModelListener;

public class ComplexAppearanceManager
implements AppearanceManager {
    private Grid _grid;
    private int _columnCount;
    private int _rowCount;
    private ArrayOneDModel _rows;
    private ArrayOneDModel _columns;
    private ArrayTwoDModel _cells;
    private Appearance _appearance;
    private GeometryChangeListener _listener;

    @Override
    public void setGrid(Grid grid) {
        this._columns = null;
        this._rows = null;
        this._cells = null;
        this._grid = grid;
        this._columnCount = grid == null ? 0 : this._grid.getColumnCount();
        this._rowCount = grid == null ? 0 : this._grid.getRowCount();
    }

    @Override
    public Appearance getCellPaintingAppearance(int column, int row) {
        Object data = null;
        if (this._cells != null) {
            data = this._cells.getData(column, row);
        }
        if (data == null && this._columns != null) {
            data = this._columns.getData(column);
        }
        if (data == null && this._rows != null) {
            data = this._rows.getData(row);
        }
        if (data != null) {
            return (Appearance)data;
        }
        return this._getAppearance();
    }

    public Appearance getAppearance() {
        return this._getAppearance().copy();
    }

    public void setAppearance(Appearance object) {
        this._appearance = object.copy();
        if (this._grid != null) {
            this._grid.repaint();
        }
    }

    public Appearance getColumnAppearance(int column) {
        Object data;
        if (this._columns != null && (data = this._columns.getData(column)) != null) {
            return ((Appearance)data).copy();
        }
        return this.getAppearance();
    }

    public void setColumnAppearance(int column, Appearance appearance) {
        if (this._columns == null) {
            this._columns = new ArrayOneDModel(this._columnCount);
        }
        if (appearance != null) {
            appearance = appearance.copy();
        }
        this._columns.setData(column, appearance);
        if (this._grid != null) {
            this._grid.repaintColumn(column);
        }
    }

    public Appearance getRowAppearance(int row) {
        Object data;
        if (this._rows != null && (data = this._rows.getData(row)) != null) {
            return ((Appearance)data).copy();
        }
        return this.getAppearance();
    }

    public void setRowAppearance(int row, Appearance appearance) {
        if (this._rows == null) {
            this._rows = new ArrayOneDModel(this._rowCount);
        }
        if (appearance != null) {
            appearance = appearance.copy();
        }
        this._rows.setData(row, appearance);
        if (this._grid != null) {
            this._grid.repaintRow(row);
        }
    }

    public Appearance getCellAppearance(int column, int row) {
        Appearance appearance = this.getCellPaintingAppearance(column, row);
        if (appearance != null) {
            appearance = appearance.copy();
        }
        return appearance;
    }

    public void setCellAppearance(int column, int row, Appearance appearance) {
        if (this._cells == null) {
            this._cells = new ArrayTwoDModel(this._columnCount, this._rowCount);
        }
        if (appearance != null) {
            appearance = appearance.copy();
        }
        this._cells.setData(column, row, appearance);
        if (this._grid != null) {
            this._grid.repaintCell(column, row);
        }
    }

    @Override
    public TwoDModelListener getTwoDModelListener() {
        if (this._listener == null) {
            this._listener = new GeometryChangeListener();
        }
        return this._listener;
    }

    public void rowsAdded(int startRow, int numberOfRows) {
        if (this._rows != null) {
            this._rows.addItems(startRow, numberOfRows);
        }
        if (this._cells != null) {
            this._cells.addRows(startRow, numberOfRows);
        }
        this._rowCount += numberOfRows;
    }

    public void rowsRemoved(int startRow, int numberOfRows) {
        if (this._rows != null) {
            this._rows.removeItems(startRow, numberOfRows);
        }
        if (this._cells != null) {
            this._cells.removeRows(startRow, numberOfRows);
        }
        this._rowCount -= numberOfRows;
    }

    public void columnsAdded(int startColumn, int numberOfColumns) {
        if (this._columns != null) {
            this._columns.addItems(startColumn, numberOfColumns);
        }
        if (this._cells != null) {
            this._cells.addColumns(startColumn, numberOfColumns);
        }
        this._columnCount += numberOfColumns;
    }

    public void columnsRemoved(int startColumn, int numberOfColumns) {
        if (this._columns != null) {
            this._columns.removeItems(startColumn, numberOfColumns);
        }
        if (this._cells != null) {
            this._cells.removeColumns(startColumn, numberOfColumns);
        }
        this._columnCount -= numberOfColumns;
    }

    @Override
    public void updateUI() {
        if (this._appearance instanceof UIResource) {
            this._appearance = null;
        }
    }

    private Appearance _getAppearance() {
        if (this._appearance == null) {
            this._appearance = this._createAppearance();
        }
        return this._appearance;
    }

    private Appearance _createAppearance() {
        return (Appearance)UIManager.get("Grid.DefaultAppearance");
    }

    private class GeometryChangeListener
    implements TwoDModelListener {
        private GeometryChangeListener() {
        }

        @Override
        public void rowsAdded(TwoDModelEvent e) {
            int startIndex = e.getRowStartIndex();
            int count = e.getRowCount();
            ComplexAppearanceManager.this.rowsAdded(startIndex, count);
        }

        @Override
        public void rowsRemoved(TwoDModelEvent e) {
            int startIndex = e.getRowStartIndex();
            int count = e.getRowCount();
            ComplexAppearanceManager.this.rowsRemoved(startIndex, count);
        }

        @Override
        public void invalidateRows(TwoDModelEvent e) {
        }

        @Override
        public void columnsAdded(TwoDModelEvent e) {
            int startIndex = e.getColumnStartIndex();
            int count = e.getColumnCount();
            ComplexAppearanceManager.this.columnsAdded(startIndex, count);
        }

        @Override
        public void columnsRemoved(TwoDModelEvent e) {
            int startIndex = e.getColumnStartIndex();
            int count = e.getColumnCount();
            ComplexAppearanceManager.this.columnsRemoved(startIndex, count);
        }

        @Override
        public void invalidateColumns(TwoDModelEvent e) {
        }

        @Override
        public void invalidateCells(TwoDModelEvent e) {
        }
    }
}

