/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.graphics;

import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;
import oracle.bali.ewt.graphics.SpacingIcon;

public class JoiningIcon
implements Icon {
    private Icon _primary;
    private Icon _secondary;

    public JoiningIcon(Icon left, Icon right) {
        if (left == null || right == null) {
            throw new IllegalArgumentException();
        }
        this._primary = left;
        this._secondary = right;
    }

    public JoiningIcon(Icon left, Icon right, int margin) {
        this(left, new JoiningIcon(new SpacingIcon(margin, 0), right));
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        int leftHeight = this._primary.getIconHeight();
        int rightHeight = this._secondary.getIconHeight();
        int totalHeight = Math.max(leftHeight, rightHeight);
        this._primary.paintIcon(c, g, x, y + (totalHeight - leftHeight) / 2);
        this._secondary.paintIcon(c, g, x + this._primary.getIconWidth(), y + (totalHeight - rightHeight) / 2);
    }

    @Override
    public int getIconWidth() {
        return this._primary.getIconWidth() + this._secondary.getIconWidth();
    }

    @Override
    public int getIconHeight() {
        return Math.max(this._primary.getIconHeight(), this._secondary.getIconHeight());
    }
}

