/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.event;

import java.beans.PropertyChangeListener;
import javax.swing.event.SwingPropertyChangeSupport;
import oracle.bali.share.util.BooleanUtils;
import oracle.bali.share.util.IntegerUtils;

public class PropertyChanger {
    private SwingPropertyChangeSupport _changeSupport = null;
    private Object _source = null;

    public PropertyChanger() {
    }

    public PropertyChanger(Object source) {
        this._source = source;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this._init();
        this._changeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this._init();
        this._changeSupport.removePropertyChangeListener(listener);
    }

    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this._init();
        this._changeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    public final void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        this.firePropertyChange(propertyName, BooleanUtils.getBoolean((boolean)oldValue), BooleanUtils.getBoolean((boolean)newValue));
    }

    public final void firePropertyChange(String propertyName, boolean newValue) {
        this.firePropertyChange(propertyName, BooleanUtils.getBoolean((!newValue ? 1 : 0) != 0), BooleanUtils.getBoolean((boolean)newValue));
    }

    public final void firePropertyChange(String propertyName, int oldValue, int newValue) {
        this.firePropertyChange(propertyName, IntegerUtils.getInteger((int)oldValue), IntegerUtils.getInteger((int)newValue));
    }

    private void _init() {
        if (this._source == null) {
            this._source = this;
        }
        if (this._changeSupport == null) {
            this._changeSupport = new SwingPropertyChangeSupport(this._source);
        }
    }
}

