/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.elaf.windows;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import oracle.bali.ewt.busyBar.BusyBar;
import oracle.bali.ewt.elaf.EWTBusyBarUI;
import oracle.bali.ewt.elaf.windows.WindowsBusyBarPainter;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.painter.PainterStacker;
import oracle.bali.ewt.painter.PainterTiler;
import oracle.bali.ewt.painter.TextPainter;
import oracle.bali.ewt.plaf.PainterComponentUI;

public class WindowsEWTBusyBarUI
extends PainterComponentUI
implements EWTBusyBarUI {
    private static Painter _sPainter;
    private static WindowsEWTBusyBarUI _sInstance;

    public static ComponentUI createUI(JComponent component) {
        return _sInstance;
    }

    public static Object instantiate(UIDefaults defaults, Object key, String discriminant) {
        if ("EWTBusyBar.border".equals(key)) {
            return new WindowsBusyBarBorder();
        }
        return null;
    }

    @Override
    public void installUI(JComponent component) {
        LookAndFeel.installColors(component, "EWTBusyBar.background", "EWTBusyBar.foreground");
        LookAndFeel.installBorder(component, "EWTBusyBar.border");
        component.setOpaque(false);
    }

    @Override
    public void uninstallUI(JComponent component) {
        LookAndFeel.uninstallBorder(component);
    }

    @Override
    protected Painter getPainter(JComponent component) {
        if (_sPainter == null) {
            _sPainter = new PainterStacker(new PainterTiler(new WindowsBusyBarPainter(), 6, 1), new TextPainter());
        }
        return _sPainter;
    }

    static {
        _sInstance = new WindowsEWTBusyBarUI();
    }

    private static class WindowsBusyBarBorder
    extends AbstractBorder
    implements UIResource {
        private Border _activeBusyBorder = UIManager.getBorder("ProgressBar.border");

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            if (((BusyBar)c).isRunning()) {
                this._activeBusyBorder.paintBorder(c, g, x, y, width, height);
            }
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return this._activeBusyBorder.getBorderInsets(c);
        }

        @Override
        public Insets getBorderInsets(Component c, Insets insets) {
            Insets borderinsets = this._activeBusyBorder.getBorderInsets(c);
            insets.bottom = borderinsets.bottom;
            insets.top = borderinsets.top;
            insets.left = borderinsets.left;
            insets.right = borderinsets.right;
            return insets;
        }
    }
}

