/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.elaf.oracle;

import javax.swing.JComponent;
import javax.swing.UIDefaults;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import oracle.bali.ewt.elaf.basic.BasicEWTTableUI;
import oracle.bali.ewt.elaf.oracle.OracleCornerPainter;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.header.Header;
import oracle.bali.ewt.olaf.OracleInsetBorderPainter;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.plaf.BorderAdapter;
import oracle.bali.ewt.table.SpreadTable;

public class OracleEWTTableUI
extends BasicEWTTableUI {
    private static final Border _BORDER = new BorderAdapter(new OracleInsetBorderPainter(false));
    private static OracleEWTTableUI _sInstance;

    private OracleEWTTableUI() {
    }

    @Override
    public void installUI(JComponent component) {
        super.installUI(component);
        this.updateGeometry(component);
    }

    @Override
    public void updateGeometry(JComponent component) {
        SpreadTable table = (SpreadTable)component;
        boolean l2r = table.getActualReadingDirection() == 1;
        boolean colVisible = table.isColumnHeaderVisible();
        boolean rowVisible = table.isRowHeaderVisible();
        Header header = table.getRowHeader();
        if (rowVisible && header != null) {
            header.setBorder(null);
            if (l2r) {
                header.setFirstEdge(!colVisible);
                header.setLastEdge(false);
            } else {
                header.setLastEdge(!colVisible);
                header.setFirstEdge(false);
            }
        }
        if (header != null) {
            if (header.getFirstItemBorderPainter() instanceof UIResource) {
                header.setFirstItemBorderPainter(null);
            }
            if (header.getLastItemBorderPainter() instanceof UIResource) {
                header.setLastItemBorderPainter(null);
            }
        }
        header = table.getColumnHeader();
        if (colVisible && header != null) {
            header.setBorder(null);
            if (l2r) {
                header.setFirstEdge(!rowVisible);
                header.setLastEdge(false);
            } else {
                header.setLastEdge(!rowVisible);
                header.setFirstEdge(false);
            }
        }
        if (header != null) {
            if (header.getFirstItemBorderPainter() instanceof UIResource) {
                header.setFirstItemBorderPainter(null);
            }
            if (header.getLastItemBorderPainter() instanceof UIResource) {
                header.setLastItemBorderPainter(null);
            }
        }
        Grid grid = table.getGrid();
        if (l2r) {
            grid.setUpperLeft(!colVisible & !rowVisible);
            grid.setUpperRight(!colVisible);
            grid.setLowerLeft(true);
            grid.setLowerRight(!rowVisible);
        } else {
            grid.setUpperRight(!colVisible & !rowVisible);
            grid.setUpperLeft(!colVisible);
            grid.setLowerRight(true);
            grid.setLowerLeft(!rowVisible);
        }
        super.updateGeometry(component);
    }

    public static ComponentUI createUI(JComponent component) {
        if (_sInstance == null) {
            _sInstance = new OracleEWTTableUI();
        }
        return _sInstance;
    }

    public static Object instantiate(UIDefaults defaults, Object key, String discriminant) {
        if ("EWTTable.border".equals(key)) {
            return _BORDER;
        }
        if ("EWTTable.scrollPaneBorder".equals(key)) {
            return _BORDER;
        }
        return null;
    }

    @Override
    public Painter getCornerPainter(JComponent component, int whichCorner) {
        return OracleCornerPainter.getPainter(whichCorner);
    }
}

