/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.elaf.oracle;

import java.awt.Color;
import java.awt.Graphics;
import javax.swing.UIDefaults;
import oracle.bali.ewt.painter.AbstractBorderPainter;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.util.ImmInsets;

class HeaderExtraCanvasPainter
extends AbstractBorderPainter {
    private boolean _curvedLastEdge;
    private boolean _horizontal;
    private static final ImmInsets _sInsets = new ImmInsets(1, 1, 1, 1);

    public HeaderExtraCanvasPainter(boolean horizontal, boolean curvedLastEdge) {
        this._horizontal = horizontal;
        this._curvedLastEdge = curvedLastEdge;
    }

    @Override
    protected boolean isBorderTransparent(PaintContext context) {
        return false;
    }

    @Override
    protected ImmInsets getOwnInsets(PaintContext context) {
        return _sInsets;
    }

    @Override
    protected void paintBorder(PaintContext context, Graphics g, int x, int y, int width, int height) {
        Color savedColor = g.getColor();
        if (this._horizontal) {
            this._paintHorizontalBorder(context, g, x, y, width, height);
        } else {
            this._paintVerticalBorder(context, g, x, y, width, height);
        }
        if (savedColor != null) {
            g.setColor(savedColor);
        }
    }

    private void _paintVerticalBorder(PaintContext context, Graphics g, int x, int y, int width, int height) {
        int state = context.getPaintState();
        UIDefaults defaults = context.getPaintUIDefaults();
        int bottom = y + height - 1;
        int right = x + width - 1;
        Color control = defaults.getColor("control");
        Color shadow = defaults.getColor("normalIntensity");
        g.setColor(shadow);
        g.drawLine(right, y, right, bottom);
        if (this._curvedLastEdge) {
            g.setColor(shadow);
            g.drawLine(x, bottom - 1, x, bottom);
            g.drawLine(x + 1, bottom, x + 1, bottom);
        }
        if ((state & 4) == 0) {
            int temp1;
            g.setColor(Color.white);
            if (this._curvedLastEdge) {
                g.drawLine(x + 1, bottom - 1, x + 1, bottom - 1);
                temp1 = bottom - 2;
            } else {
                temp1 = bottom;
            }
            g.drawLine(x, y, right, y);
            g.drawLine(x, y, x, temp1);
            if (this._curvedLastEdge) {
                g.setColor(shadow);
                g.drawLine(x, bottom, right, bottom);
            }
            g.setColor(control);
            g.drawLine(x, bottom, x, bottom);
            g.drawLine(right, y, right, y);
        }
    }

    private void _paintHorizontalBorder(PaintContext context, Graphics g, int x, int y, int width, int height) {
        int state = context.getPaintState();
        UIDefaults defaults = context.getPaintUIDefaults();
        int bottom = y + height - 1;
        int right = x + width - 1;
        Color control = defaults.getColor("control");
        Color shadow = defaults.getColor("normalIntensity");
        Color darkShadow = defaults.getColor("darkIntensity");
        g.setColor(shadow);
        g.drawLine(x, bottom, right, bottom);
        if (this._curvedLastEdge) {
            g.drawLine(right - 1, y, right, y);
            g.drawLine(right, y + 1, right, y + 1);
        }
        if ((state & 4) == 0) {
            int temp1;
            g.setColor(Color.white);
            if (this._curvedLastEdge) {
                g.drawLine(right - 1, y + 1, right - 1, y + 1);
                temp1 = right - 2;
            } else {
                temp1 = right;
            }
            g.drawLine(x, y, temp1, y);
            g.drawLine(x, y, x, bottom);
            if (this._curvedLastEdge) {
                g.setColor(shadow);
                g.drawLine(right, y, right, bottom);
            }
            g.setColor(control);
            g.drawLine(x, bottom, x, bottom);
            g.drawLine(right, y, right, y);
        }
    }
}

