/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.dnd.impl;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import javax.swing.JList;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import oracle.bali.ewt.dnd.DragGestureEvent;
import oracle.bali.ewt.dnd.DragGestureListener;
import oracle.bali.ewt.dnd.DragGestureRecognizer;
import oracle.bali.ewt.dnd.DragSource;
import oracle.bali.ewt.dnd.DragSourceDragEvent;
import oracle.bali.ewt.dnd.DragSourceDropEvent;
import oracle.bali.ewt.dnd.DragSourceEvent;
import oracle.bali.ewt.dnd.DragSourceListener;
import oracle.bali.ewt.dnd.DropTarget;
import oracle.bali.ewt.dnd.DropTargetDragEvent;
import oracle.bali.ewt.dnd.DropTargetDropEvent;
import oracle.bali.ewt.dnd.DropTargetEvent;
import oracle.bali.ewt.dnd.DropTargetListener;
import oracle.bali.ewt.dnd.impl.StaticListSelection;
import oracle.bali.ewt.graphics.ImageUtils;
import oracle.bali.share.datatransfer.ObjectTransferable;
import oracle.bali.share.datatransfer.TransferUtils;
import oracle.bali.share.sort.Sort;

@Deprecated
public abstract class ListDragger {
    private DropTarget _target;
    private int _sourceActions = 0;
    private boolean _reordering;
    private Adapter _adapter;
    private static boolean _sUsingImage;
    private static final DataFlavor _sStringFlavor;
    private static final DataFlavor _sArrayFlavor;
    private static final int _AUTOSCROLL_REGION = 8;

    protected ListDragger() {
        this(null);
    }

    protected ListDragger(JList list) {
        this._adapter = new Adapter(list);
        this._target = new DropTarget(list, this._adapter);
        if (list != null) {
            list.updateUI();
        }
        if (list == null) {
            this._target.setActive(true);
        }
        this.setReorderingAllowed(false);
        this.setTargetActions(0);
    }

    public JList getList() {
        return this._adapter.getList();
    }

    public void setList(JList list) {
        this._adapter.setList(list);
        this._target.setComponent(list);
    }

    public void setActive(boolean active) {
        this._target.setActive(active);
    }

    public boolean isActive() {
        return this._target.isActive();
    }

    public void setTargetActions(int targetActions) {
        this._target.setDefaultActions(targetActions);
    }

    public int getTargetActions() {
        return this._target.getDefaultActions();
    }

    public void setSourceActions(int sourceActions) {
        this._sourceActions = sourceActions;
        this._updateSourceActions();
    }

    public int getSourceActions() {
        return this._sourceActions;
    }

    public void setReorderingAllowed(boolean reordering) {
        this._reordering = reordering;
        this._updateSourceActions();
    }

    public boolean isReorderingAllowed() {
        return this._reordering;
    }

    protected Image createDragImage(JList list, int index) {
        return null;
    }

    protected abstract void addItems(Object[] var1, int var2);

    protected abstract void removeItems(int[] var1);

    protected abstract void reorderItems(int[] var1, int var2);

    protected Transferable createTransferable(JList list) {
        int[] indices = ListDragger._getSortedIndices(list);
        String[] strings = new String[indices.length];
        ListModel model = list.getModel();
        for (int i = 0; i < indices.length; ++i) {
            strings[i] = (String)model.getElementAt(indices[i]);
        }
        return ObjectTransferable.createTransferable((Object)strings);
    }

    protected boolean isDragAcceptable(DropTargetDragEvent dtde) {
        return dtde.isDataFlavorSupported(_sArrayFlavor) || dtde.isDataFlavorSupported(_sStringFlavor);
    }

    protected Object[] getDataFromDrop(DropTargetDropEvent dtde) {
        Transferable t = dtde.getTransferable();
        String[] strings = null;
        try {
            if (t.isDataFlavorSupported(_sArrayFlavor)) {
                strings = (String[])t.getTransferData(_sArrayFlavor);
            } else if (t.isDataFlavorSupported(_sStringFlavor)) {
                String string = (String)t.getTransferData(_sStringFlavor);
                strings = new String[]{string};
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return strings;
    }

    private void _updateSourceActions() {
        int actions = this.getSourceActions();
        if (this.isReorderingAllowed()) {
            actions |= 2;
        }
        this._adapter.setSourceActions(actions);
    }

    private static int[] _getSortedIndices(JList list) {
        int[] indices = list.getSelectedIndices();
        Sort.qSort((int[])indices, (int)indices.length, (boolean)true);
        return indices;
    }

    static {
        _sStringFlavor = TransferUtils.getDataFlavor(String.class);
        _sArrayFlavor = TransferUtils.getDataFlavor(String[].class);
    }

    private class Adapter
    implements DragGestureListener,
    DragSourceListener,
    DropTargetListener {
        private JList _list;
        private DragGestureRecognizer _recognizer;
        private transient ListSelectionModel _savedSelection;
        private transient int _dropIndex;
        private transient boolean _canDrag;
        private transient boolean _inDrag;
        private transient boolean _inDrop;

        public Adapter(JList list) {
            DragSource source = DragSource.getDefaultDragSource();
            this._recognizer = source.createDefaultDragGestureRecognizer(list, 0, this);
            this._list = list;
        }

        public JList getList() {
            return this._list;
        }

        public void setList(JList list) {
            this._list = list;
            this._recognizer.setComponent(list);
        }

        public void setSourceActions(int actions) {
            this._recognizer.setSourceActions(actions);
        }

        @Override
        public void dragGestureRecognized(DragGestureEvent e) {
            JList list = this._list;
            int index = list.locationToIndex(e.getDragOrigin());
            if (index >= 0 && list.isSelectedIndex(index) && ListDragger.this.isActive()) {
                this._inDrag = true;
                this._savedSelection = list.getSelectionModel();
                list.setSelectionModel(new StaticListSelection(this._savedSelection));
                Transferable transferable = ListDragger.this.createTransferable(list);
                Image image = ListDragger.this.createDragImage(list, index);
                if (image == null || !ImageUtils.loadImage(image)) {
                    _sUsingImage = false;
                    e.startDrag(null, transferable, this);
                } else {
                    _sUsingImage = true;
                    Point offset = new Point(-image.getWidth(list), -image.getHeight(list));
                    e.startDrag(null, image, offset, transferable, this);
                }
            }
        }

        @Override
        public void dragEnter(DragSourceDragEvent dsde) {
        }

        @Override
        public void dragOver(DragSourceDragEvent dsde) {
        }

        @Override
        public void dropActionChanged(DragSourceDragEvent dsde) {
        }

        @Override
        public void dragExit(DragSourceEvent dse) {
        }

        @Override
        public void dragDropEnd(DragSourceDropEvent dsde) {
            if (this._savedSelection != null) {
                this._list.setSelectionModel(this._savedSelection);
            }
            if (dsde.getDropSuccess() && (ListDragger.this.getSourceActions() & 2) != 0 && dsde.getDropAction() == 2) {
                int[] indices = ListDragger._getSortedIndices(this._list);
                this._list.clearSelection();
                ListDragger.this.removeItems(indices);
            }
            this._inDrag = false;
        }

        @Override
        public void dragEnter(DropTargetDragEvent dtde) {
            this._inDrop = true;
            this._dropIndex = -1;
            this.dragOver(dtde);
        }

        @Override
        public void dragOver(DropTargetDragEvent dtde) {
            int newDropIndex;
            int action = this._getDropAction(dtde.getDropAction());
            if (action != 0 && !ListDragger.this.isDragAcceptable(dtde)) {
                action = 0;
            }
            int oldDropIndex = this._dropIndex;
            if (action == 0) {
                dtde.rejectDrag();
                newDropIndex = -1;
            } else {
                dtde.acceptDrag(action);
                newDropIndex = this._getDropIndex(dtde.getLocation());
            }
            if (oldDropIndex != newDropIndex) {
                this._eraseFeedback();
                this._dropIndex = newDropIndex;
                this._drawFeedback();
            } else if (_sUsingImage) {
                this._drawFeedback();
            }
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent dtde) {
        }

        @Override
        public void dragExit(DropTargetEvent dte) {
            this._eraseFeedback();
            this._inDrop = false;
        }

        @Override
        public void drop(DropTargetDropEvent dtde) {
            boolean accepted = false;
            this._eraseFeedback();
            int action = this._getDropAction(dtde.getDropAction());
            if (action != 0) {
                JList list = this._list;
                Object[] data = ListDragger.this.getDataFromDrop(dtde);
                if (data != null && data.length > 0) {
                    int dropIndex = this._getDropIndex(dtde.getLocation());
                    int[] indices = ListDragger._getSortedIndices(list);
                    if (ListDragger.this.isReorderingAllowed() && this._inDrag) {
                        list.setSelectionModel(this._savedSelection);
                        this._savedSelection = null;
                        if (indices.length > 1 || dropIndex != indices[0] && dropIndex != indices[0] + 1) {
                            accepted = true;
                            dtde.acceptDrop(1);
                            list.clearSelection();
                            for (int i = indices.length - 1; i >= 0; --i) {
                                if (indices[i] >= dropIndex) continue;
                                --dropIndex;
                            }
                            ListDragger.this.reorderItems(indices, dropIndex);
                        }
                    } else if (!this._inDrag) {
                        accepted = true;
                        dtde.acceptDrop(action);
                        list.clearSelection();
                        ListDragger.this.addItems(data, dropIndex);
                    }
                }
            }
            if (!accepted) {
                dtde.rejectDrop();
            }
            dtde.dropComplete(accepted);
            this._inDrop = false;
        }

        private Rectangle _getFeedbackArea(int index) {
            Rectangle bounds;
            int items = this._list.getModel().getSize();
            if (items == 0) {
                return new Rectangle(0, 0, this._list.getWidth(), 2);
            }
            if (index >= items) {
                bounds = this._list.getCellBounds(items - 1, items - 1);
                bounds.y += bounds.height - 1;
            } else {
                bounds = this._list.getCellBounds(index, index);
            }
            bounds.height = 2;
            return bounds;
        }

        private void _eraseFeedback() {
            Rectangle r;
            int index = this._dropIndex;
            if (index >= 0 && (r = this._getFeedbackArea(index)) != null) {
                this._list.paintImmediately(r.x, r.y, r.width, r.height);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void _drawFeedback() {
            Graphics g;
            int index = this._dropIndex;
            if (index >= 0 && (g = this._list.getGraphics()) != null) {
                try {
                    Rectangle visibleRect = this._list.getVisibleRect();
                    g.clipRect(visibleRect.x, visibleRect.y, visibleRect.width, visibleRect.height);
                    Rectangle r = this._getFeedbackArea(index);
                    g.setColor(Color.black);
                    g.fillRect(r.x, r.y, r.width, r.height);
                }
                finally {
                    g.dispose();
                }
            }
        }

        private int _getDropIndex(Point location) {
            int items = this._list.getModel().getSize();
            int index = this._list.locationToIndex(location);
            if (index == -1 || index >= items) {
                index = items;
            } else {
                Rectangle bounds = this._list.getCellBounds(index, index);
                if (location.y > bounds.y + bounds.height / 2) {
                    ++index;
                }
            }
            return index;
        }

        private int _getDropAction(int sourceActions) {
            int action = 0;
            if (ListDragger.this.isReorderingAllowed() && this._inDrag) {
                action = 2;
            } else if (!this._inDrag && (action = sourceActions) == 3) {
                action = 1;
            }
            return action;
        }
    }
}

