/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.dnd;

import java.applet.Applet;
import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import oracle.bali.ewt.dnd.Autoscroll;
import oracle.bali.ewt.dnd.DragSource;
import oracle.bali.ewt.dnd.DragTracker;
import oracle.bali.ewt.dnd.DropTarget;
import oracle.bali.ewt.dnd.InvalidDnDOperationException;

@Deprecated
public class DropTargetContext {
    private DropTarget _dropTarget;
    private int _actions;
    private Transferable _transferable;
    private transient Rectangle _autoscrollArea;
    private transient Scroller _scroller;
    private static final int _AUTOSCROLL_SCHEDULE_TIME = 100;

    public DropTargetContext(DropTarget dt) {
        this._dropTarget = dt;
        this._actions = dt.getDefaultActions();
    }

    public void setTransferable(Transferable t) {
        this._transferable = t;
    }

    public DropTarget getDropTarget() {
        return this._dropTarget;
    }

    public Component getComponent() {
        return this.getDropTarget().getComponent();
    }

    protected void setTargetActions(int actions) {
        this._actions = actions & 0x40000003;
    }

    protected int getTargetActions() {
        return this._actions;
    }

    public void dropComplete(boolean success) throws InvalidDnDOperationException {
        DragSource.getCurrentDragSourceContext().setDragSuccess(success);
    }

    protected void acceptDrag(int dragOperation) {
    }

    protected void rejectDrag() {
    }

    protected void acceptDrop(int dragOperation) {
        DragSource.getCurrentDragSourceContext().setDragOperation(dragOperation);
    }

    protected void rejectDrop() {
        DragSource.getCurrentDragSourceContext().setDragSuccess(false);
    }

    protected DataFlavor[] getCurrentDataFlavors() {
        return this.getTransferable().getTransferDataFlavors();
    }

    protected boolean isDataFlavorSupported(DataFlavor df) {
        return this.getTransferable().isDataFlavorSupported(df);
    }

    protected synchronized Transferable getTransferable() throws InvalidDnDOperationException {
        if (this._transferable == null) {
            this._transferable = DragSource.getCurrentDragSourceContext().getTransferable();
        }
        return this._transferable;
    }

    void _initializeAutoscrolling(Point p) {
        Component c = this.getComponent();
        if (c == null || !(c instanceof Autoscroll)) {
            return;
        }
        Insets autoscrollInsets = ((Autoscroll)((Object)c)).getAutoscrollInsets();
        Rectangle area = new Rectangle();
        DropTargetContext.computeVisibleRect(c, area);
        area.x = autoscrollInsets.left;
        area.y = autoscrollInsets.top;
        area.width -= autoscrollInsets.left + autoscrollInsets.right;
        area.height -= autoscrollInsets.top + autoscrollInsets.bottom;
        this._autoscrollArea = area;
        this._updateAutoscroll(p);
    }

    void _updateAutoscroll(Point dragCursorLocn) {
        Rectangle area = this._autoscrollArea;
        Component c = this.getComponent();
        if (area == null || !(c instanceof Autoscroll)) {
            return;
        }
        dragCursorLocn.x += c.getX();
        dragCursorLocn.y += c.getY();
        if (dragCursorLocn.x < area.x || dragCursorLocn.x > area.x + area.width - 1 || dragCursorLocn.y < area.y || dragCursorLocn.y > area.y + area.height - 1) {
            this._getScroller(true).start(dragCursorLocn.x, dragCursorLocn.y);
        } else {
            this._terminateAutoscroll();
        }
    }

    void _clearAutoscroll() {
        this._autoscrollArea = null;
        this._terminateAutoscroll();
    }

    private void _terminateAutoscroll() {
        Scroller scroller = this._getScroller(false);
        if (scroller != null) {
            scroller.cancel();
        }
    }

    private synchronized Scroller _getScroller(boolean create) {
        Scroller scroller = this._scroller;
        if (create && scroller == null) {
            this._scroller = scroller = new Scroller();
        }
        return scroller;
    }

    private static final void computeVisibleRect(Component c, Rectangle visibleRect) {
        Container p = c.getParent();
        Rectangle bounds = c.getBounds();
        if (p == null || p instanceof Window || p instanceof Applet) {
            visibleRect.setBounds(0, 0, bounds.width, bounds.height);
        } else {
            DropTargetContext.computeVisibleRect(p, visibleRect);
            visibleRect.x -= bounds.x;
            visibleRect.y -= bounds.y;
            SwingUtilities.computeIntersection(0, 0, bounds.width, bounds.height, visibleRect);
        }
    }

    private class Scroller
    implements ActionListener {
        private int _x;
        private int _y;
        private boolean _up;
        private boolean _running;
        private Timer _timer;

        private Scroller() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            boolean doScroll = false;
            DropTarget target = DropTargetContext.this.getDropTarget();
            Point p = null;
            Scroller scroller = this;
            synchronized (scroller) {
                if (this._running) {
                    if (target != null) {
                        this._schedule(100);
                    }
                    doScroll = true;
                    p = new Point(this._x, this._y);
                }
            }
            if (doScroll && target != null) {
                DragTracker.eraseFeedback();
                ((Autoscroll)((Object)target.getComponent())).autoscroll(p);
                DragTracker.drawFeedback();
            }
        }

        public synchronized void cancel() {
            if (this._running) {
                this._running = false;
                if (this._timer != null) {
                    this._timer.stop();
                }
            }
        }

        public synchronized void start(int x, int y) {
            this._x = x;
            this._y = y;
            if (!this._running) {
                this._schedule(100);
            }
        }

        private synchronized void _schedule(int time) {
            this._running = true;
            if (this._timer == null) {
                this._timer = new Timer(time, this);
                this._timer.setRepeats(false);
            } else {
                this._timer.setDelay(time);
            }
            this._timer.start();
        }
    }
}

