/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.chooser.color;

import java.awt.BorderLayout;
import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Locale;
import javax.swing.JLabel;
import oracle.bali.ewt.chooser.color.BaseColorEditor;
import oracle.bali.ewt.chooser.color.HexEditor;
import oracle.bali.share.nls.StringUtils;

class HTMLHexComponent
extends BaseColorEditor {
    private static final String _KEY_LABEL = "COLORCHOOSER.HTML_LABEL";
    private static final String _HEX_EDITOR_NAME = "RGB_Hex_Field";
    private JLabel _label;
    private HexEditor _hexEditor;

    public HTMLHexComponent() {
        Listener listener = new Listener();
        this._hexEditor = new HexEditor();
        this._hexEditor.addPropertyChangeListener(listener);
        this._hexEditor.setName(_HEX_EDITOR_NAME);
        this._label = new JLabel(" ");
        this._label.setLabelFor(this._hexEditor);
        this.setLayout(new BorderLayout(12, 0));
        this.add("West", this._label);
        this.add("Center", this._hexEditor);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this._label.setEnabled(enabled);
        this._hexEditor.setEnabled(enabled);
    }

    @Override
    protected void colorChanged(Color newColor) {
        this._hexEditor.setColor(newColor);
    }

    @Override
    protected void updateLabels(Locale newLocale) {
        String translatedText = HTMLHexComponent.__getTranslatedString(newLocale, _KEY_LABEL);
        this._label.setText(StringUtils.stripMnemonic((String)translatedText));
        this._label.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
    }

    private void _updateColor(Color color) {
        this.storeColor(color);
    }

    private class Listener
    implements PropertyChangeListener {
        private Listener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            String name = e.getPropertyName();
            if ("color".equals(name)) {
                HTMLHexComponent.this._updateColor((Color)e.getNewValue());
            }
        }
    }
}

