/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.chooser.color;

import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Locale;
import javax.swing.JLabel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.bali.ewt.chooser.color.BaseColorEditor;
import oracle.bali.ewt.graphics.ColorUtils;
import oracle.bali.ewt.spinBox.NumericSpinBox;
import oracle.bali.share.nls.StringUtils;

class HSLComponent
extends BaseColorEditor {
    private static final int _MAX_HUE = 360;
    private static final int _MAX_SAT = 100;
    private static final int _MAX_LUM = 100;
    private static final String _KEY_HUE = "COLORCHOOSER.HUE_LABEL";
    private static final String _KEY_SAT = "COLORCHOOSER.SAT_LABEL";
    private static final String _KEY_LUM = "COLORCHOOSER.LUM_LABEL";
    private static final String _KEY_HUE_DESC = "COLORCHOOSER.HUE_DESCRIPTION";
    private static final String _KEY_SAT_DESC = "COLORCHOOSER.SAT_DESCRIPTION";
    private static final String _KEY_LUM_DESC = "COLORCHOOSER.LUM_DESCRIPTION";
    private static final String _HUE_NAME = "Hue_Box";
    private static final String _SAT_NAME = "Saturation_Box";
    private static final String _LUM_NAME = "Luminance_Box";
    private boolean _ignoreEvents;
    private JLabel _hueLabel;
    private JLabel _lumLabel;
    private JLabel _satLabel;
    private NumericSpinBox _hue;
    private NumericSpinBox _sat;
    private NumericSpinBox _lum;

    public HSLComponent() {
        Insets inset;
        Listener listener = new Listener();
        this._hue = new NumericSpinBox(0, 360);
        this._hue.addChangeListener(listener);
        this._hue.setName(_HUE_NAME);
        this._sat = new NumericSpinBox(0, 100);
        this._sat.addChangeListener(listener);
        this._sat.setName(_SAT_NAME);
        this._lum = new NumericSpinBox(0, 100);
        this._lum.addChangeListener(listener);
        this._lum.setName(_LUM_NAME);
        this._hueLabel = new JLabel(" ");
        this._hueLabel.setLabelFor(this._hue);
        this._satLabel = new JLabel(" ");
        this._satLabel.setLabelFor(this._sat);
        this._lumLabel = new JLabel(" ");
        this._lumLabel.setLabelFor(this._lum);
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.insets = inset = new Insets(0, 0, 3, 12);
        this.setLayout(layout);
        gbc.gridwidth = -1;
        layout.setConstraints(this._hueLabel, gbc);
        this.add(this._hueLabel);
        gbc.gridwidth = 0;
        inset.right = 0;
        layout.setConstraints(this._hue, gbc);
        this.add(this._hue);
        gbc.gridwidth = -1;
        inset.right = 12;
        layout.setConstraints(this._satLabel, gbc);
        this.add(this._satLabel);
        gbc.gridwidth = 0;
        inset.right = 0;
        layout.setConstraints(this._sat, gbc);
        this.add(this._sat);
        gbc.gridwidth = -1;
        inset.bottom = 0;
        inset.right = 12;
        layout.setConstraints(this._lumLabel, gbc);
        this.add(this._lumLabel);
        gbc.gridwidth = 0;
        inset.right = 0;
        layout.setConstraints(this._lum, gbc);
        this.add(this._lum);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this._hueLabel.setEnabled(enabled);
        this._lumLabel.setEnabled(enabled);
        this._satLabel.setEnabled(enabled);
        this._hue.setEnabled(enabled);
        this._sat.setEnabled(enabled);
        this._lum.setEnabled(enabled);
    }

    @Override
    protected void updateLabels(Locale newLocale) {
        String translatedText = HSLComponent.__getTranslatedString(newLocale, _KEY_HUE);
        this._hueLabel.setText(StringUtils.stripMnemonic((String)translatedText));
        this._hueLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
        translatedText = HSLComponent.__getTranslatedString(newLocale, _KEY_SAT);
        this._satLabel.setText(StringUtils.stripMnemonic((String)translatedText));
        this._satLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
        translatedText = HSLComponent.__getTranslatedString(newLocale, _KEY_LUM);
        this._lumLabel.setText(StringUtils.stripMnemonic((String)translatedText));
        this._lumLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
    }

    @Override
    protected void updateAccessibleNames() {
        String text = this.__getTranslatedString(_KEY_HUE_DESC);
        this._hue.getAccessibleContext().setAccessibleName(text);
        text = this.__getTranslatedString(_KEY_SAT_DESC);
        this._sat.getAccessibleContext().setAccessibleName(text);
        text = this.__getTranslatedString(_KEY_LUM_DESC);
        this._lum.getAccessibleContext().setAccessibleName(text);
    }

    @Override
    protected void colorChanged(Color newColor) {
        double[] hsl = ColorUtils.rgbToHSL(newColor.getRed(), newColor.getGreen(), newColor.getBlue());
        this._ignoreEvents = true;
        this._hue.setIntValue((int)hsl[0]);
        this._sat.setIntValue((int)hsl[1]);
        this._lum.setIntValue((int)hsl[2]);
        this._ignoreEvents = false;
    }

    private void _updateColor() {
        double hue = this._hue.getIntValue();
        double sat = this._sat.getIntValue();
        double lum = this._lum.getIntValue();
        int[] newCol = ColorUtils.hslToRGB(hue, sat, lum);
        this.storeColor(new Color(newCol[0], newCol[1], newCol[2]));
    }

    private class Listener
    implements ChangeListener {
        private Listener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            if (!HSLComponent.this._ignoreEvents) {
                HSLComponent.this._updateColor();
            }
        }
    }
}

