/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.border;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import oracle.bali.ewt.LWComponent;

public class GrayPane
extends LWComponent
implements Accessible {
    private Component _content;

    public GrayPane() {
        this(null);
    }

    public GrayPane(Component content) {
        this.setLayout(new BorderLayout());
        this.setContent(content);
        this.setOpaque(true);
        this.updateUI();
    }

    public Component getContent() {
        return this._content;
    }

    public void setContent(Component content) {
        Component oldContent = this._content;
        if (content != oldContent) {
            if (oldContent != null) {
                this.remove(oldContent);
            }
            this._content = content;
            if (content != null) {
                this.add(content, "Center");
            }
            this.revalidate();
        }
    }

    @Override
    public void updateUI() {
        LookAndFeel.uninstallBorder(this);
        LookAndFeel.installColors(this, "EWTGrayPane.background", "EWTGrayPane.foreground");
        LookAndFeel.installBorder(this, "EWTGrayPane.border");
        this.setUI(null);
    }

    @Override
    protected void addImpl(Component comp, Object constraints, int index) {
        if (comp != this.getContent()) {
            this.setContent(comp);
        } else {
            super.addImpl(comp, constraints, index);
        }
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleGrayPane();
        }
        return this.accessibleContext;
    }

    private class AccessibleGrayPane
    extends JComponent.AccessibleJComponent {
        private AccessibleGrayPane() {
            super(GrayPane.this);
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.PANEL;
        }
    }
}

