/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.deferredupdate.task;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import oracle.ideimpl.deferredupdate.UpdateArb;
import oracle.ideimpl.deferredupdate.task.AtomicTask;
import oracle.ideimpl.deferredupdate.task.TaskContext;
import oracle.ideimpl.deferredupdate.task.TaskFailedException;

class WritePropertiesFile
extends AtomicTask {
    private final File _file;
    private final Properties _oldProperties;
    private final Properties _newProperties;
    private boolean _wrote;

    WritePropertiesFile(File file, Properties oldProps, Properties newProps) {
        this._file = file;
        this._oldProperties = oldProps;
        this._newProperties = newProps;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void perform(TaskContext tc) throws TaskFailedException {
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(this._file);
            this._newProperties.store(os, "");
            this._wrote = true;
            if (os == null) return;
        }
        catch (IOException ioe) {
            try {
                throw new TaskFailedException(UpdateArb.format("WRITE_FAILED", this._file), ioe);
            }
            catch (Throwable throwable) {
                if (os == null) throw throwable;
                try {
                    ((OutputStream)os).close();
                    throw throwable;
                }
                catch (IOException ioe2) {
                    throw new TaskFailedException(UpdateArb.format("WRITE_FAILED", this._file), ioe2);
                }
            }
        }
        try {
            ((OutputStream)os).close();
            return;
        }
        catch (IOException ioe) {
            throw new TaskFailedException(UpdateArb.format("WRITE_FAILED", this._file), ioe);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void rollback(TaskContext tc) throws TaskFailedException {
        if (!this._wrote) return;
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(this._file);
            this._oldProperties.store(os, "");
            this._wrote = false;
            if (os == null) return;
        }
        catch (IOException ioe) {
            try {
                throw new TaskFailedException(UpdateArb.format("WRITE_FAILED", this._file), ioe);
            }
            catch (Throwable throwable) {
                if (os == null) throw throwable;
                try {
                    os.close();
                    throw throwable;
                }
                catch (IOException ioe2) {
                    throw new TaskFailedException(UpdateArb.format("WRITE_FAILED", this._file), ioe2);
                }
            }
        }
        try {
            os.close();
            return;
        }
        catch (IOException ioe) {
            throw new TaskFailedException(UpdateArb.format("WRITE_FAILED", this._file), ioe);
        }
    }
}

