/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.deferredupdate.task;

import java.util.ArrayList;
import oracle.ideimpl.deferredupdate.UpdateArb;
import oracle.ideimpl.deferredupdate.task.AtomicTask;
import oracle.ideimpl.deferredupdate.task.InconsistentStateException;
import oracle.ideimpl.deferredupdate.task.TaskContext;
import oracle.ideimpl.deferredupdate.task.TaskFailedException;

final class TaskStack {
    private final ArrayList _tasks = new ArrayList();

    TaskStack() {
    }

    public void performTask(AtomicTask task, TaskContext tc) throws TaskFailedException {
        try {
            this._tasks.add(task);
            task.perform(tc);
        }
        catch (RuntimeException re) {
            throw new TaskFailedException(UpdateArb.get("RUNTIME_EXCEPTION_OCCURRED"));
        }
    }

    public void rollbackTasks(TaskContext tc) throws InconsistentStateException {
        for (int i = this._tasks.size() - 1; i >= 0; --i) {
            AtomicTask task = null;
            try {
                task = (AtomicTask)this._tasks.get(i);
                task.rollback(tc);
                continue;
            }
            catch (Exception e) {
                throw new InconsistentStateException(UpdateArb.format("ROLLBACK_FAILED", String.valueOf(task)));
            }
        }
    }

    public void commitTasks(TaskContext tc) throws TaskFailedException {
        for (AtomicTask task : this._tasks) {
            task.commit(tc);
        }
    }
}

