/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.deferredupdate.task;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import oracle.ideimpl.deferredupdate.UpdateArb;
import oracle.ideimpl.deferredupdate.task.AtomicTask;
import oracle.ideimpl.deferredupdate.task.TaskContext;
import oracle.ideimpl.deferredupdate.task.TaskFailedException;

class ReadPropertiesFile
extends AtomicTask {
    private final File _file;
    private Properties _properties;

    ReadPropertiesFile(File propsFile) {
        this._file = propsFile;
    }

    @Override
    public void perform(TaskContext tc) throws TaskFailedException {
        FileInputStream is = null;
        try {
            is = new FileInputStream(this._file);
            Properties p = new Properties();
            p.load(is);
            this._properties = p;
        }
        catch (IOException ioe) {
            throw new TaskFailedException(UpdateArb.format("READ_FAILED", this._file), ioe);
        }
        finally {
            if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException ioe) {
                    throw new TaskFailedException(UpdateArb.get("IO_EXCEPTION"), ioe);
                }
            }
        }
    }

    public Properties getLoadedProperties() {
        return this._properties;
    }

    @Override
    public void rollback(TaskContext tc) throws TaskFailedException {
        this._properties = null;
    }
}

