/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.deferredupdate.task;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import oracle.ideimpl.deferredupdate.Directories;
import oracle.ideimpl.deferredupdate.task.AtomicTask;
import oracle.ideimpl.deferredupdate.task.BundleDetails;
import oracle.ideimpl.deferredupdate.task.CreateDirectory;
import oracle.ideimpl.deferredupdate.task.DeleteExtraInfoTask;
import oracle.ideimpl.deferredupdate.task.MoveFile;
import oracle.ideimpl.deferredupdate.task.TaskContext;
import oracle.ideimpl.deferredupdate.task.TaskFailedException;
import oracle.ideimpl.deferredupdate.task.TaskStack;
import oracle.ideimpl.deferredupdate.task.TaskUtil;
import oracle.ideimpl.deferredupdate.task.UpdateBundlesInfoTask;

public class DeinstallExtensionTask
extends AtomicTask {
    private Map<String, List<String>> properties = new LinkedHashMap<String, List<String>>();
    private TaskStack _tasks;
    private String extensionId;
    private String version;
    private List<BundleDetails> bundles = new ArrayList<BundleDetails>();

    DeinstallExtensionTask(String extensionId, String version) {
        this.extensionId = extensionId;
        this.version = version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void perform(TaskContext tc) throws TaskFailedException {
        block12: {
            this._tasks = new TaskStack();
            tc.getProgress().setPercentProgress(0.0);
            try {
                List<Object> installedFiles = new ArrayList();
                List<Object> replacedFiles = new ArrayList();
                List<Object> createdDirectories = new ArrayList();
                LinkedHashMap<String, List<String>> installedFilesProperties = this.readInstalledProperties(tc);
                if (installedFilesProperties != null && !installedFilesProperties.isEmpty()) {
                    installedFiles = this.findFiles(installedFilesProperties, "file_created");
                    replacedFiles = this.findReplacedFiles(tc, installedFilesProperties);
                    createdDirectories = this.findFiles(installedFilesProperties, "directory_created");
                } else {
                    installedFiles = this.findFilesBasedOnExtensionName(tc);
                }
                if (!(installedFiles != null && !installedFiles.isEmpty() || replacedFiles != null && !replacedFiles.isEmpty()) && (createdDirectories == null || createdDirectories.isEmpty())) break block12;
                File extBackupDir = this.createBackupDirectory(tc);
                if (installedFiles != null) {
                    for (File file : installedFiles) {
                        this.checkForBundles(file);
                        this.moveFile(tc, file, extBackupDir);
                    }
                }
                if (replacedFiles != null) {
                    for (BackedUpFile backedUpFile : replacedFiles) {
                        this.checkForBundles(backedUpFile._currentFile);
                        backedUpFile.restore(tc, extBackupDir);
                    }
                }
                if (createdDirectories == null) break block12;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                AtomicTask updateTask = new UpdateBundlesInfoTask(this.bundles, true);
                this._tasks.performTask(updateTask, tc);
                for (BundleDetails bundle : this.bundles) {
                    updateTask = new DeleteExtraInfoTask(bundle.getBundleSymbolicName());
                    this._tasks.performTask(updateTask, tc);
                }
            }
        }
        tc.getProgress().setPercentProgress(1.0);
    }

    private void moveFile(TaskContext tc, File fileToMove, File extBackupDir) throws TaskFailedException {
        if (fileToMove.exists()) {
            File home = new File(tc.getDirectories().getOracleHome());
            URI u1 = home.toURI();
            URI u2 = fileToMove.toURI();
            URI relavtiveFileName = u1.relativize(u2);
            File backupFile = new File(extBackupDir, relavtiveFileName.getPath());
            this._tasks.performTask(new MoveFile(fileToMove, backupFile), tc);
        }
    }

    private List<File> findFiles(Map<String, List<String>> installedFilesProperties, String key) {
        ArrayList<File> files = new ArrayList<File>();
        List<String> list = installedFilesProperties.get(key);
        if (list != null) {
            for (String path : list) {
                File f = new File(path);
                if (!f.exists()) continue;
                files.add(f);
            }
        }
        return files;
    }

    private List<BackedUpFile> findReplacedFiles(TaskContext tc, Map<String, List<String>> installedFilesProperties) {
        ArrayList<BackedUpFile> replacedFiles = new ArrayList<BackedUpFile>();
        List<String> list = installedFilesProperties.get("backed_up_file");
        if (list != null && !list.isEmpty()) {
            for (String s : list) {
                replacedFiles.add(BackedUpFile.createBackedUpFile(s, this._tasks));
            }
        }
        return replacedFiles;
    }

    private File createBackupDirectory(TaskContext tc) throws TaskFailedException {
        File extBackupDir;
        File bundlesHome = TaskUtil.findBundlesHome(tc);
        File backupsDir = new File(bundlesHome, "backups");
        if (!backupsDir.exists()) {
            this._tasks.performTask(new CreateDirectory(backupsDir), tc);
        }
        tc.getProgress().setPercentProgress(0.33);
        File extensionParentDir = new File(backupsDir, this.extensionId);
        if (!extensionParentDir.exists()) {
            this._tasks.performTask(new CreateDirectory(extensionParentDir), tc);
        }
        if ((extBackupDir = new File(extensionParentDir, this.version)).exists()) {
            int suffix = 1;
            while ((extBackupDir = new File(extensionParentDir, this.version + "_" + String.valueOf(suffix))).exists()) {
                ++suffix;
            }
        }
        this._tasks.performTask(new CreateDirectory(extBackupDir), tc);
        tc.getProgress().setPercentProgress(0.66);
        return extBackupDir;
    }

    private List<File> findFilesBasedOnExtensionName(TaskContext tc) throws TaskFailedException {
        List<File> files = new ArrayList<File>();
        File userExtDir = new File(tc.getDirectories().getUserExtensionsHome());
        if (userExtDir.exists() && userExtDir.isDirectory()) {
            files = this.findExtensionFiles(userExtDir, this.extensionId);
        }
        if (files.isEmpty()) {
            boolean isUserExt = false;
            File systemExtDir = new File(tc.getDirectories().getGlobalExtensionsHome());
            if (systemExtDir.exists() && systemExtDir.isDirectory()) {
                files = this.findExtensionFiles(systemExtDir, this.extensionId);
                if (files.isEmpty()) {
                    tc.getProgress().setPercentProgress(1.0);
                }
            } else {
                tc.getProgress().setPercentProgress(1.0);
            }
        }
        return files;
    }

    private LinkedHashMap<String, List<String>> readInstalledProperties(TaskContext tc) throws TaskFailedException {
        LinkedHashMap<String, List<String>> filesInstalledProperties = null;
        Directories directories = tc.getDirectories();
        String bundlesInfoHome = directories.getBundlesInfoHome();
        File updatesDir = new File(bundlesInfoHome, "updates");
        if (updatesDir.exists()) {
            File ef = new File(updatesDir, this.extensionId + ".installinfo");
            if (ef.exists()) {
                filesInstalledProperties = TaskUtil.readProperties(ef);
            } else {
                block0: for (File file : updatesDir.listFiles()) {
                    if (!file.getName().endsWith(".installinfo")) continue;
                    LinkedHashMap<String, List<String>> properties = TaskUtil.readProperties(file);
                    List<String> extensionNames = properties.get("extension_name");
                    for (String extensionName : extensionNames) {
                        if (!this.extensionId.equals(extensionName)) continue;
                        filesInstalledProperties = properties;
                        continue block0;
                    }
                }
            }
        }
        return filesInstalledProperties;
    }

    private List<File> findExtensionFiles(File extDir, String id) throws TaskFailedException {
        ArrayList<File> alFiles = new ArrayList<File>(2);
        File[] children = extDir.listFiles();
        for (int i = 0; i < children.length; ++i) {
            File child = children[i];
            if (!id.equals(this.getExtensionID(child))) continue;
            alFiles.add(child);
        }
        return alFiles;
    }

    private void checkForBundles(File file) throws TaskFailedException {
        if (file.isFile()) {
            BundleDetails details = BundleDetails.getOsgiBundleDetails(file);
            if (details != null) {
                this.bundles.add(details);
            }
        } else if (file.isDirectory()) {
            File[] children;
            for (File child : children = file.listFiles()) {
                this.checkForBundles(child);
            }
        }
    }

    private String getExtensionID(File file) {
        StringBuffer idBuffer = new StringBuffer();
        StringTokenizer tok = new StringTokenizer(file.getName(), ".");
        while (tok.hasMoreTokens()) {
            String token = tok.nextToken();
            if ("jar".equalsIgnoreCase(token) || DeinstallExtensionTask.isNumber(token)) continue;
            idBuffer.append(token);
            idBuffer.append(".");
        }
        if (idBuffer.length() == 0) {
            return null;
        }
        idBuffer.setLength(idBuffer.length() - 1);
        return idBuffer.toString();
    }

    private static final boolean isNumber(String s) {
        for (int i = 0; i < s.length(); ++i) {
            if (Character.isDigit(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public void rollback(TaskContext tc) throws TaskFailedException {
        if (this._tasks != null) {
            this._tasks.rollbackTasks(tc);
        }
    }

    private static class FileBackup {
        private FileBackup() {
        }
    }

    private static class BackedUpFile {
        File _backedUpFile;
        File _currentFile;
        TaskStack _tasks;

        public static BackedUpFile createBackedUpFile(String s, TaskStack tasks) {
            int orgIndex = s.indexOf("ORIGINAL:") + "ORIGINAL:".length();
            int backIndex = s.indexOf("BACKUP:") + "BACKUP:".length();
            String current = s.substring(orgIndex, s.indexOf(44));
            String back = s.substring(backIndex);
            return new BackedUpFile(tasks, new File(back), new File(current));
        }

        BackedUpFile(TaskStack tasks, File backedUpFile, File currentFile) {
            this._backedUpFile = backedUpFile;
            this._currentFile = currentFile;
            this._tasks = tasks;
        }

        public boolean restore(TaskContext tc, File extBackupDir) throws TaskFailedException {
            if (this._currentFile.exists()) {
                File toBackup = new File(extBackupDir, this._currentFile.getName());
                this._tasks.performTask(new MoveFile(this._currentFile, toBackup), tc);
            }
            if (!this._currentFile.exists()) {
                this._tasks.performTask(new MoveFile(this._backedUpFile, this._currentFile), tc);
            }
            return false;
        }
    }
}

