/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.deferredupdate.task;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oracle.ideimpl.deferredupdate.UpdateArb;
import oracle.ideimpl.deferredupdate.task.AtomicTask;
import oracle.ideimpl.deferredupdate.task.TaskContext;
import oracle.ideimpl.deferredupdate.task.TaskFailedException;

final class CreateDirectory
extends AtomicTask {
    private final File _directory;
    private List _createdDirectories;

    public CreateDirectory(File directory) {
        this._directory = directory;
    }

    @Override
    public void perform(TaskContext tc) throws TaskFailedException {
        if (this._directory.exists()) {
            if (this._directory.isDirectory()) {
                this._createdDirectories = Collections.EMPTY_LIST;
            } else {
                throw new TaskFailedException(UpdateArb.format("CREATE_DIR_FAILED", this._directory.getPath()));
            }
        }
        this._createdDirectories = new ArrayList();
        if (!this.mkdir(this._directory)) {
            throw new TaskFailedException(UpdateArb.format("CREATE_DIR_FAILED", this._directory.getPath()));
        }
    }

    private boolean mkdir(File directory) {
        if (directory.exists() && directory.isDirectory()) {
            return true;
        }
        File parentDir = directory.getParentFile();
        if (parentDir.exists()) {
            if (directory.mkdir()) {
                this._createdDirectories.add(directory);
                return true;
            }
            return false;
        }
        return this.mkdir(parentDir);
    }

    @Override
    public void rollback(TaskContext tc) throws TaskFailedException {
        ArrayList directoriesToDelete = new ArrayList(this._createdDirectories);
        Collections.reverse(directoriesToDelete);
        for (File thisDirectory : directoriesToDelete) {
            if (thisDirectory.delete()) continue;
            throw new TaskFailedException(UpdateArb.format("DELETE_FAILED", thisDirectory.getPath()));
        }
    }
}

