/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.osgi.boot;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import oracle.ide.osgi.boot.FontBranding;
import oracle.ide.osgi.boot.api.IdeBootProperties;
import oracle.ide.osgi.boot.api.IdeBootUtil;
import oracle.ide.osgi.boot.api.Platform;

public final class SplashScreenImpl
extends JDialog
implements AWTEventListener {
    private static final String VERSION_TEXT = "Version %s";
    private static final Font VERSION_FONT = new Font("SanSerif", 0, 11);
    private static final Font COPYRIGHT_FONT = new Font("SanSerif", 0, 9);
    private static final Color VERSION_COLOR = Color.RED;
    private static final Color COPYRIGHT_COLOR = Color.WHITE;
    private static final int VERSION_RIGHT_PADDING = 52;
    private static final int VERSION_IMAGE_TOP = 211;
    private static final int VERSION_TEXT_TOP = 220;
    private static final int COPYRIGHT_LEFT_PADDING = 70;
    private static final int COPYRIGHT_IMAGE_BOTTOM_PADDING = 30;
    private static final int COPYRIGHT_TEXT_BOTTOM_PADDING = 12;
    private static String VERSION = null;
    private static String COPYRIGHT_START_YEAR = null;
    private static String COPYRIGHT_END_YEAR = null;
    private static File BACKGROUND_IMAGE_FILE = null;
    private static String LOGO_IMAGE_FILE_NAME = null;
    private ImagePanel _panel;
    private JFrame _owner = null;
    private ISplashScreenPlugin _plugin = null;
    private Boolean _initialized = false;
    private Boolean _initializedPlugin = false;
    private Object _savedSource = null;

    public SplashScreenImpl(JFrame owner) {
        super(owner);
        if (owner != null) {
            this._owner = owner;
        }
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public JFrame getOwner() {
        return this._owner;
    }

    private JPanel getPanel() {
        return this._panel;
    }

    public void destroy() {
        this.setWindowHook(false);
        this._savedSource = null;
        this._plugin = null;
        this._owner = null;
    }

    private void jbInit() throws Exception {
        boolean opaque;
        this.setUndecorated(true);
        this.setResizable(false);
        this.setSize(400, 300);
        this.setBackground(Color.WHITE);
        this._panel = new ImagePanel(BACKGROUND_IMAGE_FILE, LOGO_IMAGE_FILE_NAME, VERSION, COPYRIGHT_START_YEAR, COPYRIGHT_END_YEAR);
        this._panel.setLayout(null);
        this._panel.setDoubleBuffered(true);
        this.setSize(this._panel.getImageWidth(), this._panel.getImageHeight());
        this.setName("SplashScreen");
        this.add(this._panel);
        Platform.PlatformType platform = Platform.getPlatform();
        switch (platform) {
            case ptMac: {
                this.setBackground(new Color(0, 0, 0, 0));
                opaque = true;
                break;
            }
            case ptWindows: 
            case ptLinux: {
                opaque = false;
                if (IdeBootProperties.isSplashScreenRectangular()) {
                    GeneralPath shape = new GeneralPath();
                    shape.moveTo(5.0f, 5.0f);
                    shape.lineTo(this.getWidth() - 5, 5.0f);
                    shape.lineTo(this.getWidth() - 5, this.getHeight() - 5);
                    shape.lineTo(5.0f, this.getHeight() - 5);
                    shape.lineTo(5.0f, 5.0f);
                    shape.closePath();
                    this.setShape(shape);
                    break;
                }
                GeneralPath shape = new GeneralPath();
                shape.moveTo(5.0f, 5.0f);
                shape.lineTo(this.getWidth() - 85, 5.0f);
                shape.lineTo(this.getWidth() - 5, 60.0f);
                shape.lineTo(this.getWidth() - 5, this.getHeight() - 5);
                shape.lineTo(142.0f, this.getHeight() - 5);
                shape.lineTo(5.0f, 205.0f);
                shape.lineTo(5.0f, 5.0f);
                shape.closePath();
                this.setShape(shape);
                break;
            }
            default: {
                opaque = false;
            }
        }
        this._panel.setOpaque(opaque);
    }

    private static File getSplashImage() {
        File confDirSplash;
        String splashImg = IdeBootProperties.getIdeSplashScreen();
        if (splashImg == null) {
            return null;
        }
        File image = SplashScreenImpl.abs(new File(splashImg));
        if (image.exists()) {
            return image;
        }
        String confDir = new File(IdeBootProperties.getIdeConfPath()).getParent();
        if (confDir != null && (confDirSplash = SplashScreenImpl.abs(new File(confDir, splashImg))).exists()) {
            return confDirSplash;
        }
        return null;
    }

    private static File abs(File f) {
        try {
            return f.getCanonicalFile();
        }
        catch (IOException ex) {
            return f.getAbsoluteFile();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void display(boolean value) {
        if (this.isVisible() != value) {
            final boolean lvalue = value;
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    SplashScreenImpl.this.setVisible(lvalue);
                }
            };
            SplashScreenImpl.SynchronizeWithEdt(runnable, "SplashScreenImpl.display");
            if (!value) {
                if (this._plugin != null) {
                    this._plugin.stop();
                }
            } else {
                Boolean bl = this._initialized;
                synchronized (bl) {
                    if (!this._initialized.booleanValue()) {
                        this._initialized = true;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initializePlugins() {
        Boolean bl = this._initializedPlugin;
        synchronized (bl) {
            if (this._plugin != null && !this._initializedPlugin.booleanValue()) {
                this._initializedPlugin = true;
                this._plugin.initialize();
            }
        }
    }

    public void setWindowHook(boolean value) {
        if (value) {
            Toolkit.getDefaultToolkit().addAWTEventListener(this, 65L);
        } else {
            Toolkit.getDefaultToolkit().removeAWTEventListener(this);
        }
    }

    public void setPlugin(ISplashScreenPlugin plugin) {
        final JPanel panel = this.getPanel();
        if (this._plugin == null) {
            this._plugin = plugin;
            final Dimension size = this.getSize();
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    SplashScreenImpl.this._plugin.setSize(size.width, size.height);
                    panel.add(SplashScreenImpl.this._plugin.getComponent());
                }
            };
            SplashScreenImpl.SynchronizeWithEdt(runnable, "Error adding plugin.");
        }
    }

    public ISplashScreenPlugin getPlugin() {
        return this._plugin;
    }

    @Override
    public void eventDispatched(AWTEvent e) {
        Object source = e.getSource();
        if (this != source && !(source instanceof JFrame)) {
            switch (e.getID()) {
                case 200: {
                    this._savedSource = source;
                    this.display(false);
                    break;
                }
                case 202: {
                    if (this._savedSource != null && source != this._savedSource) {
                        return;
                    }
                    this.display(true);
                    break;
                }
                case 103: {
                    if (!(source instanceof Dialog)) break;
                    if (this._savedSource != null && source != this._savedSource) {
                        return;
                    }
                    this.display(true);
                }
            }
        }
    }

    public static void SynchronizeWithEdt(Runnable runnable, String message) {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (Exception e) {
                throw new IllegalStateException(message, e);
            }
        }
    }

    static {
        BACKGROUND_IMAGE_FILE = SplashScreenImpl.getSplashImage();
        if (BACKGROUND_IMAGE_FILE != null) {
            String binDir = BACKGROUND_IMAGE_FILE.getParent() + File.separatorChar;
            LOGO_IMAGE_FILE_NAME = binDir + "logo.png";
            File propertiesFile = new File(binDir + "version.properties");
            if (propertiesFile.exists()) {
                InputStream fis = null;
                try {
                    Properties properties = new Properties();
                    if (properties != null) {
                        fis = new FileInputStream(propertiesFile);
                        properties.load(fis);
                        VERSION = properties.getProperty("VER");
                    }
                }
                catch (IOException exception) {
                    throw new IllegalStateException("Error loading properties file.", exception);
                }
                finally {
                    try {
                        if (fis != null) {
                            fis.close();
                        }
                    }
                    catch (IOException e) {
                        Logger.getLogger("oracle.ide.osgi.boot").log(Level.SEVERE, "Failed to close file input stream of file " + propertiesFile, e);
                    }
                }
            }
        }
        COPYRIGHT_START_YEAR = System.getProperty("copyright.year.start");
        COPYRIGHT_END_YEAR = System.getProperty("copyright.year.end");
        if (COPYRIGHT_START_YEAR == null) {
            COPYRIGHT_START_YEAR = "1997";
        }
        if (COPYRIGHT_END_YEAR == null) {
            COPYRIGHT_END_YEAR = "2016";
        }
    }

    public static interface IDeterminateProgress
    extends IProgress {
        public boolean initialized();

        public void initialize(int var1);

        public void incrementProgress(int var1);
    }

    public static interface IIndeterminateProgress
    extends IProgress {
        public boolean initialized();

        public void initialize(int var1, int var2);
    }

    public static interface IProgress {
        public String getName();

        public void setTitle(String var1);

        public String getTitle();

        public void setDescription(String var1);

        public String getDescription();

        public boolean start();

        public void stop();

        public ProgressState getProgressState();
    }

    public static enum ProgressState {
        NOTSTARTED,
        RUNNING,
        COMPLETED;

    }

    public static interface ISplashScreenPlugin {
        public JComponent getComponent();

        public void stop();

        public void setSize(int var1, int var2);

        public void initialize();
    }

    public static interface IProgressDialog {
        public IIndeterminateProgress allocateIndeterminateProgress(String var1, int var2);

        public IDeterminateProgress allocateDeterminateProgress(String var1, int var2);

        public void finalizeDeterminateProgress(String var1, int var2);

        public void finalizeIndeterminateProgress(String var1, int var2, int var3);

        public void completeProgress(String var1);

        public IProgress findProgress(String var1);
    }

    private static final class ImagePanel
    extends JPanel {
        private static BufferedImage _backgroundImage = null;
        private static BufferedImage _logoImage = null;
        private static int _width = 0;
        private static int _height = 0;

        public ImagePanel(File backgroundImageFile, String logoImageFilename, String version, String copyrightStartYear, String copyrightEndYear) {
            if (_backgroundImage == null && logoImageFilename != null) {
                File logoImageFile = new File(logoImageFilename);
                if (backgroundImageFile.exists()) {
                    try {
                        _backgroundImage = ImageIO.read(backgroundImageFile);
                        if (logoImageFile.exists()) {
                            _logoImage = ImageIO.read(logoImageFile);
                        }
                        _width = _backgroundImage.getWidth();
                        _height = _backgroundImage.getHeight();
                        if (version != null || copyrightStartYear != null || copyrightEndYear != null) {
                            String brandingFilename;
                            File brandingFile;
                            Graphics2D graphics2D = (Graphics2D)_backgroundImage.getGraphics();
                            if (_logoImage != null) {
                                graphics2D.drawImage((Image)_logoImage, 158, 40, null);
                            }
                            if ((brandingFile = new File(brandingFilename = System.getProperty("oracle.home") + File.separatorChar + "ide" + File.separatorChar + "bin" + File.separatorChar + "SplashFontBranding.png")).exists()) {
                                FontBranding.initialize(brandingFilename);
                                FontBranding.drawSplashScreenVersion(graphics2D, _width - 120 - 52, 211, version);
                                FontBranding.drawSplashScreenCopyright(graphics2D, this.center(_width, 304) + 70, _height - 30, copyrightStartYear, copyrightEndYear);
                            } else {
                                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                                graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                                String versionText = String.format(SplashScreenImpl.VERSION_TEXT, version);
                                String copyrightText = IdeBootUtil.COPYRIGHT_RESOLVED_TEXT;
                                graphics2D.setFont(VERSION_FONT);
                                FontMetrics fm = graphics2D.getFontMetrics();
                                int textWidth = fm.stringWidth(versionText);
                                graphics2D.setColor(VERSION_COLOR);
                                graphics2D.drawString(versionText, _width - textWidth - 52, 220);
                                graphics2D.setFont(COPYRIGHT_FONT);
                                fm = graphics2D.getFontMetrics();
                                textWidth = fm.stringWidth(copyrightText);
                                int textHeight = fm.getHeight();
                                graphics2D.setColor(COPYRIGHT_COLOR);
                                graphics2D.drawString(copyrightText, this.center(_width, textWidth) + 70, _height - textHeight - 12);
                            }
                        }
                    }
                    catch (IOException exception) {
                        throw new IllegalStateException("Error loading splash screen image.", exception);
                    }
                }
            }
        }

        private int center(int p1, int p2) {
            return p1 / 2 - p2 / 2;
        }

        @Override
        public void paintComponent(Graphics g) {
            if (_backgroundImage != null) {
                g.drawImage(_backgroundImage, 0, 0, this);
            }
        }

        public int getImageWidth() {
            return _width;
        }

        public int getImageHeight() {
            return _height;
        }
    }
}

