/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.osgi.boot;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;

public final class FontBranding {
    private static BufferedImage _mapImage = null;
    private static BufferedImage _imageSplashScreenCopyright = null;
    private static BufferedImage _imageSplashScreenVersion = null;
    public static final int SPLASH_SCREEN_COPYRIGHT_WIDTH = 304;
    public static final int SPLASH_SCREEN_LABEL_WIDTH = 120;

    public static synchronized void initialize(String filename) {
        File file;
        if (_mapImage == null && (file = new File(filename)).exists()) {
            try {
                _mapImage = ImageIO.read(file);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static synchronized void destroySplashScreenImages() {
        _mapImage = null;
        _imageSplashScreenVersion = null;
    }

    public static void drawSplashScreenCopyright(Graphics2D graphics, int x, int y, String startYear, String year) {
        if (_imageSplashScreenCopyright == null) {
            BufferedImage image = new BufferedImage(304, 11, _mapImage.getType());
            Graphics2D imageGraphics = image.createGraphics();
            int left = 0;
            left = FontBranding.draw(_mapImage, imageGraphics, left, 0, 0, 52, 11, FontAlignment.LEFT);
            left = FontBranding.drawSplashScreenCopyrightText(_mapImage, imageGraphics, startYear, left);
            left = FontBranding.drawSplashScreenCopyrightText(_mapImage, imageGraphics, ",", left);
            ++left;
            left = FontBranding.drawSplashScreenCopyrightText(_mapImage, imageGraphics, year, left);
            left = FontBranding.drawSplashScreenCopyrightText(_mapImage, imageGraphics, ",", left);
            FontBranding.draw(_mapImage, imageGraphics, left, 0, 11, 187, 11, FontAlignment.LEFT);
            _imageSplashScreenCopyright = image;
        }
        graphics.drawImage((Image)_imageSplashScreenCopyright, x, y, null);
    }

    public static void drawSplashScreenVersion(Graphics2D graphics, int x, int y, String version) {
        if (_imageSplashScreenVersion == null) {
            BufferedImage image = new BufferedImage(120, 9, _mapImage.getType());
            Graphics2D imageGraphics = image.createGraphics();
            int left = 120;
            left = FontBranding.drawSplashScreenVersionText(_mapImage, imageGraphics, version, left);
            left = FontBranding.draw(_mapImage, imageGraphics, left, 0, 33, 43, 9, FontAlignment.RIGHT);
            _imageSplashScreenVersion = image;
        }
        graphics.drawImage((Image)_imageSplashScreenVersion, x, y, null);
    }

    public static BufferedImage getAboutBoxCopyrightImage() {
        return _imageSplashScreenCopyright;
    }

    private static int drawSplashScreenCopyrightText(BufferedImage source, Graphics2D destination, String text, int left) {
        for (int index = 0; index < text.length(); ++index) {
            int x = 0;
            int y = 22;
            int width = 0;
            int height = 11;
            char character = text.charAt(index);
            switch (character) {
                case '1': {
                    x = 0;
                    width = 5;
                    break;
                }
                case '2': {
                    x = 7;
                    width = 5;
                    break;
                }
                case '3': {
                    x = 14;
                    width = 5;
                    break;
                }
                case '4': {
                    x = 21;
                    width = 6;
                    break;
                }
                case '5': {
                    x = 29;
                    width = 6;
                    break;
                }
                case '6': {
                    x = 37;
                    width = 5;
                    break;
                }
                case '7': {
                    x = 45;
                    width = 5;
                    break;
                }
                case '8': {
                    x = 52;
                    width = 6;
                    break;
                }
                case '9': {
                    x = 61;
                    width = 5;
                    break;
                }
                case '0': {
                    x = 67;
                    width = 7;
                    break;
                }
                case ',': {
                    x = 76;
                    width = 4;
                }
            }
            if (width <= 0) continue;
            left = FontBranding.draw(source, destination, left, x, y, width, height, FontAlignment.LEFT);
        }
        return left;
    }

    private static int drawSplashScreenVersionText(BufferedImage source, Graphics2D destination, String text, int left) {
        int previousCharacter = 32;
        boolean hasPrevious = false;
        for (int index = text.length(); 0 < index; --index) {
            int x = 0;
            int y = 42;
            int width = 0;
            int height = 12;
            char character = text.charAt(index - 1);
            switch (character) {
                case '0': {
                    x = 74;
                    width = 6;
                    break;
                }
                case '1': {
                    x = 0;
                    width = 5;
                    if (!hasPrevious || previousCharacter != 49) break;
                    left -= 2;
                    break;
                }
                case '2': {
                    x = 8;
                    width = 5;
                    break;
                }
                case '3': {
                    x = 16;
                    width = 6;
                    break;
                }
                case '4': {
                    x = 24;
                    width = 6;
                    break;
                }
                case '5': {
                    x = 33;
                    width = 5;
                    break;
                }
                case '6': {
                    x = 41;
                    width = 6;
                    break;
                }
                case '7': {
                    x = 50;
                    width = 5;
                    break;
                }
                case '8': {
                    x = 58;
                    width = 5;
                    break;
                }
                case '9': {
                    x = 66;
                    width = 5;
                    break;
                }
                case '.': {
                    x = 82;
                    width = 4;
                }
            }
            if (width > 0) {
                left = FontBranding.draw(source, destination, left, x, y, width, height, FontAlignment.RIGHT);
            }
            hasPrevious = true;
            previousCharacter = character;
        }
        return left;
    }

    private static int draw(BufferedImage source, Graphics2D destination, int left, int x, int y, int width, int height, FontAlignment alignment) {
        BufferedImage copyright = FontBranding.copyRect(_mapImage, x, y, width, height);
        int top = 0;
        if (alignment == FontAlignment.LEFT) {
            destination.drawImage((Image)copyright, left, top, null);
            return left + width;
        }
        destination.drawImage((Image)copyright, left - width, top, null);
        return left - width;
    }

    private static BufferedImage copyRect(BufferedImage source, int x, int y, int width, int height) {
        BufferedImage result = new BufferedImage(width, height, source.getType());
        Graphics2D graphics2D = result.createGraphics();
        graphics2D.drawImage((Image)source, -x, -y, null);
        return result;
    }

    private static enum FontAlignment {
        LEFT,
        RIGHT;

    }
}

