/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfinternal.share.util;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.naming.NamingException;
import oracle.adf.share.ADFContext;
import oracle.adf.share.config.ADFConfigFactory;
import oracle.adf.share.security.JAASInitialContextFactory;
import oracle.adf.share.security.SecurityContext;
import oracle.adf.share.security.identitymanagement.UserProfile;

public class AdfShareInternalUtils {
    private static final String SEC_CONTEXT_ID_KEY = "SecurityContextUserID";

    public static String getSecurityContextUserIdentifier(ADFContext adfContext) {
        String identifier = null;
        identifier = AdfShareInternalUtils.getCachedSecurityContextUserId(adfContext);
        if (identifier != null) {
            return identifier;
        }
        if (ADFConfigFactory.internalFindADFConfigId() == null) {
            return null;
        }
        UserProfile userProf = AdfShareInternalUtils.getCurrentUserProfile();
        if (userProf != null) {
            identifier = String.format("%s/%s", userProf.getGUID(), userProf.getUserName());
            AdfShareInternalUtils.cacheSecurityContextUserId(adfContext, identifier);
        }
        return identifier;
    }

    private static String getCachedSecurityContextUserId(ADFContext adfContext) {
        Map reqScope = adfContext.getRequestScope();
        return reqScope != null && reqScope.containsKey(SEC_CONTEXT_ID_KEY) ? (String)reqScope.get(SEC_CONTEXT_ID_KEY) : null;
    }

    private static void cacheSecurityContextUserId(ADFContext adfContext, String identifier) {
        Map reqScope = adfContext.getRequestScope();
        reqScope.put(SEC_CONTEXT_ID_KEY, identifier);
    }

    private static UserProfile getCurrentUserProfile() {
        SecurityContext secCtx = null;
        if (ADFContext.hasCurrent()) {
            secCtx = ADFContext.getCurrent().getSecurityContext();
        } else {
            ConcurrentHashMap<String, String> env = new ConcurrentHashMap<String, String>(1);
            env.put("oracle.adf.security.context", "oracle.adf.share.security.providers.jps.JpsSecurityContext");
            try {
                JAASInitialContextFactory factory = new JAASInitialContextFactory();
                secCtx = (SecurityContext)factory.getInitialContext(env);
            }
            catch (NamingException e) {
                throw new RuntimeException(e);
            }
        }
        return secCtx != null && secCtx.isAuthenticated() ? secCtx.getUserProfile() : null;
    }
}

