/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfinternal.share.jndi;

import java.util.HashMap;
import java.util.Map;
import javax.naming.Reference;

public class ConnectionClientObject {
    private Map<String, Reference> referencesMap = new HashMap<String, Reference>(10);
    private Map<String, Object> connPoolMap = new HashMap<String, Object>();

    public ConnectionClientObject() {
    }

    public ConnectionClientObject(Map<String, Reference> initialReferencesMap) {
        if (initialReferencesMap != null && !initialReferencesMap.isEmpty()) {
            this.referencesMap.putAll(initialReferencesMap);
        }
    }

    public ConnectionClientObject(ConnectionClientObject initialConnectionClientObject) {
        if (initialConnectionClientObject != null) {
            Map<String, Object> connObjPoolMap;
            Map<String, Reference> initialReferencesMap = initialConnectionClientObject.getReferencesMap();
            if (initialReferencesMap != null && !initialReferencesMap.isEmpty()) {
                this.referencesMap.putAll(initialReferencesMap);
            }
            if ((connObjPoolMap = initialConnectionClientObject.connPoolMap) != null && !connObjPoolMap.isEmpty()) {
                this.connPoolMap.putAll(connObjPoolMap);
            }
        }
    }

    public Map<String, Reference> getReferencesMap() {
        return this.referencesMap;
    }

    public Object getConnectionPool(String connType) {
        return this.connPoolMap.get(connType);
    }

    public void setConnectionPool(String connType, Object connPool) {
        this.connPoolMap.put(connType, connPool);
    }
}

