/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfinternal.share.debug;

import java.util.Collections;
import java.util.Map;
import oracle.adf.share.ADFContext;

class AdfShareDebugInfo {
    private ADFContext adfContext;
    private Map applicationScope;
    private Map sessionScope;
    private Map requestScope;
    private Map viewScope;
    private int applicationScopeSize;
    private int sessionScopeSize;
    private int requestScopeSize;
    private int viewScopeSize;

    AdfShareDebugInfo() {
        try {
            ADFContext context;
            this.adfContext = context = ADFContext.findCurrent();
            this.applicationScope = context.getApplicationScope();
            this.applicationScopeSize = context.getApplicationScope().size();
            this.sessionScope = context.getSessionScope();
            this.sessionScopeSize = context.getSessionScope().size();
            this.requestScope = context.getRequestScope();
            this.requestScopeSize = context.getRequestScope().size();
            this.viewScope = context.getViewScope();
            this.viewScopeSize = context.getViewScope().size();
        }
        catch (Exception e) {
            this.adfContext = null;
            this.applicationScope = Collections.emptyMap();
            this.applicationScopeSize = 0;
            this.sessionScope = Collections.emptyMap();
            this.sessionScopeSize = 0;
            this.requestScope = Collections.emptyMap();
            this.requestScopeSize = 0;
            this.viewScope = Collections.emptyMap();
            this.viewScopeSize = 0;
        }
    }
}

