/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.util;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import oracle.adf.share.ADFContext;
import oracle.adf.share.common.ClassUtils;
import oracle.adf.share.logging.ADFLogger;
import oracle.adf.share.platform.AdfServerPlatformUtil;

public class DiagnosticsUtilityForABCS {
    public static final String CUSTOM_APPLICATION_NAME = "CUSTOM_APPLICATION_NAME";
    public static final String CUSTOM_APPLICATION_MODE = "CUSTOM_APPLICATION_MODE";
    public static final String ABCS_REQUEST_SCOPE_APP_DETAILS = "_ABCS_CUSTOM_APP_DETAILS_";
    private static final ADFLogger logger = ADFLogger.createADFLogger((String)DiagnosticsUtilityForABCS.class.getName());

    public static String getApplicationName() {
        return DiagnosticsUtilityForABCS.getABCSAppNameAndVersionFromRequestScope("appNameAndVersion");
    }

    public static String getApplicationMode() {
        return DiagnosticsUtilityForABCS.getABCSAppNameAndVersionFromRequestScope("applicationMode");
    }

    public static String getApplicationUser() {
        return ADFContext.getCurrent().getSecurityContext().getUserName();
    }

    private static String getABCSAppNameAndVersionFromRequestScope(String resourceKey) {
        Map<Object, Object> applicationAndVersion = (HashMap)ADFContext.getCurrent().getRequestScope().get(ABCS_REQUEST_SCOPE_APP_DETAILS);
        if (applicationAndVersion == null) {
            applicationAndVersion = DiagnosticsUtilityForABCS.getApplicationAndVersionName();
        }
        if (applicationAndVersion != null) {
            return (String)applicationAndVersion.get(resourceKey);
        }
        return "";
    }

    private static Map<String, String> getApplicationAndVersionName() {
        try {
            Class abcsContextClass = ClassUtils.forName((String)"com.oracle.breeze.ramp.util.ABCSRequestContext", DiagnosticsUtilityForABCS.class);
            Method method = abcsContextClass.getMethod("getDataContext", new Class[0]);
            Object dataResourceContext = method.invoke((Object)abcsContextClass, new Object[0]);
            Class dataResourceContextClass = ClassUtils.forName((String)"com.oracle.breeze.service.DataResourceContext", DiagnosticsUtilityForABCS.class);
            Method dataResourceContextClassMethod = dataResourceContextClass.getMethod("getAppNameAndVersion", new Class[0]);
            Object appNameAndVersionObject = dataResourceContextClassMethod.invoke(dataResourceContext, new Object[0]);
            Class appNameAndVersionClass = ClassUtils.forName((String)"com.oracle.breeze.rt.AppNameAndVersion", DiagnosticsUtilityForABCS.class);
            Method appNameMethod = appNameAndVersionClass.getMethod("getName", new Class[0]);
            Object appName = appNameMethod.invoke(appNameAndVersionObject, new Object[0]);
            Method versionMethod = appNameAndVersionClass.getMethod("getVersion", new Class[0]);
            Object version = versionMethod.invoke(appNameAndVersionObject, new Object[0]);
            Method branchResourceRootMethod = dataResourceContextClass.getMethod("getBranchResourceRoot", new Class[0]);
            Object rootMethod = branchResourceRootMethod.invoke(dataResourceContext, new Object[0]);
            HashMap<String, String> reqScopeABCSAppDet = new HashMap<String, String>();
            String appNameAndVersion = (String)appName + "#" + (String)version;
            reqScopeABCSAppDet.put("appNameAndVersion", appNameAndVersion);
            reqScopeABCSAppDet.put("applicationMode", (String)rootMethod);
            ADFContext.getCurrent().getRequestScope().put(ABCS_REQUEST_SCOPE_APP_DETAILS, reqScopeABCSAppDet);
            return reqScopeABCSAppDet;
        }
        catch (Exception ex) {
            logger.finest("Unable to find the class at runtime");
            return null;
        }
    }

    public static boolean isDMSAndODLAvailable() {
        return AdfServerPlatformUtil.isDMSAvailable() && AdfServerPlatformUtil.isODLAvailable();
    }

    public static boolean isABCSEnv() {
        boolean isABCSEnv = false;
        try {
            Class abcsClass = ClassUtils.forName((String)"com.oracle.breeze.ramp.util.ABCSRequestContext", DiagnosticsUtilityForABCS.class);
            if (abcsClass != null) {
                isABCSEnv = true;
            }
        }
        catch (Exception ex) {
            isABCSEnv = false;
        }
        return isABCSEnv;
    }
}

