/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.statemanager;

import java.util.Collection;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import javax.naming.Context;
import javax.naming.NamingException;
import oracle.adf.share.ADFContext;
import oracle.adf.share.ADFScope;
import oracle.adf.share.ADFScopeListener;
import oracle.adf.share.logging.ADFLogger;
import oracle.adf.share.statemanager.DefaultInitialContextFactory;
import oracle.adf.share.statemanager.Policy;
import oracle.adf.share.statemanager.StateManager;
import oracle.adf.share.statemanager.UUID;

public class StateManagerScopeAdapter
implements Map {
    public static final String STATE_MANAGER_SCOPE_ID_KEY = "adf.statemanager.uuid_key";
    public static final String ENV_STATE_MANAGER_POLICY_KEY = "adf.statemanager.policy_key";
    private final StateManager mStateManager;
    private final String mScopeName;
    private final Object mScopeUUID;
    private final Policy mPolicy;
    private static final ADFLogger mlogger = ADFLogger.createADFLogger(StateManagerScopeAdapter.class);

    public StateManagerScopeAdapter(String scopeName, Hashtable env) {
        this.mScopeName = scopeName;
        if (env == null) {
            env = new Hashtable<String, String>(4);
        }
        if (env.get("java.naming.factory.initial") == null) {
            env.put("java.naming.factory.initial", DefaultInitialContextFactory.class.getName());
        }
        try {
            DefaultInitialContextFactory defaultCtxFactory = new DefaultInitialContextFactory();
            Context defaultCtx = defaultCtxFactory.getInitialContext(env);
            this.mStateManager = (StateManager)defaultCtx.lookup("__state_manager__");
        }
        catch (NamingException n) {
            throw new RuntimeException(n);
        }
        Map<String, Object> scope = ADFContext.getCurrent().getScope(this.mScopeName);
        if (scope != null) {
            Object scopeUUID = scope.get(STATE_MANAGER_SCOPE_ID_KEY);
            if (scopeUUID == null) {
                scopeUUID = this.generateStateManagerId(scope);
                scope.put(STATE_MANAGER_SCOPE_ID_KEY, scopeUUID);
                if (scope instanceof ADFScope) {
                    ((ADFScope)scope).addScopeListener(new ADFScopeListenerImpl());
                }
            }
            this.mScopeUUID = scopeUUID;
        } else {
            this.mScopeUUID = null;
            mlogger.info("StateManagerScopeAdapter scope is null:" + this.mScopeName);
        }
        this.mPolicy = (Policy)env.get(ENV_STATE_MANAGER_POLICY_KEY);
    }

    protected Object generateStateManagerId(Map scope) {
        return UUID.generateUUID();
    }

    @Override
    public int size() {
        this.methodNotSupported();
        return 0;
    }

    @Override
    public void clear() {
        this.mStateManager.clearStates(this.mScopeUUID);
    }

    @Override
    public boolean isEmpty() {
        this.methodNotSupported();
        return false;
    }

    @Override
    public boolean containsKey(Object p0) {
        this.methodNotSupported();
        return false;
    }

    @Override
    public boolean containsValue(Object p0) {
        this.methodNotSupported();
        return false;
    }

    public Collection values() {
        this.methodNotSupported();
        return null;
    }

    public void putAll(Map p0) {
        this.methodNotSupported();
    }

    public Set entrySet() {
        this.methodNotSupported();
        return null;
    }

    public Set keySet() {
        this.methodNotSupported();
        return null;
    }

    public Object get(Object key) {
        if (this.mPolicy != null) {
            return this.mStateManager.getState(this.mScopeUUID, key, this.mPolicy);
        }
        return this.mStateManager.getState(this.mScopeUUID, key);
    }

    public Object remove(Object key) {
        if (this.mPolicy != null) {
            return this.mStateManager.removeState(this.mScopeUUID, key, this.mPolicy);
        }
        return this.mStateManager.removeState(this.mScopeUUID, key);
    }

    public Object put(Object key, Object state) {
        if (this.mPolicy != null) {
            return this.mStateManager.putState(this.mScopeUUID, key, state, this.mPolicy);
        }
        return this.mStateManager.putState(this.mScopeUUID, key, state);
    }

    protected String getScopeName() {
        return this.mScopeName;
    }

    private void methodNotSupported() {
        throw new UnsupportedOperationException();
    }

    public String getType() {
        return this.mStateManager.getClass().getName();
    }

    class ADFScopeListenerImpl
    implements ADFScopeListener {
        ADFScopeListenerImpl() {
        }

        @Override
        public void scopeInvalidated(String scopeName) {
            Map stateManager = ADFContext.getCurrent().getStateManager(scopeName, null);
            stateManager.clear();
        }
    }
}

