/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.security.identitymanagement;

import java.lang.reflect.Constructor;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import oracle.adf.share.common.ClassUtils;
import oracle.adf.share.security.ADFSecurityRuntimeException;
import oracle.adf.share.security.ADFSecurityUtil;
import oracle.adf.share.security.credentialstore.Credential;
import oracle.adf.share.security.identitymanagement.AttributeFilter;
import oracle.adf.share.security.identitymanagement.User;
import oracle.adf.share.security.identitymanagement.UserProfileType;
import oracle.adf.share.security.identitymanagement.spi.IdentityManagement;
import oracle.adf.share.security.identitymanagement.spi.IdentityManagement2;

public class UserManager {
    private IdentityManagement identityManagementProvider = null;

    private static Object createObject(String className) {
        Object object = null;
        try {
            Class classDefinition = ClassUtils.forName((String)className, UserManager.class);
            object = classDefinition.newInstance();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return object;
    }

    private void setIdentityManagementProvider(IdentityManagement provider) {
        this.identityManagementProvider = provider;
    }

    private void checkProviderConfiguration() throws SecurityException {
        if (this.identityManagementProvider == null) {
            throw new UnsupportedOperationException("Provider not installed.");
        }
    }

    public UserManager() {
        this((String)null);
    }

    public UserManager(String providerClassName) {
        if (providerClassName != null) {
            IdentityManagement provider = (IdentityManagement)UserManager.createObject(providerClassName);
            this.setIdentityManagementProvider(provider);
        } else {
            String clzName = ADFSecurityUtil.getIdentityManagementProviderClassName();
            if (clzName != null) {
                IdentityManagement provider = (IdentityManagement)UserManager.createObject(clzName);
                this.setIdentityManagementProvider(provider);
            } else {
                throw new ADFSecurityRuntimeException(ADFSecurityUtil.getMessage("EXC_FAILED_ID_STORE"));
            }
        }
    }

    public UserManager(Hashtable env) {
        IdentityManagement provider = null;
        if (env != null) {
            String providerClassName;
            String namedContext = (String)env.get("named.adf.context");
            if (namedContext == null) {
                namedContext = "default";
            }
            if ((providerClassName = (String)env.get("oracle.adf.security.identity.provider")) == null) {
                providerClassName = "oracle.adf.share.security.providers.jps.IgfIdentityManagementProvider";
            }
            try {
                Class cls = ClassUtils.forName((String)providerClassName, UserManager.class);
                Constructor ctor = cls.getConstructor(String.class);
                provider = (IdentityManagement)ctor.newInstance(namedContext);
            }
            catch (Exception ex) {
                throw new ADFSecurityRuntimeException(ADFSecurityUtil.getMessage("EXC_FAILED_ID_STORE"));
            }
        } else {
            provider = (IdentityManagement)UserManager.createObject("oracle.adf.share.security.providers.jps.IgfIdentityManagementProvider");
        }
        this.setIdentityManagementProvider(provider);
    }

    public Principal addUser(User user, Credential cred) {
        if (!this.identityManagementProvider.isAddUserSupported()) {
            throw new ADFSecurityRuntimeException(ADFSecurityUtil.getMessage("EXC_UNSUPPORTED_ID_STORE_OPERATION"));
        }
        return this.identityManagementProvider.addUser(user, cred);
    }

    public User createUser() {
        return this.identityManagementProvider.createUser();
    }

    public Principal getPrincipal(String username) {
        return username == null || username.length() == 0 ? null : this.identityManagementProvider.getUserPrincipal(username);
    }

    public User getUser(Principal principal) {
        return principal == null ? null : this.identityManagementProvider.getUser(principal);
    }

    public void modifyUser(Principal principal, User user) {
        throw new ADFSecurityRuntimeException(ADFSecurityUtil.getMessage("EXC_UNSUPPORTED_ID_STORE_OPERATION"));
    }

    public void deleteUser(Principal principal) {
        if (!this.identityManagementProvider.isDeleteUserSupported()) {
            throw new ADFSecurityRuntimeException(ADFSecurityUtil.getMessage("EXC_UNSUPPORTED_ID_STORE_OPERATION"));
        }
        if (principal != null) {
            this.identityManagementProvider.deleteUser(principal);
        }
    }

    public boolean isAddUserSupported() {
        return this.identityManagementProvider.isAddUserSupported();
    }

    public boolean isModifyUserSupported() {
        return this.identityManagementProvider.isModifyUserSupported();
    }

    public boolean isDeleteUserSupported() {
        return this.identityManagementProvider.isDeleteUserSupported();
    }

    public ArrayList getUserList(int sizeLimit, AttributeFilter[] filter) {
        return this.identityManagementProvider.getUserList(sizeLimit, filter);
    }

    public ArrayList getUserList(int sizeLimit, AttributeFilter[] filter, Principal role) {
        return this.identityManagementProvider.getUserList(sizeLimit, filter, role);
    }

    public ArrayList getUserProfileList(int sizeLimit, AttributeFilter[] filter) {
        return this.identityManagementProvider.getUserProfileList(sizeLimit, filter);
    }

    public Object getUserProfilePropertyVal(String name, String propName) {
        return this.identityManagementProvider.getUserProfilePropertyVal(name, propName);
    }

    public void saveUserProfile(String userName, HashMap values) {
        this.identityManagementProvider.saveUserProfile(userName, values);
    }

    public String getAnonymousUserName() {
        return this.identityManagementProvider.getAnonymousUserName();
    }

    public Principal getAnonymousUser() {
        return this.identityManagementProvider.getAnonymousUser();
    }

    Object getUserProfilePropertyVal(String name, UserProfileType type) {
        if (IdentityManagement2.class.isAssignableFrom(this.identityManagementProvider.getClass())) {
            return ((IdentityManagement2)this.identityManagementProvider).getUserProfilePropertyVal(name, type);
        }
        return this.identityManagementProvider.getUserProfilePropertyVal(name, type.getAttributeName());
    }
}

