/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.sandbox;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.adf.share.sandbox.MetadataRepositoryBaseline;
import oracle.adf.share.sandbox.MetadataRevisionNoteURI;
import oracle.adf.share.sandbox.MetadataRevisionPortable;
import oracle.adf.share.sandbox.MetadataRevisionSupport;

public class MetadataRevision {
    private final String revisionId;
    private final String hostId;
    private final String fromHostId;
    private Map<String, Object> payload;

    MetadataRevision(String revisionId, String hostId, String fromHostId) {
        if (revisionId == null) {
            throw new IllegalArgumentException("Invalid revision ID: null.");
        }
        if (hostId == null) {
            throw new IllegalArgumentException("invalid host ID: null.");
        }
        this.revisionId = revisionId;
        this.hostId = hostId;
        this.fromHostId = fromHostId;
    }

    public final String getId() {
        return this.revisionId;
    }

    public final String getHostId() {
        return this.hostId;
    }

    public final String getFromHostId() {
        return this.fromHostId;
    }

    Map<String, Object> getPayload() {
        if (this.payload == null) {
            this.payload = new HashMap<String, Object>(2);
        }
        return this.payload;
    }

    public Map<String, MetadataRepositoryBaseline> getRepositoryBaselines() {
        return MetadataRevisionSupport.getInstance().getRepositoryBaselines(this);
    }

    public Date getRecordDate() {
        return MetadataRevisionSupport.getInstance().getRecordDate(this);
    }

    public String getRecordedBy() {
        return MetadataRevisionSupport.getInstance().getRecordedBy(this);
    }

    public String getNote() {
        return MetadataRevisionSupport.getInstance().getNote(this);
    }

    public MetadataRevisionNoteURI getNoteURI() {
        return MetadataRevisionNoteURI.parse(this.getNote());
    }

    public MetadataRevisionPortable export() {
        return new MetadataRevisionPortable(this);
    }

    public static String getLocalHostId() {
        String r = MetadataRevisionSupport.getInstance().getLocalHostId();
        if (r == null) {
            throw new IllegalStateException("Unable to retrieve ID of the local host: null.");
        }
        return r;
    }

    public static MetadataRevision get(String revisionId) {
        if (revisionId == null) {
            throw new IllegalArgumentException("Invalid revision ID: null.");
        }
        return MetadataRevisionSupport.getInstance().get(revisionId);
    }

    public static List<MetadataRevision> listAfter(MetadataRevision revision) {
        if (revision == null) {
            throw new IllegalArgumentException("Invalid revision: null.");
        }
        return MetadataRevisionSupport.getInstance().listAfter(revision);
    }

    public static MetadataRevision getLatest(String fromHostId) {
        if (fromHostId == null) {
            throw new IllegalArgumentException("Invalid host ID: null.");
        }
        return MetadataRevisionSupport.getInstance().getLatest(fromHostId);
    }

    public static MetadataRevision getLatest() {
        return MetadataRevisionSupport.getInstance().getLatest();
    }

    public static MetadataRevision create(String noteURI) {
        return MetadataRevisionSupport.getInstance().create(noteURI);
    }

    public static MetadataRevision create(MetadataRevisionNoteURI noteURI) {
        return MetadataRevision.create(noteURI == null ? null : noteURI.toString());
    }
}

