/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.jndi;

import java.util.Hashtable;
import java.util.Map;
import javax.naming.Context;
import javax.naming.NamingException;
import oracle.adf.share.config.ADFConfigCallback;
import oracle.adf.share.config.ADFConfigParsingContext;
import oracle.adf.share.jndi.AdfInitialContext;
import oracle.adf.share.logging.ADFLogger;
import oracle.adf.share.platform.AdfServerPlatformUtil;
import oracle.adfinternal.share.props.ProviderCallHelper;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class AdfJndiConfig
implements ADFConfigCallback {
    public static final String namespaceURI = "http://xmlns.oracle.com/adf/jndi/config";
    private static final String INITIAL_CONTEXT_IMPL = "oracle.adf.share.jndi.InitialContextFactoryImpl";
    private static final String MDS_BACKING_STORE = "oracle.adf.share.jndi.MDSBackingStore";
    private static final String RESOURCE_BACKING_STORE = "oracle.adf.share.jndi.ResourceBackingStore";
    private static final ADFLogger _LOG = ADFLogger.createADFLogger(AdfJndiConfig.class);

    public static Context getDefaultConnectionsContext() throws NamingException {
        Hashtable<String, String> env = new Hashtable<String, String>(3);
        env.put("java.naming.factory.initial", INITIAL_CONTEXT_IMPL);
        env.put("java.naming.provider.url", "META-INF/connections.xml");
        if (ProviderCallHelper.isProviderCall() || !AdfServerPlatformUtil.isMDSAvailable()) {
            env.put("oracle.adf.share.jndi.documentstore", RESOURCE_BACKING_STORE);
        } else {
            env.put("oracle.adf.share.jndi.documentstore", MDS_BACKING_STORE);
        }
        env.put("_cache_application_scope_", "true");
        if (_LOG.isFine()) {
            _LOG.fine("Creating AdfInitialContext with environment" + env);
        }
        return AdfInitialContext.newAdfInitialContext(env, AdfJndiConfig.class);
    }

    @Override
    public Map parseADFConfiguration(Element el, Map storedResult, ADFConfigParsingContext currentCtx) {
        NodeList nl1;
        String backingStoreURL;
        String backingStoreClass;
        if (storedResult != null) {
            return storedResult;
        }
        NodeList nl = el.getElementsByTagNameNS(namespaceURI, "ConnectionsJndiContext");
        if (nl.getLength() <= 0) {
            _LOG.warning("Jndi Context information not correct" + el);
            return null;
        }
        Hashtable<String, String> mContextEnv = new Hashtable<String, String>(7);
        Element elem = (Element)nl.item(0);
        String facClass = elem.getAttribute("initialContextFactoryClass");
        if (facClass == null || facClass.length() == 0) {
            facClass = INITIAL_CONTEXT_IMPL;
        }
        if ((backingStoreClass = elem.getAttribute("backingStoreClass")) == null || backingStoreClass.length() == 0) {
            backingStoreClass = MDS_BACKING_STORE;
        }
        if ((backingStoreURL = elem.getAttribute("backingStoreURL")) == null || backingStoreURL.length() == 0) {
            backingStoreURL = "META-INF/connections.xml";
        }
        if ((nl1 = elem.getElementsByTagNameNS(namespaceURI, "contextEnv")).getLength() > 0) {
            for (int j = 0; j < nl1.getLength(); ++j) {
                Element elem1 = (Element)nl1.item(j);
                mContextEnv.put(elem1.getAttribute("name"), elem1.getAttribute("value"));
            }
        }
        mContextEnv.put("java.naming.factory.initial", facClass);
        mContextEnv.put("oracle.adf.share.jndi.documentstore", backingStoreClass);
        mContextEnv.put("java.naming.provider.url", backingStoreURL);
        _LOG.finest("AdfJndiConfig Created the Jndi Config information ");
        return mContextEnv;
    }
}

