/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.el;

import java.beans.FeatureDescriptor;
import java.util.Iterator;
import java.util.Locale;
import javax.el.ELContext;
import javax.el.ELResolver;
import javax.el.FunctionMapper;
import javax.el.VariableMapper;
import javax.servlet.jsp.el.ELException;
import javax.servlet.jsp.el.VariableResolver;
import oracle.adf.share.logging.ADFLogger;

class VariableResolverELContext
extends ELContext {
    private final ELContext mELContext;
    private final VariableResolver mVariableResolver;
    private static final ADFLogger mLogger = ADFLogger.createADFLogger(VariableResolverELContext.class);

    VariableResolverELContext(ELContext elContext, VariableResolver variableResolver) {
        this.mELContext = elContext;
        this.mVariableResolver = variableResolver;
    }

    public Object getContext(Class clz) {
        return this.mELContext.getContext(clz);
    }

    public ELResolver getELResolver() {
        return new ELResolver(){

            public Class getType(ELContext context, Object base, Object property) {
                return VariableResolverELContext.this.mELContext.getELResolver().getType(context, base, property);
            }

            public Object getValue(ELContext context, Object base, Object property) {
                Object rtn = VariableResolverELContext.this.mELContext.getELResolver().getValue(context, base, property);
                if (rtn == null && base == null) {
                    try {
                        rtn = VariableResolverELContext.this.mVariableResolver.resolveVariable(property.toString());
                        if (rtn != null) {
                            context.setPropertyResolved(true);
                            if (mLogger.isSevere()) {
                                mLogger.severe("The variable resolver, {0}, was used to evaluate expression, {1}.  All variable resolvers have been deprecated.  Please consult the documentation for the variable resolver and modify the expression to not depend upon the variable resolver.", new Object[]{VariableResolverELContext.this.mVariableResolver.getClass().getName(), property.toString()});
                            }
                        }
                    }
                    catch (ELException e) {
                        throw new RuntimeException(e);
                    }
                }
                return rtn;
            }

            public boolean isReadOnly(ELContext context, Object base, Object property) {
                return VariableResolverELContext.this.mELContext.getELResolver().isReadOnly(context, base, property);
            }

            public void setValue(ELContext context, Object base, Object property, Object value) {
                VariableResolverELContext.this.mELContext.getELResolver().setValue(context, base, property, value);
            }

            public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext elContext, Object object) {
                return VariableResolverELContext.this.mELContext.getELResolver().getFeatureDescriptors(elContext, object);
            }

            public Class<?> getCommonPropertyType(ELContext elContext, Object object) {
                return VariableResolverELContext.this.mELContext.getELResolver().getCommonPropertyType(elContext, object);
            }
        };
    }

    public FunctionMapper getFunctionMapper() {
        return this.mELContext.getFunctionMapper();
    }

    public Locale getLocale() {
        return this.mELContext.getLocale();
    }

    public VariableMapper getVariableMapper() {
        return this.mELContext.getVariableMapper();
    }

    public boolean isPropertyResolved() {
        return this.mELContext.isPropertyResolved();
    }

    public void putContext(Class clz, Object context) {
        this.mELContext.putContext(clz, context);
    }

    public void setLocale(Locale locale) {
        this.mELContext.setLocale(locale);
    }

    public void setPropertyResolved(boolean resolved) {
        this.mELContext.setPropertyResolved(resolved);
    }
}

