/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.el;

import javax.servlet.jsp.el.ELException;
import javax.servlet.jsp.el.VariableResolver;
import oracle.adf.share.ADFContext;

public class ADFContextVariableResolverImpl
implements VariableResolver {
    private boolean mIsResolveImplicit = true;

    public ADFContextVariableResolverImpl() {
    }

    public ADFContextVariableResolverImpl(boolean resolveImplicit) {
        this.mIsResolveImplicit = resolveImplicit;
    }

    public void setResolveImplicit(boolean resolveImplicit) {
        this.mIsResolveImplicit = resolveImplicit;
    }

    public Object resolveVariable(String name) throws ELException {
        return this.resolveVariable(null, name);
    }

    public Object resolveVariable(Object ctx, String name) {
        ADFContext adfContext = ADFContext.getCurrent();
        if ("securityContext".equals(name)) {
            return adfContext.getSecurityContext();
        }
        if ("adfDomainConfig".equals(name)) {
            ADFContext.getCurrent().setupADFDomainConfig(null);
            return adfContext.getApplicationScope().get("adfDomainConfig");
        }
        if (this.mIsResolveImplicit) {
            if ("requestScope".equals(name)) {
                return adfContext.getRequestScope();
            }
            if ("sessionScope".equals(name)) {
                return adfContext.getSessionScope();
            }
            if ("applicationScope".equals(name)) {
                return adfContext.getApplicationScope();
            }
            if (adfContext.getRequestScope().containsKey(name)) {
                return adfContext.getRequestScope().get(name);
            }
            if (adfContext.getSessionScope().containsKey(name)) {
                return adfContext.getSessionScope().get(name);
            }
            return adfContext.getApplicationScope().get(name);
        }
        return null;
    }
}

