/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share;

import java.util.Map;
import oracle.adf.share.ADFContext;
import oracle.adf.share.MetadataEnvironment;
import oracle.adf.share.codesharing.audit.annotation.CodeSharingSafe;
import oracle.adf.share.common.ClassUtils;

public abstract class MetadataEnvironmentFactory {
    private static final String DEFAULT_FACTORY_CLASS = "oracle.adfinternal.share.sandbox.DefaultMetadataEnvironmentFactory";
    @CodeSharingSafe(value="MutableStaticField")
    private static MetadataEnvironmentFactory defaultFactory;

    protected MetadataEnvironmentFactory() {
    }

    public abstract MetadataEnvironment newInstance(Map<String, Object> var1);

    public abstract boolean isCustomMetadataEnvironment(MetadataEnvironment var1);

    protected boolean supportsUnifiedEnvironments() {
        return true;
    }

    public static boolean isUnified() {
        return MetadataEnvironmentFactory.getDefaultFactory().supportsUnifiedEnvironments();
    }

    protected void configureCurrentADFSessionOptions(MetadataEnvironment env) {
        throw new UnsupportedOperationException();
    }

    public static void configureCurrentADFSessionOptions() {
        MetadataEnvironment env = ADFContext.getCurrent().getMetadataEnvironment();
        MetadataEnvironmentFactory.getDefaultFactory().configureCurrentADFSessionOptions(env);
    }

    static MetadataEnvironmentFactory getDefaultFactory() {
        if (defaultFactory == null) {
            defaultFactory = MetadataEnvironmentFactory.newFactory(DEFAULT_FACTORY_CLASS);
        }
        return defaultFactory;
    }

    private static MetadataEnvironmentFactory newFactory(String className) {
        try {
            Class factoryClass = ClassUtils.forName((String)className, ADFContext.class);
            if (!MetadataEnvironmentFactory.class.isAssignableFrom(factoryClass)) {
                throw new UnsupportedOperationException(className + " is not a subclass of " + MetadataEnvironmentFactory.class.getName());
            }
            return (MetadataEnvironmentFactory)factoryClass.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new UnsupportedOperationException(e);
        }
        catch (IllegalAccessException e) {
            throw new UnsupportedOperationException(e);
        }
        catch (InstantiationException e) {
            throw new UnsupportedOperationException(e);
        }
    }
}

