/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share;

import java.text.MessageFormat;
import java.util.List;
import java.util.ResourceBundle;
import oracle.adf.share.ResourceKey;
import oracle.adf.share.config.resources.Messages;

public class ADFShareException
extends RuntimeException {
    private static final long serialVersionUID = -8736629172160108623L;
    private static final ResourceBundle sBundle = ResourceBundle.getBundle(Messages.class.getName());
    private String mMessage;
    private static final String MSGID = ".MSGID";
    private ResourceKey rKey = ResourceKey.DEFAULT;
    private List<Throwable> mCauseList;

    @Deprecated
    public ADFShareException(String message) {
        super(message);
    }

    @Deprecated
    public ADFShareException(String message, Throwable cause) {
        super(message, cause);
    }

    public ADFShareException(Throwable cause) {
        super(cause);
    }

    public ADFShareException() {
        this(ResourceKey.DEFAULT);
    }

    public ADFShareException(ResourceKey key) {
        this(key, null);
    }

    public ADFShareException(ResourceKey key, Throwable cause) {
        this(key, cause, new Object[0]);
    }

    public ADFShareException(ResourceKey key, Throwable cause, Object ... args) {
        super(cause);
        this.rKey = key;
        this.mMessage = this.createLocalizedMessage(args);
    }

    public ResourceKey getResourceKey() {
        return this.rKey;
    }

    public ResourceBundle getResourceBundle() {
        return sBundle;
    }

    protected String createLocalizedMessage(Object[] args) {
        String resourceKey = this.rKey.toString();
        String msg = sBundle.getString(resourceKey);
        String err = this.getErrorId();
        if (args != null) {
            MessageFormat format = new MessageFormat(msg);
            msg = format.format(args);
        }
        msg = err + ": " + msg;
        return msg;
    }

    @Override
    public String getMessage() {
        return this.getMMessage();
    }

    public String getMMessage() {
        if (this.mMessage != null) {
            return this.mMessage;
        }
        return super.getMessage();
    }

    public String getCauseMessage(Object[] args) {
        String resourceKey = this.rKey.toString();
        String msg = sBundle.getString(resourceKey + ".CAUSE");
        if (msg != null && args != null) {
            MessageFormat format = new MessageFormat(msg);
            msg = format.format(args);
        }
        return msg;
    }

    @Override
    public Throwable getCause() {
        return super.getCause();
    }

    public List<Throwable> getCauseList() {
        return this.mCauseList;
    }

    public void setCauseList(List<Throwable> l) {
        this.mCauseList = l;
    }

    public String getErrorId() {
        String resourceKey = this.rKey.toString();
        String errorKey = resourceKey + MSGID;
        String err = sBundle.getString(errorKey);
        return err;
    }
}

