/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import oracle.adf.share.ADFScopeListener;
import oracle.adf.share.ADFScopeListenerWithExternalContext;

public class ADFScopeHelper
implements Serializable {
    private static final String ADF_SCOPE_HELPER = ADFScopeHelper.class.getName();
    private static ThreadLocal<AtomicBoolean> releasingTL = new ThreadLocal<AtomicBoolean>(){

        @Override
        protected AtomicBoolean initialValue() {
            return new AtomicBoolean(false);
        }
    };
    private transient ArrayList<ADFScopeListener> mScopeListeners = new ArrayList(4);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addScopeListener(ADFScopeListener listener) {
        ADFScopeHelper aDFScopeHelper = this;
        synchronized (aDFScopeHelper) {
            if (!this.mScopeListeners.contains(listener)) {
                this.mScopeListeners.add(listener);
            }
        }
    }

    public static void addScopeListener(ADFScopeListener listener, Map scope) {
        ADFScopeHelper.getScopeHelper(scope, true, false).addScopeListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeScopeListener(ADFScopeListener listener) {
        ADFScopeHelper aDFScopeHelper = this;
        synchronized (aDFScopeHelper) {
            this.mScopeListeners.remove(listener);
        }
    }

    public static void removeScopeListener(ADFScopeListener listener, Map scope) {
        ADFScopeHelper helper = ADFScopeHelper.getScopeHelper(scope, false, false);
        if (helper != null) {
            helper.removeScopeListener(listener);
        }
    }

    public void fireScopeInvalidated(String scopeName) {
        this.fireScopeInvalidatedWithContext(scopeName, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireScopeInvalidatedWithContext(String scopeName, Object externalContext) {
        ArrayList scopeListeners = null;
        ADFScopeHelper aDFScopeHelper = this;
        synchronized (aDFScopeHelper) {
            scopeListeners = (ArrayList)this.mScopeListeners.clone();
        }
        for (int i = scopeListeners.size() - 1; i >= 0; --i) {
            ADFScopeListener listener = (ADFScopeListener)scopeListeners.get(i);
            if (externalContext != null && listener instanceof ADFScopeListenerWithExternalContext) {
                ((ADFScopeListenerWithExternalContext)listener).scopeInvalidated(scopeName, externalContext);
                continue;
            }
            listener.scopeInvalidated(scopeName);
        }
    }

    public static boolean isReleasing() {
        return releasingTL.get().get();
    }

    public static void setReleasing(boolean b) {
        releasingTL.get().set(b);
    }

    public static void fireScopeInvalidated(String scopeName, Map scope) {
        ADFScopeHelper helper = ADFScopeHelper.getScopeHelper(scope, false, true);
        if (helper != null) {
            helper.fireScopeInvalidated(scopeName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ADFScopeHelper getScopeHelper(Map scopeMap, boolean create, boolean remove) {
        Map map = scopeMap;
        synchronized (map) {
            ADFScopeHelper helper = null;
            helper = remove ? (ADFScopeHelper)scopeMap.remove(ADF_SCOPE_HELPER) : (ADFScopeHelper)scopeMap.get(ADF_SCOPE_HELPER);
            if (create && helper == null) {
                helper = new ADFScopeHelper();
                scopeMap.put(ADF_SCOPE_HELPER, helper);
            }
            return helper;
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.mScopeListeners = new ArrayList(4);
    }
}

