/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share;

import java.beans.Beans;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.Connection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import javax.el.ELContext;
import javax.el.ExpressionFactory;
import javax.naming.Context;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NamingException;
import javax.servlet.jsp.el.VariableResolver;
import oracle.adf.share.ADFConfig;
import oracle.adf.share.ADFConfigEx;
import oracle.adf.share.ADFScope;
import oracle.adf.share.ADFScopeHelper;
import oracle.adf.share.ADFScopeListener;
import oracle.adf.share.ADFSettings;
import oracle.adf.share.ContextInfo;
import oracle.adf.share.DefaultContext;
import oracle.adf.share.DefaultNamedContext;
import oracle.adf.share.DesignTimeLinkage;
import oracle.adf.share.Environment;
import oracle.adf.share.HashMapScopeAdapter;
import oracle.adf.share.MDSAppContext;
import oracle.adf.share.MetadataEnvironment;
import oracle.adf.share.MetadataEnvironmentFactory;
import oracle.adf.share.codesharing.audit.annotation.CodeSharingSafe;
import oracle.adf.share.common.ClassUtils;
import oracle.adf.share.common.rc.util.LoaderUtil;
import oracle.adf.share.common.security.StringPropertyPrivAction;
import oracle.adf.share.common.util.AdfPlatformFactoryResolver;
import oracle.adf.share.config.ADFConfigFactory;
import oracle.adf.share.config.ADFContextMDSConfigHelper;
import oracle.adf.share.config.ConfigContainerFactory;
import oracle.adf.share.config.resources.Messages;
import oracle.adf.share.el.ADFContextVariableResolverImpl;
import oracle.adf.share.el.ADFELContext;
import oracle.adf.share.el.ADFExpressionEvaluator;
import oracle.adf.share.el.OracleExpressionEvaluatorImpl;
import oracle.adf.share.exception.PageFlowScopeException;
import oracle.adf.share.exception.ViewScopeException;
import oracle.adf.share.jndi.AdfInitialContext;
import oracle.adf.share.jndi.InitialContextFactoryImpl;
import oracle.adf.share.logging.ADFLogger;
import oracle.adf.share.mt.util.MultiTenantStorage;
import oracle.adf.share.platform.AdfServerPlatformSupport;
import oracle.adf.share.platform.AdfServerPlatformSupportFactory;
import oracle.adf.share.platform.AdfServerPlatformUtil;
import oracle.adf.share.platform.mt.MTHelper;
import oracle.adf.share.security.ADFSecurityUtil;
import oracle.adf.share.security.AllowUntrustedScriptAccess;
import oracle.adf.share.security.JAASInitialContextFactory;
import oracle.adf.share.security.SecurityContext;
import oracle.adf.share.security.TenantInfo;
import oracle.adf.share.security.TenantService;
import oracle.adf.share.statemanager.StateManagerScopeAdapter;
import oracle.adfinternal.share.ADFContextCreator;
import oracle.adfinternal.share.ADFContextUIScopeHelper;
import oracle.adfinternal.share.config.ADFContextMDSLockConfigHelper;
import oracle.adfinternal.share.config.AbstractADFConfig;
import oracle.adfinternal.share.config.JRFApplicationHelper;
import oracle.adfinternal.share.config.MDSSessionFlag;
import oracle.adfinternal.share.config.NopMDSConfigHelper;
import oracle.adfinternal.share.debug.AdfShareDebugFacadeImpl;
import oracle.adfinternal.share.util.GetPropertyAction;
import oracle.javatools.annotations.Concealed;

@AllowUntrustedScriptAccess(allowConstructor=false, methodNames={"getLocale", "getSecurityContext"})
@CodeSharingSafe(value="StaticInitializer")
public abstract class ADFContext {
    private static final String className = ADFContext.class.getName();
    private static final ADFLogger logger = ADFLogger.createADFLogger(ADFContext.class);
    @Deprecated
    private static final ADFLogger mAllocationLogger = ADFLogger.createADFLogger((String)(className + ".allocationLogger"));
    private int mAllocationLogSetCnt = 0;
    private int mAllocationLogRemoveCnt = 0;
    private StringBuilder mAllocationLog = new StringBuilder();
    private static final ADFLogger leakLogger = ADFLogger.createADFLogger((String)(className + ".leak"));
    private transient Throwable mCreatedBy = leakLogger.isFine() ? new Throwable("CREATED BY STACK, NOT AN ERROR") : null;
    private static final ResourceBundle resBundle = ResourceBundle.getBundle(Messages.class.getName());
    public static final int TYPE_GENERIC = 1;
    public static final int TYPE_HTTP = 2;
    public static final int TYPE_PORTLET = 3;
    public static final int TYPE_NAMED = 4;
    public static final String MDS_PARTITION_APPID = "partition_customizations_by_application_id";
    public static final String MDS_SESSION_OPTIONS_FACTORY = "oracle.adf.share.mds.SessionOptionsFactory";
    public static final String SESSION_SCOPE = "sessionScope";
    public static final String REQUEST_SCOPE = "requestScope";
    public static final String APPLICATION_SCOPE = "applicationScope";
    public static final String VIEW_SCOPE = "viewScope";
    public static final String SITEDEF_BASE_PACKAGE = "sitedef";
    public static final String SESSIONDEF_BASE_PACKAGE = "sessiondef";
    public static final String PERSDEF_BASE_PACKAGE = "persdef";
    public static final String USERDEF_BASE_PACKAGE = "persdef.user";
    public static final String OVERRIDE_RES_BUNDLE_PACKAGE = "xliffBundles";
    private static final String SKIP_LEVEL_ID = "#$skip$#";
    private static final String ENTERPRISE_ID = "ENTERPRISE_ID";
    private static final String TENANT_GUID = "TENANT_GUID";
    private static final String TENANT_NAME = "TENANT_NAME";
    private static final String TENANT_UID_SEPARATOR = ".";
    public static final String NAMED_CONTEXT_ENV = "named.adf.context";
    public static final String MDS_REPOS_SETUP = "mds.repository";
    public static final String MDS_REPOS_SETUP_USERNAME = "mds.username";
    public static final String MDS_REPOS_SETUP_PASSWORD = "mds.password";
    public static final String MDS_REPOS_SETUP_JDBCURL = "mds.jdbcurl";
    public static final String MDS_REPOS_SETUP_JNDINAME = "mds.jndiname";
    public static final String USE_ROLE_BASED_CUST_CLASS = "useRoleBasedCustClass";
    public static final String USER_CUST_CLASSES = "mds.cust.classes";
    public static final String ADF_CURRENT_SESSION_OPTIONS = "adf.current.session.options";
    public static final String ADF_MERGE_RESOLVER_CLASS = "adf.merge.resolver.class";
    public static final String ADF_NO_MERGE_RESOLVER = "_none_";
    public static final String ADF_SITEDEF_PACKAGES = "adf.sitedef.packages";
    public static final String ADF_SESSIONDEF_PACKAGES = "adf.sessiondef.packages";
    public static final String ADF_DEF_CACHE_POLICIES = "adf.def.cache.policies";
    public static final String ADF_SESSION_OPTIONS = "adf.session.options";
    public static final String MDS_CC_VALUES_FOR_EDIT = "mds.cc.values.for.edit";
    public static final String MDS_CC_VALUES_NONE = "_none_";
    public static final String MDS_MAX_CACHE_SIZE = "mds.max.cache.size";
    public static final String OVERRIDDEN_RES_BUNDLES = "overriddenResBundles";
    public static final String APPLICATION_DATA_KEY = "__adf_share_ref_app_data__";
    public static final String APPLICATION_DATA_SEP = "@$$@";
    protected static final String HOT_DEPLOY_STRING = "oracle.jdeveloper.adrs";
    protected static final String APPLICATION_NAME_SCOPE_KEY = "__adf_applicationname_scope__";
    protected static final String DEFAULT_APPLICATION_NAME = "defaultApplicationName";
    public static final String CONNECTIONS_RESOURCE = "META-INF/connections.xml";
    public static final String ADF_PROPERTY_NS = "http://xmlns.oracle.com/adf/config/properties";
    public static final String APPLICATION_UID = "adfAppUID";
    public static final String FEDERATED_APP_ID_KEY = "federatedApplicationIdentifier";
    private static final String UI_SCOPE_HELPER = "oracle.adfinternal.share.web.FacesTrinidadADFContextUIScopeHelper";
    private final ADFContextUIScopeHelper uiScopeHelper = new ProxiedUIScopeHelper("oracle.adfinternal.share.web.FacesTrinidadADFContextUIScopeHelper");
    private static final String IS_SERVICE_REQUEST = "__internal_adfservice__";
    public static final String ORACLE_MULTITENAT_ENABLED = "oracle.multitenant.enabled";
    public static final String ORACLE_MULTITENANT_ENABLED = "oracle.multitenant.enabled";
    public static final String IS_DISTRIBUTABLE = "oracle.adf.isDistributable";
    public static final String IF_CLUSTERED = "if_clustered";
    private static final String ADF_DOMAIN_CONFIG_SEARCHED = "adfDomainConfig_alreadySearched";
    public static final String ADF_DOMAIN_CONFIG = "adfDomainConfig";
    public static final String ATTRIBUTE_FORMATTER_MAP_KEY = "attributeFormatterMap";
    public static final String TOMCAT_SERVER_VERSION = "tomcat.server.version";
    public static final String APACHE_PREFIX = "apache";
    public static final String TOMCAT_SURFIX = "tomcat";
    public static final String GLASSFISH_PREFIX = "glassfish";
    public static final String GLASSFISH_SERVER_VERSION = "glassfish.version";
    private static final String DEBUG_FACADE_CLASS = AdfShareDebugFacadeImpl.class.getName();
    private String hotDeploy = null;
    private SecurityContext securityContext;
    private String mLoginStr = null;
    private Object mdsSession = null;
    private Object baseMDSSession = null;
    private List siteDefPackages = null;
    private List sessDefPackages = null;
    private List defCachePolicies = null;
    private List adfSessionOptionsList = null;
    private Object currentADFSessionOptions = null;
    private Locale mLocale = null;
    private boolean mIsAuthChecked = false;
    private boolean mIsAuthEnabled = false;
    private MetadataEnvironment _metadataEnvironment = null;
    @CodeSharingSafe(value="MutableStaticField")
    private static final boolean mIsJEE = AdfServerPlatformUtil.isJEE();
    @CodeSharingSafe(value="MutableStaticField")
    private static Boolean mIsMultiTenantEnabled = null;
    private transient Map<String, Map<String, Object>> scopeMap = new HashMap<String, Map<String, Object>>(4);
    private static final MultiTenantStorage<ReadWriteLock> mScopeMapLock = new MultiTenantStorage<ReadWriteLock>(){

        protected ReadWriteLock initialValue() {
            return new ReentrantReadWriteLock();
        }
    };
    private static final MultiTenantStorage<Map<Object, Map<String, Object>>> mApplicationScopeMap = new MultiTenantStorage<Map<Object, Map<String, Object>>>(){

        protected Map<Object, Map<String, Object>> initialValue() {
            return new WeakHashMap<Object, Map<String, Object>>(4);
        }
    };
    private transient ADFExpressionEvaluator mExpressionEvaluator = new OracleExpressionEvaluatorImpl();
    private transient VariableResolver mVariableResolver = null;
    private transient ExpressionFactory mExpressionFactory = null;
    private static final ThreadLocal<ADFContext> contextStore = mIsJEE ? new ThreadLocal() : new InheritableThreadLocal();
    private static final MultiTenantStorage<Map<String, ContextInfo>> contextInfos = new MultiTenantStorage<Map<String, ContextInfo>>(){

        protected Map<String, ContextInfo> initialValue() {
            return new HashMap<String, ContextInfo>();
        }
    };
    private static final MultiTenantStorage<Map<String, ADFContext>> namedContextMap = new MultiTenantStorage<Map<String, ADFContext>>(){

        protected Map<String, ADFContext> initialValue() {
            return new HashMap<String, ADFContext>();
        }
    };
    private static final MultiTenantStorage<Object> namedContextLock = new MultiTenantStorage<Object>(){

        protected Object initialValue() {
            return new Object();
        }
    };
    private ADFContextMDSConfigHelper _mdsConfigHelper = null;
    private final Map mThreadLocalMap = new HashMap(4);
    private static final String JBOSS_CONNECTION_WRAPPER = "org.jboss.resource.adapter.jdbc.WrappedConnection";
    @CodeSharingSafe(value="MutableStaticField")
    private static boolean alreadyCheckedForJBoss = false;
    @CodeSharingSafe(value="MutableStaticField")
    private static boolean isJBossRuntime = false;
    private AdfServerPlatformSupport mPlatformSupport = null;
    private boolean mPlatformChecked = false;
    private boolean m_sessionLockEnabled = false;
    private Throwable goodEnvironmentLost = null;
    private boolean lostEnvLogged = false;
    private static final ADFLogger scopeLogger = ADFLogger.createADFLogger((String)(ADFContext.class.getName() + ".applicationScope"));
    private static final String INITIAL_CONTEXT_IMPL = InitialContextFactoryImpl.class.getName();
    private static final String RESOURCE_BACKING_STORE = "oracle.adf.share.jndi.MDSBackingStore";
    @CodeSharingSafe(value="MutableStaticField")
    private static DesignTimeLinkage _dtLinkage;
    private static final ADFContextUIScopeHelper nonUIScopeHelper;

    protected ADFContext() {
    }

    @Concealed
    public Throwable getCreatedBy() {
        return this.mCreatedBy;
    }

    public void useLockedMDSSession() {
        this.m_sessionLockEnabled = true;
    }

    protected void useUnlockedMDSSession() {
        this.m_sessionLockEnabled = false;
    }

    private void setMDSSessionLock(boolean lock) {
        this.m_sessionLockEnabled = lock;
    }

    public boolean isLockedMDSSession() {
        return this.m_sessionLockEnabled;
    }

    protected abstract Environment loadEnvironment();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putScope(String name, Map<String, Object> scope) {
        if (scope != null && !(scope instanceof ADFScope) && logger.isSevere()) {
            logger.severe("Error:  Registered a scope that does not implement ADFScope:  " + name);
        }
        if (APPLICATION_SCOPE.equals(name)) {
            this.putApplicationScopeMap(scope);
        } else if (VIEW_SCOPE.equals(name)) {
            throw new RuntimeException(resBundle.getString("ADFCONTEXT_CANT_REGISTER_VIEW_SCOPE"));
        }
        Map<String, Map<String, Object>> map = this.scopeMap;
        synchronized (map) {
            this.scopeMap.put(name, scope);
        }
    }

    @Concealed
    void connectionsChanged(String filePath) {
    }

    public boolean isHotDeploy() {
        if (this.hotDeploy == null) {
            StringPropertyPrivAction propAction = new StringPropertyPrivAction(HOT_DEPLOY_STRING, "false");
            this.hotDeploy = (String)AccessController.doPrivileged(propAction);
        }
        return Boolean.valueOf(this.hotDeploy);
    }

    public void setHotDeploy(boolean hotDep) {
        this.hotDeploy = String.valueOf(hotDep);
    }

    public boolean isDesignTime() {
        return Beans.isDesignTime();
    }

    public Map<String, Object> getScope(String name) {
        Map scope = this.findScope(name);
        if (scope == null) {
            if (APPLICATION_SCOPE.equals(name)) {
                scope = this.getApplicationScopeMap();
            } else if (!VIEW_SCOPE.equals(name)) {
                scope = this.createScope(name);
                this.putScope(name, scope);
            } else {
                return this.getViewScope();
            }
        }
        return scope;
    }

    public Map<String, Object> findScope(String name) {
        if (APPLICATION_SCOPE.equals(name)) {
            if (this.goodEnvironmentLost != null && !this.lostEnvLogged) {
                this.lostEnvLogged = true;
                if (scopeLogger.isFine()) {
                    scopeLogger.log(Level.FINE, resBundle.getString("GOOD_ENV_CTX_LOST_ON_INIT"), this.goodEnvironmentLost);
                } else if (scopeLogger.isWarning()) {
                    scopeLogger.warning(resBundle.getString("GOOD_ENV_CTX_LOST_ON_INIT") + " " + resBundle.getString("USE_FINE_FOR_DETAILS"));
                }
            }
            return this.findApplicationScopeMap();
        }
        if (VIEW_SCOPE.equals(name)) {
            Map<String, Object> context = this.findScope(APPLICATION_SCOPE);
            if (context != null) {
                try {
                    return this.getViewScope();
                }
                catch (ViewScopeException viewScopeException) {
                    // empty catch block
                }
            }
            return null;
        }
        return this.scopeMap.get(name);
    }

    protected Object getApplicationScopekey() {
        Object ret = ADFConfigFactory.internalFindADFConfigId();
        return ret != null ? ret : this.getADFConfig().getId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void putApplicationScopeMap(Map<String, Object> scope) {
        Object key = this.getApplicationScopekey();
        Map<String, Object> previous = null;
        ((ReadWriteLock)mScopeMapLock.get()).writeLock().lock();
        try {
            if (scopeLogger.isInfo()) {
                scopeLogger.info("adding applicationScope with key " + key);
            }
            previous = ((Map)mApplicationScopeMap.get()).put(key, scope);
        }
        finally {
            ((ReadWriteLock)mScopeMapLock.get()).writeLock().unlock();
        }
        if (previous != null && previous != scope) {
            logger.log(Level.WARNING, "Application scope is replaced: context = " + this + " key = " + key + " scope = " + scope + " previous = " + previous, (Throwable)(logger.isLoggable(Level.FINEST) ? new Exception("Stack trace") : null));
        } else if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Application scope is set: context = " + this + " key = " + key + " scope = " + scope, (Throwable)(logger.isLoggable(Level.FINEST) ? new Exception("Stack trace") : null));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, Object> getApplicationScopeMap() {
        Map scope = null;
        ((ReadWriteLock)mScopeMapLock.get()).readLock().lock();
        try {
            scope = this.findScope(APPLICATION_SCOPE);
        }
        finally {
            ((ReadWriteLock)mScopeMapLock.get()).readLock().unlock();
        }
        if (scope == null) {
            Object key = null;
            Map previous = null;
            ((ReadWriteLock)mScopeMapLock.get()).writeLock().lock();
            try {
                scope = this.findScope(APPLICATION_SCOPE);
                if (scope == null) {
                    key = this.getApplicationScopekey();
                    scope = this.createScope(APPLICATION_SCOPE);
                    if (scopeLogger.isInfo()) {
                        scopeLogger.info("adding applicationScope with key " + key);
                    }
                    previous = ((Map)mApplicationScopeMap.get()).put(key, scope);
                }
            }
            finally {
                ((ReadWriteLock)mScopeMapLock.get()).writeLock().unlock();
            }
            if (previous != null && previous != scope) {
                logger.log(Level.WARNING, "Application scope is replaced: context = " + this + " key = " + key + " scope = " + scope + " previous = " + previous, (Throwable)(logger.isLoggable(Level.FINEST) ? new Exception("Stack trace") : null));
            } else if (key != null && logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Application scope is set: context = " + this + " key = " + key + " scope = " + scope, (Throwable)(logger.isLoggable(Level.FINEST) ? new Exception("Stack trace") : null));
            }
        }
        return scope;
    }

    protected Map<String, Object> findApplicationScopeMap() {
        Object key = this.getApplicationScopekey();
        ((ReadWriteLock)mScopeMapLock.get()).readLock().lock();
        try {
            Map map = (Map)((Map)mApplicationScopeMap.get()).get(key);
            return map;
        }
        finally {
            ((ReadWriteLock)mScopeMapLock.get()).readLock().unlock();
        }
    }

    public Map<String, Object> getViewScope() {
        Map<String, Object> map = this.getADFFacesViewScopeMap();
        if (map == null && logger.isFine()) {
            logger.fine("Null viewScope found ");
        }
        return map;
    }

    @Concealed
    public Map<String, Object> getADFFacesViewScopeMap() {
        return this.uiScopeHelper.getViewScopeMap(this);
    }

    public Map createScope(String name) {
        if (APPLICATION_SCOPE.equals(name)) {
            Map<String, Object> scope = this.createScope(name, true);
            if (!ADFScopeHelper.isReleasing() && this.hasEnvironment() && this.getEnvironment().getContext() != null && scope instanceof ADFScope) {
                ((ADFScope)scope).addScopeListener(new ADFScopeListener(){

                    @Override
                    public void scopeInvalidated(String scopeName) {
                    }
                });
            }
            return scope;
        }
        return this.createScope(name, false);
    }

    protected Map<String, Object> createScope(String name, boolean concurrent) {
        if (VIEW_SCOPE.equals(name)) {
            throw new RuntimeException(resBundle.getString("ADFCONTEXT_CANT_CREATE_VIEW_SCOPE"));
        }
        if (concurrent) {
            return new HashMapScopeAdapter(name, new ConcurrentHashMap(4));
        }
        return new HashMapScopeAdapter(name, new HashMap(4));
    }

    protected void removingScope(String name) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> removeScope(String name) {
        if (APPLICATION_SCOPE.equals(name)) {
            Object key = this.getApplicationScopekey();
            this.removingScope(name);
            ((ReadWriteLock)mScopeMapLock.get()).writeLock().lock();
            try {
                if (scopeLogger.isInfo()) {
                    scopeLogger.info("removing applicationScope with key " + key);
                }
                Map map = (Map)((Map)mApplicationScopeMap.get()).remove(key);
                return map;
            }
            finally {
                ((ReadWriteLock)mScopeMapLock.get()).writeLock().unlock();
            }
        }
        Map<String, Map<String, Object>> map = this.scopeMap;
        synchronized (map) {
            return this.scopeMap.remove(name);
        }
    }

    public Set getScopeNames() {
        Set<String> set = this.scopeMap.keySet();
        if (this.findScope(APPLICATION_SCOPE) != null) {
            HashSet<String> aSet = new HashSet<String>(set);
            aSet.add(APPLICATION_SCOPE);
            return Collections.unmodifiableSet(aSet);
        }
        return set;
    }

    public Map<String, Object> getApplicationScope() {
        return this.getScope(APPLICATION_SCOPE);
    }

    public Map getSessionScope() {
        return this.getScope(SESSION_SCOPE);
    }

    public Map getRequestScope() {
        return this.getScope(REQUEST_SCOPE);
    }

    public ADFConfig getApplication() {
        return this.getADFConfig();
    }

    public ADFConfig getADFConfig() {
        return this.getADFConfigEx();
    }

    public String getEnterpriseId() {
        return this.getTenantId();
    }

    public String getEnterpriseName() {
        String name = this.getTenantName();
        return name.equals("") ? name : name + TENANT_UID_SEPARATOR;
    }

    public void setEnterpriseId(String eid) {
        Map map = this.getSessionScope();
        map.put(ENTERPRISE_ID, eid);
    }

    public String getTenantId() {
        return this.getTenantProperty(TENANT_GUID);
    }

    public String getTenantName() {
        String name = this.getTenantProperty(TENANT_NAME);
        return name == null ? "" : name;
    }

    public ADFConfigEx getADFConfigEx() {
        return ADFConfigFactory.findOrCreateADFConfig();
    }

    public ADFSettings getADFSettings() {
        return ConfigContainerFactory.findOrCreateConfig("oracle.adf.share.ADFSettings");
    }

    public SecurityContext getSecurityContext() {
        if (this.securityContext == null) {
            ADFContext oldCtx = this.setupCurrentInternal();
            try {
                this.securityContext = (SecurityContext)this.getADFConfig().getSecurityContext();
                this.setSecurityContext(this.securityContext);
            }
            catch (NamingException ne) {
                logger.log(Level.INFO, "", (Throwable)ne);
            }
            finally {
                this.unsetCurrentInternal(oldCtx);
            }
        }
        return this.securityContext;
    }

    public boolean hasSecurityContext() {
        if (!this.mIsAuthChecked) {
            this.mIsAuthEnabled = ADFSecurityUtil.isAuthorizationEnabled();
            this.mIsAuthChecked = true;
        }
        if (this.mIsAuthEnabled) {
            return true;
        }
        return this.securityContext != null;
    }

    public Context getSharedConnectionsContext() throws NamingException {
        if (logger.isFine()) {
            logger.fine("Get shared connections context.");
        }
        Hashtable<String, String> env = new Hashtable<String, String>(7);
        env.put("java.naming.factory.initial", INITIAL_CONTEXT_IMPL);
        env.put("java.naming.provider.url", CONNECTIONS_RESOURCE);
        env.put("oracle.adf.share.jndi.documentstore", RESOURCE_BACKING_STORE);
        env.put("_cache_application_scope_", Boolean.TRUE.toString());
        env.put("SITE_LAYER_CONNECTIONS_CONTEXT", Boolean.TRUE.toString());
        return new AdfInitialContext((Hashtable)env);
    }

    public Context getConnectionsContext() throws NamingException {
        ADFContext oldCtx = this.setupCurrentInternal();
        try {
            Context context = this.getADFConfig().getConnectionsContext();
            return context;
        }
        finally {
            this.unsetCurrentInternal(oldCtx);
        }
    }

    public static boolean hasCurrent() {
        ADFContext ctx = ADFContext.getCurrentInternal();
        return ctx != null;
    }

    public static ADFContext findCurrent() {
        ADFContext ctx = ADFContext.getCurrentInternal();
        if (ctx == null) {
            throw new RuntimeException("A current ADFContext is not available.");
        }
        return ctx;
    }

    public static ADFContext getCurrent() {
        boolean created = false;
        ADFContext ctx = ADFContext.getCurrentInternal();
        if (ctx == null) {
            if (_dtLinkage == null) {
                if (logger.isWarning()) {
                    logger.warning(className, "getCurrent", resBundle.getString("ADFCONTEXT_DEFAULT_WARNING"));
                }
                if (logger.isFinest()) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("Class loaders on thread:\n");
                    LoaderUtil.dumpClassLoaderHierarchy((ClassLoader)ADFContext.getThreadContextClassLoader(), (StringBuilder)sb, (String)"", (String)"  ");
                    sb.append("getCurrent stack trace:\n");
                    for (StackTraceElement ste : Thread.currentThread().getStackTrace()) {
                        sb.append(ste.toString());
                        sb.append("\n");
                    }
                    logger.finest(sb.toString());
                }
            }
            created = true;
            ctx = ADFContext.createDefaultContext();
        }
        if (_dtLinkage != null && ctx != null && created && logger.isFine() && !ctx.getClass().getName().contains("JDevDefaultNamedContext")) {
            String logMsg = "NOTE: getCurrent created: " + ctx.getClass().getName();
            if (logger.isFinest()) {
                logger.log(Level.FINEST, logMsg, new Throwable("DIAGNOSTIC AID, NOT AN ERROR"));
            } else {
                logger.fine(logMsg);
            }
        }
        return ctx;
    }

    private static ADFContext createDefaultContext() {
        ADFContext ret;
        ADFContext aDFContext = ret = _dtLinkage != null ? _dtLinkage.findOrCreateDefaultADFContext() : null;
        if (ret != null) {
            ret.setAsCurrent();
            return ret;
        }
        DefaultContext ctx = new DefaultContext();
        ctx.setAsCurrent();
        if (logger.isFine()) {
            logger.fine(className, "getCurrent", "DefaultContext is set as current");
        }
        return ctx;
    }

    static void setDesignTimeLinkage(DesignTimeLinkage linkage) {
        _dtLinkage = linkage;
    }

    private static ADFContext getCurrentInternal() {
        return contextStore.get();
    }

    public boolean isMultiTenantEnabled() {
        if (mIsMultiTenantEnabled == null && mIsMultiTenantEnabled == null) {
            mIsMultiTenantEnabled = Boolean.parseBoolean(this.getSystemProperty("oracle.multitenant.enabled"));
        }
        return mIsMultiTenantEnabled;
    }

    @Deprecated
    static void resetMultiTenantEnabled() {
        if (mIsMultiTenantEnabled != null) {
            mIsMultiTenantEnabled = null;
        }
    }

    public boolean isDistributable() {
        String propStr = this.getADFContextProperty(IS_DISTRIBUTABLE);
        if (propStr != null) {
            if (IF_CLUSTERED.equals(propStr)) {
                AdfServerPlatformSupport platform = this.getAdfServerPlatformSupport();
                if (platform != null) {
                    String clusterName;
                    block6: {
                        clusterName = null;
                        try {
                            clusterName = platform.getClusterName();
                        }
                        catch (Exception e) {
                            if (!logger.isFinest()) break block6;
                            StringBuilder sb = new StringBuilder("An error occurred while looking up the cluster name:\n");
                            sb.append("ADF state distribution is not enabled.  Please specify oracle.adf.isDistributable=true if distribution is required.\n");
                            logger.finest(sb.toString(), (Throwable)e);
                        }
                    }
                    return clusterName != null && !"cluster_unknown".equals(clusterName);
                }
            } else {
                return Boolean.parseBoolean(propStr);
            }
        }
        return false;
    }

    public String getADFContextProperty(String propName) {
        ADFConfig adfConfig = this.getADFConfig();
        if (adfConfig == null) {
            return null;
        }
        Map propertyMap = adfConfig.getConfigObject(ADF_PROPERTY_NS);
        if (propertyMap == null) {
            return null;
        }
        return (String)propertyMap.get(propName);
    }

    public String getADFContextPropertyNoCase(String propName) {
        ADFConfig adfConfig = this.getADFConfig();
        if (adfConfig == null) {
            return null;
        }
        Map propertyMap = adfConfig.getConfigObject(ADF_PROPERTY_NS);
        if (propertyMap == null) {
            return null;
        }
        return (String)this.getValCaseFree(propertyMap, propName);
    }

    private Object getValCaseFree(Map keyVal, String key) {
        if (keyVal == null || keyVal.isEmpty()) {
            return null;
        }
        for (Object mKey : keyVal.keySet()) {
            if (!((String)mKey).equalsIgnoreCase(key)) continue;
            return keyVal.get(mKey);
        }
        return null;
    }

    public String getADFApplicationUID() {
        return this.getADFContextProperty(APPLICATION_UID);
    }

    public void setupADFDomainConfig(URL domainAdfConfigFileURL) {
        this.initADFDomainConfigIfNeeded(domainAdfConfigFileURL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initADFDomainConfigIfNeeded(URL domainAdfConfigFileURL) {
        Map<String, Object> map = this.getApplicationScope();
        if (!map.containsKey(ADF_DOMAIN_CONFIG_SEARCHED)) {
            Object domainConfig = null;
            Class ctxClz = null;
            try {
                ctxClz = ClassUtils.forName((String)"oracle.adf.share.domain.config.ADFDomainConfig", this.getClass());
                if (ctxClz != null) {
                    Method init = ctxClz.getMethod("getInstance", URL.class);
                    domainConfig = init.invoke((Object)ctxClz, domainAdfConfigFileURL);
                }
                ADFContext.getCurrent().getApplicationScope().put(ADF_DOMAIN_CONFIG, domainConfig);
            }
            catch (Exception ignore) {
                String msg = resBundle.getString("ADFCONTEXT_DOMAIN_CONFIG_ERR");
                logger.info(msg);
                if (logger.isFine()) {
                    logger.fine(msg, (Throwable)ignore);
                }
            }
            finally {
                ADFContext.getCurrent().getApplicationScope().put(ADF_DOMAIN_CONFIG_SEARCHED, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerNamedContext(String name, URL url, Class implClass) throws NameAlreadyBoundException {
        Object object = namedContextLock.get();
        synchronized (object) {
            if (((Map)contextInfos.get()).containsKey(name)) {
                throw new NameAlreadyBoundException("NamedContext for this name alreadyexists " + contextInfos.get());
            }
            ContextInfo info = new ContextInfo(name, url, implClass);
            ((Map)contextInfos.get()).put(name, info);
        }
    }

    public static void registerNamedContext(String name, URL url) throws NameAlreadyBoundException {
        ADFContext.registerNamedContext(name, url, DefaultNamedContext.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregisterNamedContext(String name) {
        Object object = namedContextLock.get();
        synchronized (object) {
            if (!((Map)contextInfos.get()).containsKey(name)) {
                if (logger.isFine()) {
                    logger.fine(className, "unregisterNamedContext", "Name not found " + name);
                }
                return;
            }
            ((Map)contextInfos.get()).remove(name);
            ((Map)namedContextMap.get()).remove(name);
        }
        ADFConfigFactory.unregisterNamedConfig(name);
    }

    public static boolean isNamedContextRegistered(String name) {
        return ((Map)contextInfos.get()).containsKey(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ADFContext get(String name) throws Exception {
        if (name == null || name.length() == 0) {
            return ADFContext.getCurrent();
        }
        if (!((Map)contextInfos.get()).containsKey(name)) {
            throw new RuntimeException("Named ADFContext for " + name + " has not been created");
        }
        Object object = namedContextLock.get();
        synchronized (object) {
            ContextInfo info;
            ADFContext ctx = (ADFContext)((Map)namedContextMap.get()).get(name);
            if (ctx == null && (ctx = (info = (ContextInfo)((Map)contextInfos.get()).get(name)).createContext()) != null) {
                ((Map)namedContextMap.get()).put(name, ctx);
            }
            return ctx;
        }
    }

    public URL getURL() {
        throw new UnsupportedOperationException();
    }

    public String getApplicationName() {
        Map<String, Object> scope = this.getScope(APPLICATION_SCOPE);
        String appName = (String)scope.get(APPLICATION_NAME_SCOPE_KEY);
        if (appName == null) {
            appName = this.getDeployedAppName();
            if (appName == null || appName.length() == 0) {
                appName = DEFAULT_APPLICATION_NAME;
            }
            scope.put(APPLICATION_NAME_SCOPE_KEY, appName);
        }
        if (logger.isFine()) {
            logger.fine(className, "getApplicationName", "Returning " + appName);
        }
        return appName;
    }

    protected String getDeployedAppName() {
        try {
            return JRFApplicationHelper.getMDSInstanceAppName();
        }
        catch (Throwable t) {
            if (!Beans.isDesignTime() && logger.isFine()) {
                logger.fine(t);
            }
            return null;
        }
    }

    public void setAsCurrent() {
        contextStore.set(this);
        if (mAllocationLogger.isFinest()) {
            ++this.mAllocationLogSetCnt;
            this.storeAllocationStack(">>>> Set ADFContext:");
        }
        if (logger.isSevere()) {
            ADFContext.registerThreadLocalValue(contextStore, new LeakReporter(leakLogger.isSevere() ? new Throwable("DIAGNOSTIC AID", this.mCreatedBy) : null));
        } else {
            ADFContext.registerThreadLocalValue(contextStore, null);
        }
    }

    public void removeAsCurrent() {
        if (mAllocationLogger.isFinest()) {
            ++this.mAllocationLogRemoveCnt;
            this.storeAllocationStack(">>>> Reset ADFContext:");
        }
        contextStore.remove();
        ADFContext.unregisterThreadLocalValue(contextStore);
    }

    private void storeAllocationStack(String msg) {
        if (msg != null) {
            this.mAllocationLog.append(msg).append("\n");
        }
        this.logContext(this.mAllocationLog);
        this.mAllocationLog.append("Thread:  ").append(Thread.currentThread()).append("\n");
        for (StackTraceElement frame : Thread.currentThread().getStackTrace()) {
            this.mAllocationLog.append(frame.toString()).append("\n");
        }
        if (this.mAllocationLogSetCnt + this.mAllocationLogRemoveCnt >= 2) {
            StringBuilder sb = new StringBuilder(">> Allocation logger invoked:  ALLOCATION BUFFER EXCEEDED, STARTING OVER\n");
            this.logDiagnosticsInternal(sb, true);
        }
    }

    public static void logDiagnosticsForException(Throwable t) {
        if (mAllocationLogger.isFinest()) {
            ADFContext adfContext = ADFContext.getCurrentInternal();
            if (adfContext != null) {
                StringBuilder sb = new StringBuilder(">> AllocationLogger invoked for exception:\n");
                sb.append(t.toString()).append("\n");
                adfContext.logDiagnosticsInternal(sb, true);
            } else {
                mAllocationLogger.finest("No current ADFContext on: " + t);
            }
        }
    }

    private void logDiagnosticsInternal(StringBuilder sb, boolean write) {
        if (mAllocationLogger.isFinest()) {
            sb.append("Set Count=" + this.mAllocationLogSetCnt + " Remove Count=" + this.mAllocationLogRemoveCnt + "\n");
            String previousLog = this.mAllocationLog.toString();
            this.mAllocationLogSetCnt = 0;
            this.mAllocationLogRemoveCnt = 0;
            this.mAllocationLog = new StringBuilder();
            this.logContext(sb);
            sb.append(">> Allocation stacks:\n");
            sb.append(previousLog);
            if (write) {
                mAllocationLogger.finest(sb.toString());
            }
        }
    }

    private void logContext(StringBuilder sb) {
        if (this.hasEnvironment()) {
            sb.append("Current external context:\n");
            sb.append("Context:  ").append(this.getEnvironment().getContext()).append("\n");
            sb.append("Request:  ").append(this.getEnvironment().getRequest()).append("\n");
        }
    }

    @Concealed
    public void setSecurityContext(SecurityContext ctx) {
        this.securityContext = ctx;
    }

    public String getMDSLogin() {
        new UnsupportedOperationException("getMDSLogin() is not supported.  Please don't call this method").printStackTrace();
        return this.mLoginStr;
    }

    public void setMDSLogin(String loginStr) {
        new UnsupportedOperationException("setMDSLogin() is not supported.  Please don't call this method").printStackTrace();
        this.mLoginStr = loginStr;
    }

    protected SecurityContext loadSecurityContext() {
        JAASInitialContextFactory factory = new JAASInitialContextFactory();
        SecurityContext secCtx = null;
        try {
            secCtx = (SecurityContext)factory.getInitialContext((Hashtable)null);
            this.setSecurityContext(secCtx);
        }
        catch (NamingException ne) {
            logger.fine((Throwable)ne);
        }
        return secCtx;
    }

    public Context getConfigSecurityContext() throws NamingException {
        return this.getADFConfig().getSecurityContext();
    }

    public Locale getLocale() {
        Locale locale = null;
        if (this.hasEnvironment()) {
            locale = this.getEnvironment().getRequestLocale();
        }
        return locale != null ? locale : this.mLocale;
    }

    public void setLocale(Locale locale) {
        if (this.mLocale == null) {
            this.mLocale = locale;
        }
    }

    public void clearCachedLocale() {
        this.mLocale = null;
        if (this.hasEnvironment()) {
            this.getEnvironment().clearCachedLocale();
        }
    }

    public final Environment getEnvironment() {
        return this.loadEnvironment();
    }

    public boolean hasEnvironment() {
        return false;
    }

    public VariableResolver getVariableResolver() {
        if (this.mVariableResolver == null) {
            this.mVariableResolver = new ADFContextVariableResolverImpl();
        }
        return this.mVariableResolver;
    }

    public void setVariableResolver(VariableResolver variableResolver) {
        if (variableResolver != null) {
            this.mVariableResolver = variableResolver;
        }
    }

    public ADFExpressionEvaluator getExpressionEvaluator() {
        return this.mExpressionEvaluator;
    }

    public void setExpressionEvaluator(ADFExpressionEvaluator expressionEvaluator) {
        if (expressionEvaluator != null) {
            this.mExpressionEvaluator = expressionEvaluator;
        }
    }

    public ELContext getELContext() {
        ADFELContext elContext;
        block4: {
            elContext = null;
            try {
                Object facesContext;
                if (this.hasEnvironment() && (facesContext = this.getEnvironment().getFacesContext()) != null) {
                    Class<?> facesContextClz = facesContext.getClass();
                    Method getELContext = facesContextClz.getMethod("getELContext", null);
                    elContext = (ELContext)getELContext.invoke(facesContext, null);
                }
            }
            catch (Exception e) {
                if (!logger.isFine()) break block4;
                logger.fine("ADFContext.getELContext unable to locate a FacesContext");
            }
        }
        if (elContext == null) {
            elContext = new ADFELContext();
        }
        return elContext;
    }

    public ExpressionFactory getExpressionFactory() {
        block4: {
            if (this.mExpressionFactory != null) {
                return this.mExpressionFactory;
            }
            try {
                Object facesContext;
                if (this.hasEnvironment() && (facesContext = this.getEnvironment().getFacesContext()) != null) {
                    Class<?> facesContextClz = facesContext.getClass();
                    Method getApplication = facesContextClz.getMethod("getApplication", null);
                    Object application = getApplication.invoke(facesContext, null);
                    Class<?> facesApplicationClz = Class.forName("javax.faces.application.Application", true, ADFContext.getThreadContextClassLoader());
                    Method getExpressionFactory = facesApplicationClz.getMethod("getExpressionFactory", null);
                    this.mExpressionFactory = (ExpressionFactory)getExpressionFactory.invoke(application, null);
                }
            }
            catch (Exception e) {
                if (!logger.isFine()) break block4;
                StringBuilder sb = new StringBuilder("ADFContext.getExpressionFactory unable to locate an expression factory from faces\n");
                sb.append(e.getMessage());
                logger.fine(sb.toString());
            }
        }
        return this.mExpressionFactory;
    }

    public void setExpressionFactory(ExpressionFactory expressionFactory) {
        if (expressionFactory != null) {
            this.mExpressionFactory = expressionFactory;
        }
    }

    public Map getStateManager(String scopeName, Hashtable env) {
        return new StateManagerScopeAdapter(scopeName, env);
    }

    private AdfServerPlatformSupport getAdfServerPlatformSupport() {
        block4: {
            if (this.mPlatformChecked && this.mPlatformSupport == null) {
                return null;
            }
            try {
                if (this.mPlatformSupport == null) {
                    this.mPlatformChecked = true;
                    this.mPlatformSupport = new AdfServerPlatformSupportFactory().getSupportInstance();
                }
            }
            catch (Throwable t) {
                if (Beans.isDesignTime() || !logger.isFine()) break block4;
                logger.fine(t);
            }
        }
        return this.mPlatformSupport;
    }

    public final boolean isHighPerformanceEnvEnabled() {
        if (!this.isJEE()) {
            return true;
        }
        AdfServerPlatformSupport platform = this.getAdfServerPlatformSupport();
        if (platform == null) {
            return false;
        }
        try {
            return platform.isExalogicOptimizationsEnabled();
        }
        catch (Throwable t) {
            if (!Beans.isDesignTime() && logger.isFine()) {
                logger.fine(t);
            }
            return false;
        }
    }

    public final boolean isJEE() {
        if (mIsJEE) {
            return true;
        }
        int contextType = this.getContextType();
        return contextType == 2 || contextType == 3;
    }

    public abstract int getContextType();

    public boolean isHttpContext() {
        return false;
    }

    @Concealed
    public boolean isInServiceRequest() {
        Object val = this.getRequestScope().get(IS_SERVICE_REQUEST);
        return Boolean.TRUE.equals(val);
    }

    @Concealed
    public void setIsInServiceRequest(boolean flag) {
        Map map = this.getRequestScope();
        if (flag) {
            map.put(IS_SERVICE_REQUEST, Boolean.TRUE);
        } else if (map.containsKey(IS_SERVICE_REQUEST)) {
            map.remove(IS_SERVICE_REQUEST);
        }
    }

    public boolean hasSession() {
        return false;
    }

    public MetadataEnvironment getMetadataEnvironment() {
        MetadataEnvironment metadataEnv = this._metadataEnvironment;
        if (metadataEnv == null) {
            this._metadataEnvironment = metadataEnv = MetadataEnvironmentFactory.getDefaultFactory().newInstance(null);
        }
        return metadataEnv;
    }

    @Concealed
    public MetadataEnvironment setCustomMetadataEnvironment(MetadataEnvironment e) {
        if (e == null) {
            throw new IllegalArgumentException("Invalid custom metadata environment: null.");
        }
        if (!MetadataEnvironmentFactory.getDefaultFactory().isCustomMetadataEnvironment(e)) {
            throw new IllegalArgumentException("The given instance of " + e.getClass().getName() + " is not a custom metadata environment.");
        }
        MetadataEnvironment o = this._metadataEnvironment;
        this._metadataEnvironment = e;
        return o;
    }

    public Object getMDSInstanceAsObject() {
        return this.getMDSConfigHelper().getMDSInstance(this);
    }

    public synchronized Object getMDSSessionAsObject() {
        if (this.mdsSession == null) {
            ADFContext oldCtx = this.setupCurrentInternal();
            try {
                MDSSessionFlag.setMDSSessionInit();
                ADFContextMDSConfigHelper helper = this.getMDSConfigHelper();
                if (helper != null) {
                    if (this.isLockedMDSSession()) {
                        ((ADFContextMDSLockConfigHelper)((Object)helper)).useLockedMDSSession();
                    }
                    this.mdsSession = helper.createMDSSession(this);
                }
            }
            finally {
                this.unsetCurrentInternal(oldCtx);
            }
        }
        MDSSessionFlag.clearMDSSessionInit();
        return this.mdsSession;
    }

    public synchronized boolean hasBaseMDSSessionAsObject() {
        return this.baseMDSSession != null && this.getMDSSessionAsObject() != this.baseMDSSession;
    }

    public synchronized Object getBaseMDSSessionAsObject() {
        Object sess = this.getMDSSessionAsObject();
        if (this.baseMDSSession == null) {
            return sess;
        }
        return this.baseMDSSession;
    }

    public synchronized void setBaseMDSSessionAsObject(Object o) {
        this.baseMDSSession = o;
    }

    private final ADFContext setupCurrentInternal() {
        ADFContext oldCtx = ADFContext.getCurrentInternal();
        if (this != oldCtx) {
            this.setAsCurrent();
        }
        return oldCtx;
    }

    private final void unsetCurrentInternal(ADFContext oldCtx) {
        if (this != oldCtx) {
            if (oldCtx != null) {
                oldCtx.setAsCurrent();
            } else {
                this.removeAsCurrent();
            }
        }
    }

    public synchronized List getSiteDefPackages() {
        if (this.siteDefPackages == null) {
            this.siteDefPackages = ((AbstractADFConfig)this.getADFConfig()).getSiteDefPackages();
        }
        return this.siteDefPackages;
    }

    public synchronized List getSessionDefPackages() {
        if (this.sessDefPackages == null) {
            this.sessDefPackages = ((AbstractADFConfig)this.getADFConfig()).getSessionDefPackages();
        }
        return this.sessDefPackages;
    }

    public synchronized List getDefCachePolicies() {
        if (this.defCachePolicies == null) {
            this.defCachePolicies = ((AbstractADFConfig)this.getADFConfig()).getDefCachePolicies();
        }
        return this.defCachePolicies;
    }

    public synchronized List getADFSessionOptionsList() {
        if (this.adfSessionOptionsList == null) {
            this.adfSessionOptionsList = ((AbstractADFConfig)this.getADFConfig()).getADFSessionOptionsList();
        }
        return this.adfSessionOptionsList;
    }

    public synchronized Object getCurrentADFSessionOptions() {
        Object opts = this.currentADFSessionOptions;
        if (opts == null) {
            Map sessMap = this.getSessionScope();
            if (sessMap != null) {
                opts = sessMap.get(ADF_CURRENT_SESSION_OPTIONS);
            }
            if (opts == null) {
                opts = ((AbstractADFConfig)this.getADFConfig()).getCurrentADFSessionOptions();
                if (opts != null && sessMap != null) {
                    sessMap.put(ADF_CURRENT_SESSION_OPTIONS, opts);
                    this.currentADFSessionOptions = opts;
                }
            } else {
                this.currentADFSessionOptions = opts;
            }
        }
        return opts;
    }

    public boolean hasMDSSession() {
        return this.mdsSession != null;
    }

    public void releaseMDSSession() {
        if (this.mdsSession != null) {
            this.mdsSession = null;
        }
    }

    public void releaseMDSInstance() {
        this.releaseMDSSession();
        this.getMDSConfigHelper().releaseMDSInstance(this);
    }

    public Object getSkipLevelIdentifier() {
        return SKIP_LEVEL_ID;
    }

    public static void registerThreadLocalValue(ThreadLocal local, Runnable resetHandler) {
        ADFContext.updateThreadLocal(local, local.get(), resetHandler);
    }

    public static void unregisterThreadLocalValue(ThreadLocal local) {
        ADFContext.updateThreadLocal(local, null, null);
    }

    private static void updateThreadLocal(ThreadLocal local, Object value, Runnable resetHandler) {
        if (AdfServerPlatformUtil.isWebLogicJRF() || AdfServerPlatformUtil.isWebLogicCore()) {
            try {
                Class managerClz = ClassUtils.forName((String)"oracle.adf.share.weblogic.WLSThreadLocalManager");
                Method mth = managerClz.getMethod("updateThreadLocal", ThreadLocal.class, Object.class, Runnable.class);
                mth.invoke(null, local, value, resetHandler);
            }
            catch (Exception e) {
                logger.severe("Could not register ThreadLocal with WLS", (Throwable)e);
            }
        }
    }

    @Deprecated
    public boolean isWebsphereRuntime() {
        return false;
    }

    @Deprecated
    public boolean isJBossRuntime() {
        return false;
    }

    public Connection getNativeJdbcConnection(Connection datasourceJdbcConnection) {
        return this.getNativeDBConnection(datasourceJdbcConnection, null);
    }

    public Connection getNativeDBConnection(Connection datasourceJdbcConnection, Class targetUnwrapClass) {
        try {
            return AdfPlatformFactoryResolver.getAdfServerPlatformSupport().getNativeDBConnection(datasourceJdbcConnection, targetUnwrapClass);
        }
        catch (Throwable t) {
            logger.severe(t.getMessage());
            return datasourceJdbcConnection;
        }
    }

    public static boolean isTomcat() {
        return AdfServerPlatformUtil.isTomcat();
    }

    protected ADFContextMDSConfigHelper getMDSConfigHelper() {
        block5: {
            if (this._mdsConfigHelper != null) {
                return this._mdsConfigHelper;
            }
            if (AdfServerPlatformUtil.isMDSAvailable()) {
                try {
                    Class MDSHelperClass = ClassUtils.forName((String)"oracle.adf.share.config.ADFContextMDSConfigHelperImpl", ADFContext.class);
                    this._mdsConfigHelper = (ADFContextMDSConfigHelper)MDSHelperClass.newInstance();
                }
                catch (Throwable e) {
                    if (!logger.isLoggable(Level.FINE)) break block5;
                    logger.fine(e);
                }
            }
        }
        if (this._mdsConfigHelper == null) {
            this._mdsConfigHelper = new NopMDSConfigHelper();
        }
        return this._mdsConfigHelper;
    }

    protected void setMDSConfigHelper(ADFContextMDSConfigHelper mdsConfig) {
        this._mdsConfigHelper = mdsConfig;
    }

    protected void setMDSSession(Object mdsSess) {
        this.mdsSession = mdsSess;
    }

    protected void setMDSContext(MDSAppContext mdsAppCtx) {
        this.setMDSSessionLock(mdsAppCtx.getADFContextMDSConfigHelper() != null ? ((ADFContextMDSLockConfigHelper)((Object)mdsAppCtx.getADFContextMDSConfigHelper())).isMDSSessionLocked() : false);
        this.setMDSContext(mdsAppCtx.getMDSSession(), mdsAppCtx.getADFContextMDSConfigHelper());
    }

    private void setMDSContext(Object mdsSess, ADFContextMDSConfigHelper adf) {
        this.setMDSConfigHelper(adf);
        this.setMDSSession(mdsSess);
    }

    protected void resetMDSAppCtx() {
        this.setMDSContext(null, null);
    }

    public static Object getThreadLocalValue(Object key) {
        ADFContext ctx = ADFContext.getCurrentInternal();
        if (ctx != null) {
            return ctx.mThreadLocalMap.get(key);
        }
        return null;
    }

    public static void setThreadLocalValue(Object key, Object value) {
        ADFContext.getCurrent().mThreadLocalMap.put(key, value);
    }

    public static Object removeThreadLocalValue(Object key) {
        ADFContext ctx = ADFContext.getCurrentInternal();
        if (ctx != null) {
            return ctx.mThreadLocalMap.remove(key);
        }
        return null;
    }

    protected void initialize() {
    }

    public static ADFContext initADFContext(Object context, Object session, Object request, Object response) {
        Throwable goodEnvLost = null;
        ADFContext oldContext = ADFContext.getCurrentInternal();
        ADFContext newContext = null;
        if (context != null) {
            ADFContextCreator.ParamContext pc = new ADFContextCreator.ParamContext(session, request, response);
            for (ADFContextCreator acc : ServiceLoader.load(ADFContextCreator.class, ClassUtils.getClassLoader(ADFContext.class))) {
                block8: {
                    try {
                        newContext = acc.initThreadContext(context, pc);
                    }
                    catch (Throwable t) {
                        if (!logger.isFine()) break block8;
                        logger.log(Level.FINE, "context=" + context, logger.isFinest() ? t : null);
                    }
                }
                if (newContext == null) continue;
                newContext.setAsCurrent();
                if (logger.isFine()) {
                    logger.fine("acc=" + acc + " created " + newContext);
                }
                break;
            }
        } else if (oldContext != null && scopeLogger.isSevere()) {
            goodEnvLost = new Throwable("DIAGNOSTIC AID, NOT AN ERROR", oldContext.mCreatedBy);
        }
        if (newContext == null) {
            newContext = ADFContext.createDefaultContext();
            newContext.goodEnvironmentLost = goodEnvLost;
        }
        newContext.initialize();
        return oldContext;
    }

    public static void resetADFContext(ADFContext ctx) {
        if (ctx == null) {
            ADFContext current = ADFContext.getCurrentInternal();
            if (current != null) {
                current.removeAsCurrent();
            }
        } else {
            ctx.setAsCurrent();
        }
    }

    public Map<String, Object> getPageFlowScope() {
        return this.uiScopeHelper.getPageFlowScopeMap(this);
    }

    String getTenantProperty(String propertyName) {
        String eid = null;
        String name = "";
        if (!this.isMultiTenantEnabled() && !MTHelper.getMultitenancyEnabled()) {
            return propertyName.equals(TENANT_GUID) ? eid : name;
        }
        TenantInfo tenantInfo = TenantService.getInstance();
        if (tenantInfo != null) {
            return propertyName.equals(TENANT_GUID) ? tenantInfo.getTenantId() : tenantInfo.getTenantName();
        }
        if (logger.isFinest()) {
            logger.finest("No tenant info available.");
        }
        return propertyName.equals(TENANT_GUID) ? eid : name;
    }

    private void dumpViewScopeLoadAttempt(Level level, Throwable t) {
        logger.log(level, this.getViewScopeMsg(null, null, null, null), t);
    }

    private void dumpViewScopeLoadAttempt(Level level, Throwable ex, Class contextClass, Object adfFacesContext, String methodName, Map<String, Object> appScope) {
        logger.log(level, this.getViewScopeMsg(contextClass, adfFacesContext, methodName, appScope), ex);
    }

    private String getViewScopeMsg(Class contextClass, Object adfFacesContext, String methodName, Map appScope) {
        StringBuilder buf = new StringBuilder();
        buf.append("ADFContext=" + this.getClass().getName());
        if (contextClass != null) {
            buf.append(" contextClass=" + contextClass);
        }
        if (adfFacesContext != null) {
            buf.append(" adfFacesContext=" + adfFacesContext);
        }
        if (methodName != null) {
            buf.append(" methodName=" + methodName);
        }
        if (appScope != null) {
            buf.append(" appScope=" + appScope);
        }
        this.dumpClassLoaders(buf);
        return buf.toString();
    }

    private void dumpClassLoaders(StringBuilder buf) {
        ClassLoader loader2;
        Thread thread = Thread.currentThread();
        ClassLoader tcLoader = ADFContext.getThreadContextClassLoader();
        this.dumpClassLoader(buf, tcLoader, "Thread: " + thread + "\nContextClassLoader");
        ClassLoader loader = ClassUtils.getClassLoader(this.getClass());
        if (tcLoader != loader) {
            this.dumpClassLoader(buf, loader, "refClassLoader for:" + this.getClass().getName());
        }
        if (loader != (loader2 = ClassUtils.getClassLoader())) {
            this.dumpClassLoader(buf, loader2, "classUtilsDefaultLoader");
        }
    }

    private void dumpClassLoader(StringBuilder buf, ClassLoader loader, String info) {
        buf.append("\n" + info + "\n");
        String prefix = "";
        while (loader != null) {
            buf.append(prefix + loader + "\n");
            prefix = prefix + "  ";
            loader = loader.getParent();
        }
    }

    private final String getSystemProperty(String propertyName) {
        if (System.getSecurityManager() == null) {
            return System.getProperty(propertyName);
        }
        return (String)AccessController.doPrivileged(new GetPropertyAction(propertyName));
    }

    private static final ClassLoader getThreadContextClassLoader() {
        if (System.getSecurityManager() == null) {
            return Thread.currentThread().getContextClassLoader();
        }
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }

    static {
        ClassLoader loader = ADFContext.getThreadContextClassLoader();
        try {
            Class<?> clazz = loader.loadClass(DEBUG_FACADE_CLASS);
            clazz.newInstance();
        }
        catch (Exception exception) {
            // empty catch block
        }
        _dtLinkage = null;
        nonUIScopeHelper = new ADFContextUIScopeHelper(){

            @Override
            public Map<String, Object> getPageFlowScopeMap(ADFContext ctx) {
                Map m = ctx.getRequestScope();
                PageFlowScopeException t = (PageFlowScopeException)m.get("__PAGE_FLOW_SCOPE__");
                if (t != null) {
                    throw t;
                }
                t = new PageFlowScopeException();
                m.put("__PAGE_FLOW_SCOPE__", t);
                throw t;
            }

            @Override
            public Map<String, Object> getViewScopeMap(ADFContext ctx) {
                return null;
            }
        };
    }

    private static class ProxiedUIScopeHelper
    extends ADFContextUIScopeHelper {
        private final String CN;
        private ADFContextUIScopeHelper inner = null;

        public ProxiedUIScopeHelper(String CN) {
            this.CN = CN;
        }

        private ADFContextUIScopeHelper getInner() {
            if (this.inner != null) {
                return this.inner;
            }
            ClassLoader cl = ClassUtils.getClassLoader(ADFContext.class);
            if (cl.getResource(this.CN.replace('.', '/') + ".class") != null) {
                try {
                    this.inner = (ADFContextUIScopeHelper)ADFContextUIScopeHelper.class.cast(ClassUtils.forName((String)this.CN, ADFContext.class).newInstance());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.inner == null) {
                this.inner = nonUIScopeHelper;
            }
            return this.inner;
        }

        @Override
        public Map<String, Object> getPageFlowScopeMap(ADFContext ctx) {
            return this.getInner().getPageFlowScopeMap(ctx);
        }

        @Override
        public Map<String, Object> getViewScopeMap(ADFContext ctx) {
            return this.getInner().getViewScopeMap(ctx);
        }
    }

    private static class LeakReporter
    implements Runnable {
        private final Throwable leak;

        public LeakReporter(Throwable leak) {
            this.leak = leak;
        }

        @Override
        public void run() {
            StringBuilder sb = new StringBuilder();
            sb.append(resBundle.getString("ADFCONTEXT_LEAK_ERROR"));
            if (this.leak != null) {
                sb.append("\n");
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                this.leak.printStackTrace(new PrintStream(baos));
                sb.append(baos.toString());
                sb.setLength(sb.length() - 1);
            } else {
                sb.append(" " + resBundle.getString("ADFCONTEXT_LEAK_ERROR2"));
            }
            logger.severe(sb.toString());
        }
    }
}

