/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.core.model.filter;

import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import oracle.dmt.dataminer.core.CoreErrorsLrb;
import oracle.dmt.dataminer.core.model.filter.SortDirection;
import oracle.dmt.dataminer.core.model.generated.server.OraMiningVarchar2Nt;

public class SortSpec {
    private String _attributeName;
    private SortDirection _sortDirection;
    private boolean _useIt;

    public SortSpec(String string, SortDirection sortDirection) {
        this(string, sortDirection, true);
    }

    public SortSpec(String string, SortDirection sortDirection, boolean bl) {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException(CoreErrorsLrb.get("SORT_ATTRIBUTE_NAME_ERROR"));
        }
        this._attributeName = string;
        this._sortDirection = sortDirection;
        this._useIt = bl;
    }

    public String getAttributeName() {
        return this._attributeName;
    }

    public SortDirection getSortDirection() {
        return this._sortDirection;
    }

    public String getSortSQLString() {
        return this._attributeName + " " + this._sortDirection.getSqlKeyword() + " ";
    }

    public boolean isAscending() {
        return this._sortDirection == SortDirection.ASCENDING;
    }

    public boolean isDecending() {
        return this._sortDirection == SortDirection.DESCENDING;
    }

    public void setAttributeName(String string) {
        this._attributeName = string;
    }

    public void setSortDirection(SortDirection sortDirection) {
        this._sortDirection = sortDirection;
    }

    public void setUseIt(boolean bl) {
        this._useIt = bl;
    }

    public boolean isUseIt() {
        return this._useIt;
    }

    public static String getSortSql(List<SortSpec> list) {
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<SortSpec> iterator = list.iterator();
        while (iterator.hasNext()) {
            SortSpec sortSpec = iterator.next();
            if (!sortSpec.isUseIt()) continue;
            stringBuilder.append(sortSpec.getSortSQLString());
            if (!iterator.hasNext()) continue;
            stringBuilder.append(", ");
        }
        return stringBuilder.toString();
    }

    public static OraMiningVarchar2Nt getSortCollection(List<SortSpec> list) throws SQLException {
        List<SortSpec> list2 = SortSpec.getEnabledSortSpec(list);
        OraMiningVarchar2Nt oraMiningVarchar2Nt = new OraMiningVarchar2Nt();
        String[] stringArray = new String[list2.size()];
        for (int i = 0; i < list2.size(); ++i) {
            SortSpec sortSpec = list2.get(i);
            stringArray[i] = sortSpec.getSortSQLString() + " ";
        }
        oraMiningVarchar2Nt.setArray(stringArray);
        return oraMiningVarchar2Nt;
    }

    public static List<SortSpec> getEnabledSortSpec(List<SortSpec> list) {
        return list.stream().filter(sortSpec -> sortSpec.isUseIt()).collect(Collectors.toList());
    }
}

