/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.core.model.common.build;

import java.math.BigDecimal;
import java.sql.Date;
import oracle.dmt.dataminer.core.model.CoreModelLrb;

public class ModelGeneralDescription {
    private String _owner;
    private String _comments;
    private String _algorithm;
    private String _modelName;
    private Date _creationDate;
    private BigDecimal _modelSize;
    private String _miningFunction;
    private BigDecimal _buildDuration;
    private String _targetAttributeName;
    public static final ModelGeneralDescription _NONE = new ModelGeneralDescription("", CoreModelLrb.get("MODEL_NOT_BUILT"), "", "", null, BigDecimal.ZERO, BigDecimal.ZERO, "");

    public ModelGeneralDescription() {
        this._owner = "";
        this._comments = "";
        this._modelName = "";
        this._algorithm = "";
        this._miningFunction = "";
    }

    public ModelGeneralDescription(String string, String string2, String string3, String string4, Date date, BigDecimal bigDecimal, BigDecimal bigDecimal2, String string5) {
        this._owner = string;
        this._comments = string5;
        this._algorithm = string4;
        this._modelName = string2;
        this._modelSize = bigDecimal2;
        this._creationDate = date;
        this._buildDuration = bigDecimal;
        this._miningFunction = string3;
    }

    public boolean isDecisionTreeAlgorithm() {
        return this.getAlgorithm().equals("DECISION_TREE");
    }

    public boolean isNaiveBayesAlgorithm() {
        return this.getAlgorithm().equals("NAIVE_BAYES");
    }

    public boolean isAdaptiveBayesNetworkAlgorithm() {
        return this.getAlgorithm().equals("ADAPTIVE_BAYES_NETWORK");
    }

    public boolean isSupportVectorMachinesAlgorithm() {
        return this.getAlgorithm().equals("SUPPORT_VECTOR_MACHINES");
    }

    public boolean isKmeansAlgorithm() {
        return this.getAlgorithm().equals("KMEANS");
    }

    public boolean isEMAlgorithm() {
        return this.getAlgorithm().equals("EXPECTATION_MAXIMIZATION");
    }

    public boolean isOClusterAlgorithm() {
        return this.getAlgorithm().equals("O_CLUSTER");
    }

    public boolean isNonnegativeMatrixFactorAlgorithm() {
        return this.getAlgorithm().equals("NONNEGATIVE_MATRIX_FACTOR");
    }

    public boolean isPrincipalComponentAnalysisAlgorithm() {
        return this.getAlgorithm().equals("PRINCIPAL_COMPONENT_ANALYSIS");
    }

    public boolean isSingularValueDecompositionAlgorithm() {
        return this.getAlgorithm().equals("SINGULAR_VALUE_DECOMP");
    }

    public boolean isAPrioriAssociationRulesAlgorithm() {
        return this.getAlgorithm().equals("APRIORI_ASSOCIATION_RULES");
    }

    public boolean isMinimumDescriptionLengthAlgorithm() {
        return this.getAlgorithm().equals("MINIMUM_DESCRIPTION_LENGTH");
    }

    public boolean isGeneralizedLinearModelAlgorithm() {
        return this.getAlgorithm().equals("GENERALIZED_LINEAR_MODEL");
    }

    public boolean isExplicitSemanticAnalysisAlgorithm() {
        return this.getAlgorithm().equals("EXPLICIT_SEMANTIC_ANALYS");
    }

    public boolean isClassificationModel() {
        return this.getMiningFunction().equals("CLASSIFICATION");
    }

    public boolean isRegressionModel() {
        return this.getMiningFunction().equals("REGRESSION");
    }

    public boolean isClusteringModel() {
        return this.getMiningFunction().equals("CLUSTERING");
    }

    public boolean isAttributeImportanceModel() {
        return this.getMiningFunction().equals("ATTRIBUTE_IMPORTANCE");
    }

    public boolean isAssociationRulesModel() {
        return this.getMiningFunction().equals("ASSOCIATION_RULES");
    }

    public boolean isAnomalyModel() {
        return this.getMiningFunction().equals("ANOMALY_DETECTION");
    }

    public boolean isFeatureExtractionModel() {
        return this.getMiningFunction().equals("FEATURE_EXTRACTION");
    }

    public boolean isExplicitFeatureExtractionModel() {
        return this.getMiningFunction().equals("EXPLICIT_FEATURE_EXTRACTION");
    }

    public void setOwner(String string) {
        this._owner = string;
    }

    public String getOwner() {
        return this._owner;
    }

    public void setModelName(String string) {
        this._modelName = string;
    }

    public String getModelName() {
        return this._modelName;
    }

    public void setMiningFunction(String string) {
        this._miningFunction = string;
    }

    public String getMiningFunction() {
        return this._miningFunction;
    }

    public void setAlgorithm(String string) {
        this._algorithm = string;
    }

    public String getAlgorithm() {
        return this._algorithm;
    }

    public void setCreationDate(Date date) {
        this._creationDate = date;
    }

    public Date getCreationDate() {
        return this._creationDate;
    }

    public void setBuildDuration(BigDecimal bigDecimal) {
        this._buildDuration = bigDecimal;
    }

    public BigDecimal getBuildDuration() {
        return this._buildDuration;
    }

    public void setModelSize(BigDecimal bigDecimal) {
        this._modelSize = bigDecimal;
    }

    public BigDecimal getModelSize() {
        return this._modelSize;
    }

    public void setComments(String string) {
        this._comments = string;
    }

    public String getComments() {
        return this._comments;
    }

    public void setTargetAttributeName(String string) {
        this._targetAttributeName = string;
    }

    public String getTargetAttributeName() {
        return this._targetAttributeName;
    }
}

