/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.core.model.ar;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import oracle.dmt.dataminer.core.model.ar.ItemSetStructure;
import oracle.dmt.dataminer.core.model.ar.PredicateRowData;
import oracle.dmt.dataminer.core.model.generated.server.DmRule;
import oracle.dmt.dataminer.core.utils.ObjectUtils;
import oracle.dmt.dataminer.core.utils.StringUtils;

public class RuleRowData {
    private Integer id;
    private List<PredicateRowData> antecedent;
    private PredicateRowData consequent;
    private Double support;
    private Double confidence;
    private Double reverseConfidence;
    private Double lift;
    private Double antecedentSupport;
    private Double consequentSupport;
    private Integer numberOfItems;
    private ItemSetStructure itemSetStructure;

    public RuleRowData(Integer n) {
        this.id = n;
        this.support = 0.0;
        this.confidence = 0.0;
        this.reverseConfidence = 0.0;
        this.lift = 0.0;
        this.antecedentSupport = 0.0;
        this.consequentSupport = 0.0;
        this.numberOfItems = 0;
        this.antecedent = new ArrayList<PredicateRowData>();
        this.consequent = new PredicateRowData();
    }

    public RuleRowData(DmRule dmRule) throws SQLException {
        this.id = dmRule.getRuleId();
        this.numberOfItems = dmRule.getNumberOfItems();
        if (dmRule.getRuleSupport() != null) {
            this.support = dmRule.getRuleSupport().doubleValue();
        }
        if (dmRule.getRuleConfidence() != null) {
            this.confidence = dmRule.getRuleConfidence().doubleValue();
        }
        if (dmRule.getRuleLift() != null) {
            this.lift = dmRule.getRuleLift().doubleValue();
        }
        if (dmRule.getAntecedentSupport() != null) {
            this.antecedentSupport = dmRule.getAntecedentSupport().doubleValue();
        }
        if (dmRule.getConsequentSupport() != null) {
            this.consequentSupport = dmRule.getConsequentSupport().doubleValue();
        }
        this.antecedent = PredicateRowData.createPredicatesFrom(dmRule.getAntecedent());
        List<PredicateRowData> list = PredicateRowData.createPredicatesFrom(dmRule.getConsequent());
        if (!list.isEmpty()) {
            this.consequent = list.get(0);
        }
    }

    public String getItemsToString(List<PredicateRowData> list) {
        StringBuilder stringBuilder = new StringBuilder(30);
        String[] stringArray = this.itemSetStructure.name().split("_");
        for (PredicateRowData predicateRowData : list) {
            boolean bl = false;
            String[] stringArray2 = stringArray;
            int n = stringArray2.length;
            block11: for (int i = 0; i < n; ++i) {
                String string;
                switch (string = stringArray2[i]) {
                    case "NAME": {
                        stringBuilder.append(predicateRowData.getAttributeName());
                        bl = true;
                        continue block11;
                    }
                    case "SUBNAME": {
                        String string2 = predicateRowData.getAttributeSubname();
                        if (!StringUtils.isNotEmpty(string2)) continue block11;
                        if (bl) {
                            stringBuilder.append(".");
                        }
                        stringBuilder.append(string2);
                        continue block11;
                    }
                    case "VALUE": {
                        String string3 = predicateRowData.getValue();
                        if (!StringUtils.isNotEmpty(string3) || "0".equals(string3)) continue block11;
                        stringBuilder.append(" = ");
                        stringBuilder.append(predicateRowData.getValue());
                        continue block11;
                    }
                    default: {
                        assert (false) : "Invalid option";
                        continue block11;
                    }
                }
            }
            stringBuilder.append(" AND ");
        }
        stringBuilder.delete(stringBuilder.length() - 5, stringBuilder.length());
        return stringBuilder.toString();
    }

    public String getFullAntecedent() {
        return this.getItemsToString(this.antecedent);
    }

    public String getFullConsequent() {
        return this.getItemsToString(Collections.singletonList(this.consequent));
    }

    public void setId(Integer n) {
        this.id = n;
    }

    public Integer getId() {
        return this.id;
    }

    public void setSupport(Double d) {
        this.support = d;
    }

    public Double getSupport() {
        return this.support;
    }

    public void setConfidence(Double d) {
        this.confidence = d;
    }

    public Double getConfidence() {
        return this.confidence;
    }

    public void setReverseConfidence(Double d) {
        this.reverseConfidence = d;
    }

    public Double getReverseConfidence() {
        return this.reverseConfidence;
    }

    public void setLift(Double d) {
        this.lift = d;
    }

    public Double getLift() {
        return this.lift;
    }

    public void setAntecedentSupport(Double d) {
        this.antecedentSupport = d;
    }

    public Double getAntecedentSupport() {
        return this.antecedentSupport;
    }

    public void setConsequentSupport(Double d) {
        this.consequentSupport = d;
    }

    public Double getConsequentSupport() {
        return this.consequentSupport;
    }

    public void setNumberOfItems(Integer n) {
        this.numberOfItems = n;
    }

    public Integer getNumberOfItems() {
        return this.numberOfItems;
    }

    public void setAntecedent(List<PredicateRowData> list) {
        this.antecedent = list;
    }

    public List<PredicateRowData> getAntecedent() {
        return this.antecedent;
    }

    public void setConsequent(PredicateRowData predicateRowData) {
        this.consequent = predicateRowData;
    }

    public PredicateRowData getConsequent() {
        return this.consequent;
    }

    public String toString() {
        String string = "";
        String string2 = "";
        for (PredicateRowData predicateRowData : this.antecedent) {
            string = string + predicateRowData.getFullPredicate();
        }
        string2 = this.consequent.getFullPredicate();
        String string3 = "[RuleId = " + this.id + ", Antecedent = " + string + ", Consequent = " + string2 + ", Support = " + this.support + ", Confidence = " + this.confidence + ", lift = " + this.lift + ", Ant Support = " + this.antecedentSupport + ", Cons Support = " + this.consequentSupport + ", Items = " + this.numberOfItems + "]";
        return string3;
    }

    public void setItemSetStructure(ItemSetStructure itemSetStructure) {
        this.itemSetStructure = itemSetStructure;
    }

    public ItemSetStructure getItemSetStructure() {
        return this.itemSetStructure;
    }

    public boolean equals(Object object) {
        boolean bl = true;
        if (!(object instanceof RuleRowData)) {
            return false;
        }
        RuleRowData ruleRowData = (RuleRowData)object;
        boolean bl2 = bl = ObjectUtils.areEqual(this.id, ruleRowData.getId()) && ObjectUtils.areEqual(this.support, ruleRowData.getSupport()) && ObjectUtils.areEqual(this.confidence, ruleRowData.getConfidence()) && ObjectUtils.areEqual(this.reverseConfidence, ruleRowData.getReverseConfidence()) && ObjectUtils.areEqual(this.lift, ruleRowData.getLift()) && ObjectUtils.areEqual(this.antecedentSupport, ruleRowData.getAntecedentSupport()) && ObjectUtils.areEqual(this.consequentSupport, ruleRowData.getConsequentSupport()) && ObjectUtils.areEqual(this.numberOfItems, ruleRowData.getNumberOfItems());
        if (bl && this.antecedent.size() == ruleRowData.getAntecedent().size()) {
            int n = this.antecedent.size();
            PredicateRowData predicateRowData = null;
            PredicateRowData predicateRowData2 = null;
            List<PredicateRowData> list = Arrays.asList(new PredicateRowData[n]);
            List<PredicateRowData> list2 = Arrays.asList(new PredicateRowData[n]);
            Collections.copy(list, this.antecedent);
            Collections.copy(list2, ruleRowData.getAntecedent());
            Collections.sort(list);
            Collections.sort(list2);
            for (int i = 0; i < n; ++i) {
                predicateRowData = list.get(i);
                if (predicateRowData.equals(predicateRowData2 = list2.get(i))) continue;
                bl = false;
            }
        } else {
            bl = false;
        }
        return bl;
    }

    public int hashCode() {
        int n = 7;
        n += ObjectUtils.hashCode(this.id);
        n += ObjectUtils.hashCode(this.support);
        n += ObjectUtils.hashCode(this.confidence);
        n += ObjectUtils.hashCode(this.reverseConfidence);
        n += ObjectUtils.hashCode(this.lift);
        n += ObjectUtils.hashCode(this.antecedentSupport);
        n += ObjectUtils.hashCode(this.consequentSupport);
        n += ObjectUtils.hashCode(this.numberOfItems);
        n += ObjectUtils.hashCode(this.consequent);
        return n += ObjectUtils.hashCode(this.antecedent);
    }
}

