/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.core.dal.sql.queries.md;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import oracle.dmt.dataminer.core.dal.sql.queries.md.ExtractQuery;
import oracle.dmt.dataminer.core.model.common.build.RowDiagnosticTableDetails;
import oracle.dmt.dataminer.core.utils.StringUtils;
import oracle.dmt.dataminer.core.utils.db.DbVersionHelper;
import oracle.dmt.dataminer.workflow.xmlschema.MiningAlgorithmType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelDetailType;
import oracle.dmt.dataminer.workflow.xmlschema.RefModelType;
import oracle.javatools.util.Version;

public abstract class ModelDetailsQuery
extends ExtractQuery {
    static final String GET_MODEL_DETAILS_KM = "GET_MODEL_DETAILS_KM";
    static final String GET_MODEL_DETAILS_OC = "GET_MODEL_DETAILS_OC";
    static final String GET_MODEL_DETAILS_EM = "GET_MODEL_DETAILS_EM";
    static final String UNION_ALL = "\nUNION ALL\n";
    static final String MODEL_LIST = "MODEL_LIST";
    static final String ATTRIBUTE_LIST = "ATTRIBUTE_LIST";
    static final String MODEL_DETAILS_QUERY = "MODEL_DETAILS_QUERY";
    static final String GET_MODEL_NAME = "GET_MODEL_NAME";
    static final String MODEL_SCHEMA_VALUE = "MODEL_SCHEMA_VALUE";
    static final String MODEL_NAME_VALUE = "MODEL_NAME_VALUE";
    static final String LEAF_NODES_ONLY_QUERY = "LEAF_NODES_ONLY_QUERY";
    static final String MODEL_POSITION = "MODEL_POSITION";
    static final String ALGO_SOURCE = "ALGO_SOURCE";
    static final String GET_MODEL_DETAILS_CLUSTER_ALGO_FUNCTION = "GET_MODEL_DETAILS_CLUSTER_ALGO_FUNCTION";
    static final String GET_MODEL_DETAILS_FEATURE_ALGO_FUNCTION = "GET_MODEL_DETAILS_FEATURE_ALGO_FUNCTION";
    public static final String NODE_SQL_NAME = "NODE_SQL_NAME";
    public static final String SCHEMA_ONLY = "SCHEMA_ONLY:";
    public static final String ROW_DIAGNOSTICS = "ROW_DIAGNOSTICS:";
    public static final String CODE_GEN_WF_NODE_ID = "CODE_GEN_WF_NODE_ID:";
    private static final String VIRTUAL_FORMAT = "%s\n{$NODE_SQL_NAME} AS (\n%s\nORDER BY %s\n)";
    protected boolean hasWithBlock;
    protected boolean isCodeGenerationVersion;
    protected List<RefModelType> modelReferences;
    protected Map<String, RowDiagnosticTableDetails> rowDiagnosticTables;

    public ModelDetailsQuery(Version version, ModelDetailType modelDetailType) {
        this(version, modelDetailType, true);
    }

    public ModelDetailsQuery(Version version, ModelDetailType modelDetailType, boolean bl) {
        super(version);
        assert (modelDetailType != null) : "Output Type Cannot be Undefined";
        this.outputType = modelDetailType;
        if (bl) {
            this.initializeColumns();
            assert (this.outputColumns != null) : "Output Columns Cannot be Undefined";
        }
    }

    public ModelDetailsQuery(Version version, ModelDetailType modelDetailType, List<RefModelType> list, Map<String, RowDiagnosticTableDetails> map, boolean bl) {
        this(version, modelDetailType, true);
        this.modelReferences = list;
        this.rowDiagnosticTables = map;
        this.isCodeGenerationVersion = bl;
    }

    public ModelDetailsQuery(Version version, ModelDetailType modelDetailType, List<RefModelType> list, Map<String, RowDiagnosticTableDetails> map, boolean bl, boolean bl2) {
        this(version, modelDetailType, bl2);
        this.modelReferences = list;
        this.rowDiagnosticTables = map;
        this.isCodeGenerationVersion = bl;
    }

    @Override
    public String getSQLCommand() {
        assert (this.modelReferences != null) : "Model List Cannot be Undefined";
        assert (this.rowDiagnosticTables != null) : "Diagnositic Tables Map Cannot be Undefined";
        String string = this.getSQLTemplate();
        this.addColumnAliasReplacements(this.getOutputColumnList());
        if (ModelDetailType.MODEL_SIGNATURE.equals((Object)this.outputType)) {
            this.addModelListReplacement();
        } else if (ModelDetailType.AD_COEFFICIENTS.equals((Object)this.outputType) || ModelDetailType.AR_RULES_STRING_VERSION.equals((Object)this.outputType) || ModelDetailType.AR_RULES_AGGREGATES_STRING_VERSION.equals((Object)this.outputType) || ModelDetailType.AR_FREQUENT_ITEM_SETS_TRANSACTIONAL_VERSION.equals((Object)this.outputType) || ModelDetailType.AR_FREQUENT_ITEM_SETS_AGGREGATES_TRANSACTIONAL_VERSION.equals((Object)this.outputType) || ModelDetailType.CENTROIDS.equals((Object)this.outputType) || ModelDetailType.CENTROID_SCORING.equals((Object)this.outputType) || ModelDetailType.CLUSTER_DETAILS.equals((Object)this.outputType) || ModelDetailType.CLUSTER_ATTRIBUTE_HISTOGRAMS.equals((Object)this.outputType) || ModelDetailType.CLUSTER_RULES.equals((Object)this.outputType) || ModelDetailType.DT_FULL_TREE.equals((Object)this.outputType) || ModelDetailType.DT_FULL_TREE_XML_VERSION.equals((Object)this.outputType) || ModelDetailType.DT_LEAF_NODES_ONLY.equals((Object)this.outputType) || ModelDetailType.DT_LEAF_NODES_ONLY_PROFILE_VERSION.equals((Object)this.outputType) || ModelDetailType.EM_COMPONENTS.equals((Object)this.outputType) || ModelDetailType.EM_PROJECTIONS.equals((Object)this.outputType) || ModelDetailType.FEATURE_PROJECTIONS.equals((Object)this.outputType) || ModelDetailType.GLMC_COEFFICIENTS_AND_STATISTICS.equals((Object)this.outputType) || ModelDetailType.GLMR_COEFFICIENTS_AND_STATISTICS.equals((Object)this.outputType) || ModelDetailType.GLMC_ROW_DIAGNOSTICS.equals((Object)this.outputType) || ModelDetailType.GLMR_ROW_DIAGNOSTICS.equals((Object)this.outputType) || ModelDetailType.GLOBAL_DETAILS.equals((Object)this.outputType) || ModelDetailType.NB_PAIR_PROBABILITIES.equals((Object)this.outputType) || ModelDetailType.NMF_DETAILS_TRANSACTIONAL_VERSION.equals((Object)this.outputType) || ModelDetailType.PCA_EIGENVALUES.equals((Object)this.outputType) || ModelDetailType.SVD_SINGULAR_VALUES.equals((Object)this.outputType) || ModelDetailType.SVMC_COEFFICIENTS.equals((Object)this.outputType) || ModelDetailType.R_MODEL_DETAILS.equals((Object)this.outputType)) {
            string = this.addModelsByUnionReplacements(string);
        } else {
            this.addSingleModelReplacements();
        }
        string = StringUtils.getReplacedString(string, this._replacements);
        return string;
    }

    private void addModelListReplacement() {
        String string = this.modelReferences.stream().map(refModelType -> StringUtils.addSingleQuotes(StringUtils.escapeSingleQuotesForSQL(refModelType.getSchema() + refModelType.getName()))).collect(Collectors.joining(","));
        this._replacements.put(MODEL_LIST, string);
    }

    private String addModelsByUnionReplacements(String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = this.getVirtualTables();
        ArrayList<String> arrayList = new ArrayList<String>();
        String string3 = "";
        String string4 = "";
        String string5 = "";
        String string6 = "";
        int n = 0;
        boolean bl = StringUtils.isNotEmpty(string2);
        for (RefModelType refModelType : this.modelReferences) {
            string6 = String.format("%d", n++);
            string3 = StringUtils.escapeSingleQuotesForSQL(StringUtils.addDoubleQuotes(refModelType.getSchema() + "\".\"" + refModelType.getName()));
            string4 = StringUtils.escapeSingleQuotesForSQL(refModelType.getName());
            string5 = this.isCodeGenerationVersion ? StringUtils.escapeSingleQuotesForSQL(SCHEMA_ONLY + string3) : StringUtils.escapeSingleQuotesForSQL(refModelType.getSchema());
            hashMap.put(MODEL_NAME_VALUE, string4);
            hashMap.put(MODEL_SCHEMA_VALUE, string5);
            if (bl) {
                hashMap.put(MODEL_POSITION, string6);
                stringBuilder.append(StringUtils.getReplacedString(string2, hashMap));
            }
            hashMap.put(GET_MODEL_NAME, string3);
            String string7 = this.getActualSource(refModelType.getMiningAlgorithm());
            if (StringUtils.isNotEmpty(string7)) {
                hashMap.put(ALGO_SOURCE, StringUtils.getReplacedString(string7, hashMap));
            }
            for (Map.Entry<String, String> entry : this.getSpecificColumns(refModelType.getMiningAlgorithm()).entrySet()) {
                hashMap.put(entry.getKey(), entry.getValue());
            }
            if (!DbVersionHelper.isDB122Up(this.dbVersion) && (ModelDetailType.GLMC_ROW_DIAGNOSTICS.equals((Object)this.outputType) || ModelDetailType.GLMR_ROW_DIAGNOSTICS.equals((Object)this.outputType))) {
                RowDiagnosticTableDetails rowDiagnosticTableDetails = this.rowDiagnosticTables.get(refModelType.getModelId());
                String string8 = rowDiagnosticTableDetails.getRowDiagnosticTableName();
                String string9 = rowDiagnosticTableDetails.getWorkflowNodeId();
                if (string8 == null || string8.length() == 0) {
                    throw new IllegalStateException("Model " + refModelType.getName() + " missing row diagnostic table name.");
                }
                if (this.isCodeGenerationVersion) {
                    string5 = StringUtils.escapeSingleQuotesForSQL(ROW_DIAGNOSTICS + string3 + CODE_GEN_WF_NODE_ID + string9);
                    hashMap.put("TABLE_NAME", string5);
                } else {
                    hashMap.put("TABLE_NAME", string8);
                }
            }
            arrayList.add(StringUtils.getReplacedString(string, hashMap));
            hashMap.clear();
        }
        String string9 = arrayList.stream().collect(Collectors.joining(UNION_ALL));
        if (bl) {
            return String.format(VIRTUAL_FORMAT, stringBuilder.toString(), string9, this.getUnionOrderBy());
        }
        return (String)string9 + this.getUnionOrderBy();
    }

    private void addSingleModelReplacements() {
        RefModelType refModelType = this.modelReferences.get(0);
        String string = StringUtils.escapeSingleQuotesForSQL("\"" + refModelType.getSchema() + "\".\"" + refModelType.getName()) + "\"";
        String string2 = StringUtils.escapeSingleQuotesForSQL(refModelType.getName());
        String string3 = this.isCodeGenerationVersion ? StringUtils.escapeSingleQuotesForSQL(SCHEMA_ONLY + string) : StringUtils.escapeSingleQuotesForSQL(refModelType.getSchema());
        this._replacements.put(GET_MODEL_NAME, string);
        this._replacements.put(MODEL_SCHEMA_VALUE, string3);
        this._replacements.put(MODEL_NAME_VALUE, string2);
        for (Map.Entry<String, String> entry : this.getSpecificColumns(refModelType.getMiningAlgorithm()).entrySet()) {
            this._replacements.put(entry.getKey(), entry.getValue());
        }
    }

    public void setCodeGenerationVersion(boolean bl) {
        this.isCodeGenerationVersion = bl;
    }

    protected String getActualSource(MiningAlgorithmType miningAlgorithmType) {
        return null;
    }

    protected String getVirtualTables() {
        return "";
    }

    protected String getUnionOrderBy() {
        return "";
    }

    protected Map<String, String> getSpecificColumns(MiningAlgorithmType miningAlgorithmType) {
        return Collections.emptyMap();
    }

    public boolean hasWithBlock() {
        return this.hasWithBlock;
    }
}

