/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.core.dal.sql.queries.md;

import java.util.List;
import java.util.Map;
import oracle.dmt.dataminer.core.dal.sql.queries.md.ModelDetailsQuery;
import oracle.dmt.dataminer.core.model.common.build.RowDiagnosticTableDetails;
import oracle.dmt.dataminer.core.utils.db.DbVersionHelper;
import oracle.dmt.dataminer.workflow.xmlschema.ModelDetailType;
import oracle.dmt.dataminer.workflow.xmlschema.RefModelType;
import oracle.javatools.util.Version;

public class ClusterCentroidScoringQuery
extends ModelDetailsQuery {
    public ClusterCentroidScoringQuery(Version version, ModelDetailType modelDetailType, List<RefModelType> list, Map<String, RowDiagnosticTableDetails> map, boolean bl) {
        super(version, modelDetailType, list, map, bl);
        assert (DbVersionHelper.isDB122Up(version)) : "Incompatible data base version, 12.2 or up is required.";
    }

    public ClusterCentroidScoringQuery(Version version, ModelDetailType modelDetailType) {
        super(version, modelDetailType);
        assert (DbVersionHelper.isDB122Up(version)) : "Incompatible data base version, 12.2 or up is required.";
    }

    @Override
    protected void initializeColumns() {
        this.outputColumns = new String[][]{{"MODEL_SCHEMA", "VARCHAR2"}, {"MODEL_NAME", "VARCHAR2"}, {"PARTITION_NAME", "VARCHAR2"}, {"ID", "VARCHAR2"}, {"CLUSTER_ID", "NUMBER"}, {"ATTRIBUTE_NAME", "VARCHAR2"}, {"ATTRIBUTE_SUBNAME", "VARCHAR2"}, {"VALUE", "BINARY_DOUBLE"}};
    }

    @Override
    protected String getSQLTemplate() {
        String string = "\n  SELECT CAST('{$MODEL_SCHEMA_VALUE}' AS VARCHAR2(128)) as \"{$MODEL_SCHEMA}\",\n  CAST('{$MODEL_NAME_VALUE}' AS VARCHAR2(128)) as \"{$MODEL_NAME}\",\n  PARTITION_NAME as \"{$PARTITION_NAME}\",\n  CLUSTER_ID as \"{$ID}\", \n  CAST(CLUSTER_NAME AS VARCHAR2(4000)) as \"{$CLUSTER_ID}\", \n  ATTRIBUTE_NAME as \"{$ATTRIBUTE_NAME}\" ,\n  ATTRIBUTE_SUBNAME as \"{$ATTRIBUTE_SUBNAME}\",\n  VALUE as \"{$VALUE}\"\n  FROM {$MODEL_SCHEMA_VALUE}.DM$VC{$MODEL_NAME_VALUE}\n";
        return string;
    }
}

