/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.core.dal.sql.queries.md;

import java.util.List;
import java.util.Map;
import oracle.dmt.dataminer.core.dal.sql.queries.md.ModelDetailsQuery;
import oracle.dmt.dataminer.core.model.ar.ARNodeSettings;
import oracle.dmt.dataminer.core.model.common.build.RowDiagnosticTableDetails;
import oracle.dmt.dataminer.core.utils.db.DbVersionHelper;
import oracle.dmt.dataminer.workflow.xmlschema.ModelDetailType;
import oracle.dmt.dataminer.workflow.xmlschema.RefModelType;
import oracle.javatools.util.Version;

public class AssociationItemSetAggregatesQuery
extends ModelDetailsQuery {
    static final int DEFAULT_COLUMN_NO = 9;
    private ARNodeSettings _nodeSettings;

    public AssociationItemSetAggregatesQuery(Version version, ModelDetailType modelDetailType, List<RefModelType> list, Map<String, RowDiagnosticTableDetails> map, ARNodeSettings aRNodeSettings, boolean bl) {
        super(version, modelDetailType, list, map, bl, false);
        assert (aRNodeSettings != null);
        this._nodeSettings = aRNodeSettings;
        this.initializeColumns();
    }

    public AssociationItemSetAggregatesQuery(Version version, ModelDetailType modelDetailType, ARNodeSettings aRNodeSettings) {
        super(version, modelDetailType, false);
        assert (aRNodeSettings != null);
        this._nodeSettings = aRNodeSettings;
        this.initializeColumns();
    }

    @Override
    protected void initializeColumns() {
        List<String> list = this._nodeSettings.getAggregates();
        this.outputColumns = new String[9 + list.size()][];
        this.outputColumns[0] = new String[]{"MODEL_SCHEMA", "VARCHAR2"};
        this.outputColumns[1] = new String[]{"MODEL_NAME", "VARCHAR2"};
        this.outputColumns[2] = new String[]{"PARTITION_NAME", "VARCHAR2"};
        this.outputColumns[3] = new String[]{"ID", "NUMBER"};
        this.outputColumns[4] = new String[]{"SUPPORT", "NUMBER"};
        this.outputColumns[5] = new String[]{"NUMBER_OF_ITEMS", "NUMBER"};
        this.outputColumns[6] = new String[]{"ATTRIBUTE_NAME", "VARCHAR2"};
        this.outputColumns[7] = new String[]{"ATTRIBUTE_SUBNAME", "VARCHAR2"};
        this.outputColumns[8] = new String[]{"ATTRIBUTE_VALUE", "VARCHAR2"};
        int n = 9;
        for (String string : list) {
            this.outputColumns[n++] = new String[]{string, "NUMBER"};
        }
    }

    @Override
    protected String getSQLTemplate() {
        if (DbVersionHelper.isDB122Up(this.dbVersion)) {
            this._builder = new StringBuilder("\n     SELECT CAST('{$MODEL_SCHEMA_VALUE}' AS VARCHAR2(128)) as \"{$MODEL_SCHEMA}\", \n     CAST('{$MODEL_NAME_VALUE}' AS VARCHAR2(128)) as \"{$MODEL_NAME}\", \n     PARTITION_NAME as \"{$PARTITION_NAME}\",\n     ITEMSET_ID as \"{$ID}\", \n     SUPPORT as \"{$SUPPORT}\", \n     NUMBER_OF_ITEMS as \"{$NUMBER_OF_ITEMS}\", \n     CAST('" + this._nodeSettings.getItemID() + "' AS VARCHAR(30)) as \"{$ATTRIBUTE_NAME}\", \n     ITEM_NAME as \"{$ATTRIBUTE_SUBNAME}\", \n     ITEM_VALUE as \"{$ATTRIBUTE_VALUE}\",\n");
            List<String> list = this._nodeSettings.getAggregates();
            for (String string : list) {
                this._builder.append(String.format("     %s AS \"{$%s}\",\n", string, string));
            }
            this._builder = new StringBuilder(this._builder.substring(0, this._builder.length() - 2));
            this._builder.append("\nFROM {$MODEL_SCHEMA_VALUE}.DM$VI{$MODEL_NAME_VALUE} V,\n     XMLTABLE('/itemset/item' \n       PASSING V.ITEMSET \n       COLUMNS \n         ITEM_NAME VARCHAR2(128) PATH 'item_name',\n         ITEM_VALUE VARCHAR2(128) PATH 'item_value',\n");
            for (String string : list) {
                this._builder.append(String.format("         %s NUMBER PATH '%s',\n", string, string));
            }
            this._builder = new StringBuilder(this._builder.substring(0, this._builder.length() - 2));
            this._builder.append(")");
            return this._builder.toString();
        }
        return "";
    }
}

