/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.core.dal.sql.queries.fe.common;

import java.sql.SQLException;
import oracle.dmt.dataminer.core.dal.sql.builder.Conditional;
import oracle.dmt.dataminer.core.dal.sql.queries.StringSearchQuery;
import oracle.dmt.dataminer.core.model.common.build.ModelDescriptor;
import oracle.dmt.dataminer.core.utils.StringUtils;
import oracle.dmt.dataminer.core.utils.db.DbVersionHelper;
import oracle.dmt.dataminer.workflow.xmlschema.ExplicitSemanticAnalysisModelType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelType;
import oracle.dmt.dataminer.workflow.xmlschema.NonNegativeMatrixFactorModelType;
import oracle.dmt.dataminer.workflow.xmlschema.PCAModelType;
import oracle.dmt.dataminer.workflow.xmlschema.SVDModelType;
import oracle.javatools.util.Version;
import oracle.jdbc.internal.OraclePreparedStatement;

public class SearchFeatureItemQuery
extends StringSearchQuery {
    private String column;
    private Class<? extends ModelType> type;

    public SearchFeatureItemQuery(Version version, Class<? extends ModelType> clazz, ModelDescriptor modelDescriptor, String string) {
        super(version, modelDescriptor);
        assert (clazz != null) : "Model Type Cannot be Null";
        this.type = clazz;
        this.column = string;
    }

    @Override
    protected String getSource() {
        assert (ExplicitSemanticAnalysisModelType.class.equals(this.type) || PCAModelType.class.equals(this.type) || SVDModelType.class.equals(this.type) || NonNegativeMatrixFactorModelType.class.equals(this.type)) : "Invalid Model Type";
        String string = null;
        if (DbVersionHelper.isDB122Up(this.dbVersion)) {
            if (ExplicitSemanticAnalysisModelType.class.equals(this.type)) {
                string = "{$SCHEMA}.DM$VA{$MODEL_NAME}";
            } else if (PCAModelType.class.equals(this.type) || SVDModelType.class.equals(this.type)) {
                string = "{$SCHEMA}.DM$VV{$MODEL_NAME}";
            } else if (NonNegativeMatrixFactorModelType.class.equals(this.type)) {
                string = "{$SCHEMA}.DM$VE{$MODEL_NAME}";
            }
        } else if (PCAModelType.class.equals(this.type) || SVDModelType.class.equals(this.type)) {
            string = "(\n    SELECT T.MAPPED_FEATURE_ID, T.ATTRIBUTE_NAME, T.ATTRIBUTE_SUBNAME, NULL ATTRIBUTE_VALUE\n    FROM TABLE(dbms_data_mining.GET_MODEL_DETAILS_SVD('{$SCHEMA}.{$MODEL_NAME}')) T\n)\n";
        } else if (NonNegativeMatrixFactorModelType.class.equals(this.type)) {
            string = "(\n    SELECT T.MAPPED_FEATURE_ID, S.ATTRIBUTE_NAME, S.ATTRIBUTE_SUBNAME, S.ATTRIBUTE_VALUE\n    FROM TABLE(dbms_data_mining.GET_MODEL_DETAILS_NMF('{$SCHEMA}.{$MODEL_NAME}')) T,\n    TABLE (T.ATTRIBUTE_SET) S\n)\n";
        }
        return string;
    }

    @Override
    protected String getColumn() {
        if (DbVersionHelper.isDB122Up(this.dbVersion)) {
            if (ExplicitSemanticAnalysisModelType.class.equals(this.type)) {
                return "ATTRIBUTE_SUBNAME";
            }
            return "ATTRIBUTE_VALUE";
        }
        if (NonNegativeMatrixFactorModelType.class.equals(this.type)) {
            return "ATTRIBUTE_VALUE";
        }
        return "ATTRIBUTE_SUBNAME";
    }

    @Override
    protected String getColumnExpression() {
        return String.format("UPPER(%s)", this.getColumn());
    }

    @Override
    protected String getAdditionalConditions() {
        return Conditional.equals("ATTRIBUTE_NAME", this.column);
    }

    public void setColumn(String string) {
        this.column = string;
    }

    @Override
    protected void setParameters(OraclePreparedStatement oraclePreparedStatement) throws SQLException {
        super.setParameters(oraclePreparedStatement);
        if (StringUtils.isNotEmpty(this.column)) {
            oraclePreparedStatement.setStringAtName("ATTRIBUTE_NAME", this.column);
        }
    }
}

