/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.core.dal.sql.queries.fe.common;

import java.sql.SQLException;
import oracle.dmt.dataminer.core.dal.sql.ISqlQuery;
import oracle.dmt.dataminer.core.dal.sql.builder.Conditional;
import oracle.dmt.dataminer.core.dal.sql.builder.Distinct;
import oracle.dmt.dataminer.core.dal.sql.builder.SqlBuilder;
import oracle.dmt.dataminer.core.dal.sql.mapping.common.tuple.SqlTuple2Mapper;
import oracle.dmt.dataminer.core.dal.sql.queries.SqlBaseModelQuery;
import oracle.dmt.dataminer.core.dal.sql.utils.SqlUtils;
import oracle.dmt.dataminer.core.model.common.build.ModelDescriptor;
import oracle.dmt.dataminer.core.model.common.queries.Tuple2;
import oracle.dmt.dataminer.core.utils.db.DbVersionHelper;
import oracle.javatools.util.Version;
import oracle.jdbc.OraclePreparedStatement;

public class GetFeaturesQuery
extends SqlBaseModelQuery<Tuple2<Integer, String>, OraclePreparedStatement> {
    private ISqlQuery<OraclePreparedStatement> query;

    public GetFeaturesQuery(Version version, ModelDescriptor modelDescriptor) {
        super(version, new SqlTuple2Mapper<Integer, String>(Integer.class, String.class), modelDescriptor);
        this.query = DbVersionHelper.isDB122Up(this.dbVersion) ? new Db122Query() : new OriginalQuery();
    }

    @Override
    protected String getSQLCommand() {
        return this.query.getSQLCommand();
    }

    @Override
    protected void setParameters(OraclePreparedStatement oraclePreparedStatement) throws SQLException {
        this.query.setParameters(oraclePreparedStatement);
    }

    private class Db122Query
    implements ISqlQuery<OraclePreparedStatement> {
        private Db122Query() {
        }

        @Override
        public String getSQLCommand() {
            SqlBuilder sqlBuilder = new SqlBuilder().select(Distinct.columns("FEATURE_ID", "FEATURE_NAME")).from(GetFeaturesQuery.this.getViewName("DM$VE")).where(Conditional.equals("PARTITION_NAME", GetFeaturesQuery.this.getPartitionId())).orderBy("FEATURE_ID");
            return sqlBuilder.toString();
        }

        @Override
        public void setParameters(OraclePreparedStatement oraclePreparedStatement) throws SQLException {
            SqlUtils.setStringAtName(oraclePreparedStatement, "PARTITION_NAME", GetFeaturesQuery.this.getPartitionId());
        }
    }

    private class OriginalQuery
    implements ISqlQuery<OraclePreparedStatement> {
        private OriginalQuery() {
        }

        @Override
        public String getSQLCommand() {
            return "SELECT DISTINCT FEATURE_ID, MAPPED_FEATURE_ID \nFROM TABLE(dbms_data_mining.get_model_details_svd(:model, NULL)) \nORDER BY FEATURE_ID";
        }

        @Override
        public void setParameters(OraclePreparedStatement oraclePreparedStatement) throws SQLException {
            oraclePreparedStatement.setStringAtName("model", GetFeaturesQuery.this.getQualifiedName());
        }
    }
}

