/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.core.dal.sql.queries.fe.common;

import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import oracle.dmt.dataminer.core.dal.sql.ISqlQuery;
import oracle.dmt.dataminer.core.dal.sql.builder.Conditional;
import oracle.dmt.dataminer.core.dal.sql.builder.SqlBuilder;
import oracle.dmt.dataminer.core.dal.sql.mapping.fe.common.GetCoefficientsMapper;
import oracle.dmt.dataminer.core.dal.sql.queries.SqlBaseModelQuery;
import oracle.dmt.dataminer.core.dal.sql.utils.SqlUtils;
import oracle.dmt.dataminer.core.model.common.build.ModelDescriptor;
import oracle.dmt.dataminer.core.model.fe.svd.SVDCoefficient;
import oracle.dmt.dataminer.core.model.filter.SortSpec;
import oracle.dmt.dataminer.core.utils.StringUtils;
import oracle.dmt.dataminer.core.utils.db.DbVersionHelper;
import oracle.javatools.util.Version;
import oracle.jdbc.OraclePreparedStatement;

public class GetCoefficientsQuery
extends SqlBaseModelQuery<SVDCoefficient, OraclePreparedStatement> {
    public static final String ATTRIBUTE_NAME_SUBNAME = "ATTRIBUTE_NAME_SUBNAME";
    private Object targetValue;
    private Integer fetchSize;
    private boolean sortByAbs;
    private List<SortSpec> sortSpecs;
    private ISqlQuery<OraclePreparedStatement> query;
    private static final String BASE_QUERY = "SELECT * FROM ( \n  SELECT CASE WHEN ATTRIBUTE_SUBNAME IS NOT NULL THEN \n             ATTRIBUTE_NAME || '.' || ATTRIBUTE_SUBNAME\n           ELSE \n             ATTRIBUTE_NAME \n           END ATTRIBUTE_NAME_SUBNAME, \n         VALUE \n  FROM ( \n    {$QUERY} \n  ) {$ORDER_BY} \n) {$FETCH_SIZE} \n";

    public GetCoefficientsQuery(Version version, ModelDescriptor modelDescriptor, Object object, List<SortSpec> list, boolean bl, Integer n) {
        super(version, new GetCoefficientsMapper(), modelDescriptor);
        this.targetValue = object != null ? object : "";
        this.sortByAbs = bl;
        this.fetchSize = n;
        this.sortSpecs = list != null ? SortSpec.getEnabledSortSpec(list) : Collections.emptyList();
        this.query = DbVersionHelper.isDB122Up(this.dbVersion) ? new Db122Query() : new OriginalQuery();
    }

    @Override
    protected String getSQLCommand() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("QUERY", this.query.getSQLCommand());
        hashMap.put("ORDER_BY", this.getSortSpec());
        hashMap.put("FETCH_SIZE", this.getFetchSize());
        String string = StringUtils.getReplacedString(BASE_QUERY, hashMap);
        return string;
    }

    @Override
    protected void setParameters(OraclePreparedStatement oraclePreparedStatement) throws SQLException {
        this.query.setParameters(oraclePreparedStatement);
    }

    private String getFetchSize() {
        return "WHERE ROWNUM <= " + this.fetchSize;
    }

    private String getSortSpec() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.sortSpecs.size() > 0) {
            stringBuilder.append("order by ");
            Iterator<SortSpec> iterator = this.sortSpecs.iterator();
            while (iterator.hasNext()) {
                SortSpec sortSpec = iterator.next();
                if ("VALUE".equalsIgnoreCase(sortSpec.getAttributeName())) {
                    if (this.sortByAbs) {
                        stringBuilder.append(" ABS");
                    }
                    stringBuilder.append(" (");
                    stringBuilder.append(sortSpec.getAttributeName());
                    stringBuilder.append(") ");
                } else {
                    stringBuilder.append(sortSpec.getAttributeName());
                }
                if (sortSpec.isAscending()) {
                    stringBuilder.append(" ASC ");
                } else {
                    stringBuilder.append(" DESC NULLS LAST ");
                }
                if (!iterator.hasNext()) continue;
                stringBuilder.append(" , ");
            }
        }
        return stringBuilder.toString();
    }

    private class Db122Query
    implements ISqlQuery<OraclePreparedStatement> {
        private Db122Query() {
        }

        @Override
        public String getSQLCommand() {
            SqlBuilder sqlBuilder = new SqlBuilder().select("ATTRIBUTE_NAME", "ATTRIBUTE_SUBNAME", "VALUE").from(GetCoefficientsQuery.this.getViewName("DM$VV")).where(Conditional.equals("PARTITION_NAME", GetCoefficientsQuery.this.getPartitionId()), Conditional.equals("FEATURE_NAME", GetCoefficientsQuery.this.targetValue.toString()));
            return sqlBuilder.toString();
        }

        @Override
        public void setParameters(OraclePreparedStatement oraclePreparedStatement) throws SQLException {
            SqlUtils.setStringAtName(oraclePreparedStatement, "PARTITION_NAME", GetCoefficientsQuery.this.getPartitionId());
            SqlUtils.setStringAtName(oraclePreparedStatement, "FEATURE_NAME", GetCoefficientsQuery.this.targetValue.toString());
        }
    }

    private class OriginalQuery
    implements ISqlQuery<OraclePreparedStatement> {
        private OriginalQuery() {
        }

        @Override
        public String getSQLCommand() {
            return "SELECT ATTRIBUTE_NAME, ATTRIBUTE_SUBNAME, VALUE\n    FROM TABLE(dbms_data_mining.get_model_details_svd(:model))\n    WHERE MATRIX_TYPE = 'V' AND MAPPED_FEATURE_ID = :feature_id";
        }

        @Override
        public void setParameters(OraclePreparedStatement oraclePreparedStatement) throws SQLException {
            oraclePreparedStatement.setStringAtName("model", GetCoefficientsQuery.this.getQualifiedName());
            oraclePreparedStatement.setStringAtName("feature_id", GetCoefficientsQuery.this.targetValue.toString());
        }
    }
}

